/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.JmolPanel;
import bilab.Notify;
import bilab.ViewerBase;
import bilab.molecule;
import java.awt.Frame;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.openscience.jmol.viewer.JmolViewer;
import scigol.Debug;

public class JMolViewer
extends ViewerBase {
    public static final String inlinePrefix = "molecule://";
    Composite embed;
    Composite fixed;
    Frame compositeFrame;
    JmolPanel jmolPanel;
    molecule mol;

    public JMolViewer(Composite parent) {
        this.fixed = new Composite(parent, 2048);
        this.fixed.setLayout((Layout)new FillLayout());
        this.fixed.setSize(300, 300);
        this.embed = new Composite(this.fixed, 0x1000000);
        this.compositeFrame = SWT_AWT.new_Frame((Composite)this.embed);
        this.jmolPanel = new JmolPanel();
        this.compositeFrame.add(this.jmolPanel);
        this.mol = null;
    }

    public Point preferedSize() {
        return new Point(200, 200);
    }

    public Point maximumSize() {
        return new Point(1024, 1024);
    }

    public String get_title() {
        if (this.mol == null) {
            return "molecule [JMol]";
        }
        return String.valueOf(this.mol.get_name()) + " [JMol]";
    }

    public String get_description() {
        if (this.mol == null) {
            return "molecule: none";
        }
        return "molecule: " + this.mol.get_DetailText();
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.fixed;
    }

    public Object getInput() {
        return this.mol;
    }

    public void refresh() {
        this.fixed.redraw();
    }

    public void setInput(Object input) {
        if (input == null) {
            this.mol = null;
        } else {
            Debug.Assert(input instanceof molecule);
            this.mol = (molecule)input;
        }
        JmolViewer jmolViewer = this.jmolPanel.getViewer();
        jmolViewer.setJmolDefaults();
        if (this.mol != null) {
            String res = this.mol.get_AssociatedResource();
            if (res != null) {
                if (res.startsWith(inlinePrefix)) {
                    res = res.substring(inlinePrefix.length());
                    jmolViewer.openStringInline(res);
                } else {
                    if (res.startsWith("file://")) {
                        res = res.substring(7);
                    }
                    jmolViewer.openFile(res);
                    String strError = jmolViewer.getOpenFileError();
                    if (strError != null) {
                        Notify.userWarning((Object)this, "JMol error reading molecule resource '" + res + "' - " + strError);
                    }
                    jmolViewer.evalString("ribbons ON; color ribbons structure");
                    jmolViewer.scaleFitToScreen();
                    jmolViewer.setZoomEnabled(true);
                }
            } else {
                Debug.Unimplemented();
            }
            jmolViewer.scaleFitToScreen();
        } else {
            Notify.devWarning((Object)this, "JMolViewer.setInput() - molecule model is null");
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Debug.WL("JMolViewer.selectionChanged() unimplemented");
    }
}

