/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.BilabPlugin;
import bilab.IResourceIOProvider;
import bilab.ResourceManager;
import bilab.Sophistication;
import bilab.Summary;
import bilab.molecule;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.ChemObjectReader;
import org.openscience.cdk.io.DummyReader;
import org.openscience.cdk.io.ReaderFactory;
import scigol.Any;
import scigol.Debug;
import scigol.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Sophistication(value=3)
public class MoleculeImpl
implements molecule,
IResourceIOProvider {
    private static final List<String> supportedImportResourceTypes = new LinkedList<String>();
    private static final List<String> supportedExportResourceTypes;
    protected String _name;
    protected boolean structureKnown;
    protected Molecule mol;
    protected String associatedResource;
    protected Map _annotation;
    private static boolean initializedStaticMolecules;
    public static molecule A;
    public static molecule C;
    public static molecule G;
    public static molecule T;
    public static molecule U;
    public static molecule Ala;
    public static molecule Arg;
    public static molecule Asn;
    public static molecule Asp;
    public static molecule Cys;
    public static molecule Gln;
    public static molecule Glu;
    public static molecule Gly;
    public static molecule His;
    public static molecule Ile;
    public static molecule Leu;
    public static molecule Lys;
    public static molecule Met;
    public static molecule Phe;
    public static molecule Pro;
    public static molecule Ser;
    public static molecule Thr;
    public static molecule Trp;
    public static molecule Tyr;
    public static molecule Val;
    public static molecule Water;

    static {
        supportedImportResourceTypes.add("pdb");
        supportedImportResourceTypes.add("pqs");
        supportedImportResourceTypes.add("mol");
        supportedImportResourceTypes.add("sdf");
        supportedImportResourceTypes.add("xyz");
        supportedExportResourceTypes = new LinkedList<String>();
        initializedStaticMolecules = false;
    }

    public MoleculeImpl(String name) {
        this._name = name;
        this.mol = null;
        this.associatedResource = null;
        this._annotation = new Map();
        this.structureKnown = false;
        if (!initializedStaticMolecules) {
            this.initializeStaticMolecules(BilabPlugin.getResourceManager());
        }
    }

    public static List<String> getSupportedImportResourceTypes() {
        return supportedImportResourceTypes;
    }

    public static List<String> getSupportedExportResourceTypes() {
        return supportedExportResourceTypes;
    }

    @Summary(value="create a molecule from a resource containing data in a supported format")
    public static Object importResource(ResourceManager rm, String resourceName, String resourceType) {
        scigol.List mols = new scigol.List();
        InputStreamReader streamReader = null;
        try {
            try {
                streamReader = new InputStreamReader(rm.findResourceStream(resourceName));
                if (streamReader == null) {
                    throw new BilabException("unable to open resource:" + resourceName);
                }
                ChemObjectReader reader = null;
                reader = new ReaderFactory().createReader((Reader)streamReader);
                if (reader == null || reader instanceof DummyReader) {
                    throw new BilabException("unknown molecule file format");
                }
                ChemFile chemFile = (ChemFile)reader.read((ChemObject)new ChemFile());
                if (chemFile == null) {
                    throw new BilabException("unable to interpt stream as a molecule:" + resourceName);
                }
                int cs = 0;
                while (cs < chemFile.getChemSequenceCount()) {
                    ChemSequence chemSeq = chemFile.getChemSequence(cs);
                    int cm = 0;
                    while (cm < chemSeq.getChemModelCount()) {
                        ChemModel chemModel = chemSeq.getChemModel(cm);
                        SetOfMolecules molSet = chemModel.getSetOfMolecules();
                        int mi = 0;
                        while (mi < molSet.getMoleculeCount()) {
                            MoleculeImpl m = new MoleculeImpl(resourceName);
                            m.mol = molSet.getMolecule(mi);
                            m.structureKnown = true;
                            m.associatedResource = rm.findResource(resourceName).toString();
                            m._name = m.mol.getID();
                            try {
                                if (m._name == null) {
                                    m._name = new File(new URI(m.associatedResource)).getName();
                                }
                            }
                            catch (Exception exception) {
                                m._name = "<unknown>";
                            }
                            mols.add(m);
                            ++mi;
                        }
                        ++cm;
                    }
                    ++cs;
                }
            }
            catch (IOException iOException) {
                throw new BilabException("unable to locate resource to import as molecule: " + resourceName);
            }
            catch (CDKException e) {
                throw new BilabException("unable to import resource " + resourceName + " as molecule due to CDK error: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            try {
                streamReader.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            streamReader.close();
        }
        catch (Exception exception) {}
        if (mols.get_size() == 1) {
            return mols.get_head().value;
        }
        return mols;
    }

    @Summary(value="create a resource containing data in a supported format from a molecule")
    public static void exportResource(ResourceManager rm, molecule m, String resourceName, String resourceType) {
        Debug.Unimplemented();
    }

    @Override
    public boolean get_StructureKnown() {
        return this.structureKnown;
    }

    @Override
    public String get_name() {
        return this._name;
    }

    public void set_name(String value) {
        this._name = value;
    }

    @Override
    public String get_ShortText() {
        return this._name;
    }

    @Override
    public String get_DetailText() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    @Override
    public String get_AssociatedResource() {
        return this.associatedResource;
    }

    @Override
    public Map get_annotations() {
        return this._annotation;
    }

    public Any get_annotation(String key) {
        return this.get_annotations().get_Item(key);
    }

    private void initializeStaticMolecules(ResourceManager rm) {
        initializedStaticMolecules = true;
        A = this.fromResource(rm, "adenine.mol", "Adenine");
        C = this.fromResource(rm, "cytosine.mol", "Cytosine");
        G = this.fromResource(rm, "guanine.mol", "Guanine");
        T = this.fromResource(rm, "thymine.mol", "Thymine");
        U = this.fromResource(rm, "uracil.mol", "Uracil");
        Ala = this.fromResource(rm, "ala.pdb", "Alanine");
        Arg = this.fromResource(rm, "arg.pdb", "Arginine");
        Asn = this.fromResource(rm, "asn.pdb", "Asparagine ");
        Asp = this.fromResource(rm, "asp.pdb", "Aspartate ");
        Cys = this.fromResource(rm, "cys.pdb", "Cysteine");
        Gln = this.fromResource(rm, "gln.pdb", "Glutamine");
        Glu = this.fromResource(rm, "glu.pdb", "Glutamate");
        Gly = this.fromResource(rm, "gly.pdb", "Glycine");
        His = this.fromResource(rm, "his.pdb", "Histidine");
        Ile = this.fromResource(rm, "ile.pdb", "Isoleucine");
        Leu = this.fromResource(rm, "leu.pdb", "Leucine");
        Lys = this.fromResource(rm, "lys.pdb", "Lysine");
        Met = this.fromResource(rm, "met.pdb", "Methionine");
        Phe = this.fromResource(rm, "phe.pdb", "Phenylalanine");
        Pro = this.fromResource(rm, "pro.pdb", "Proline");
        Ser = this.fromResource(rm, "ser.pdb", "Serine");
        Thr = this.fromResource(rm, "thr.pdb", "Threonine");
        Trp = this.fromResource(rm, "trp.pdb", "Tryptophan");
        Tyr = this.fromResource(rm, "tyr.pdb", "Tyrosine");
        Val = this.fromResource(rm, "val.pdb", "Valine");
        Water = this.fromResource(rm, "water.xyz", "Water");
    }

    private molecule fromResource(ResourceManager rm, String resName, String molName) {
        MoleculeImpl m = (MoleculeImpl)MoleculeImpl.importResource(rm, "molecules/" + resName, "unknown");
        m.set_name(molName);
        return m;
    }
}

