/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabPlugin;
import bilab.Notify;
import bilab.ResourceManager;
import bilab.Util;
import bilab.ValueSelection;
import bilab.ValueViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scigol.List;
import scigol.Value;

public class ValueView
extends ViewPart
implements ISelectionListener {
    private ValueViewer valueViewer;
    private Action openAction;
    private static ValueView instance = null;

    public ValueView() {
        instance = this;
    }

    public void createPartControl(Composite parent) {
        this.valueViewer = new ValueViewer(parent);
        List l = (List)Util.readResource((String)"molecules/1GP2.pdb", (String)"").value;
        this.setInput(new Value(l.get_head()));
        this.makeActions();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.valueViewer);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.openAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.openAction);
    }

    public void setInput(Value v) {
        this.valueViewer.setInput(v);
        String title = this.valueViewer.get_title();
        if (title.length() > 0) {
            this.setPartName(title);
            this.setContentDescription(this.valueViewer.get_description());
        } else {
            this.setPartName("Value");
            this.setContentDescription("");
        }
    }

    public void selectionChanged(IWorkbenchPart source, ISelection selection) {
        if (selection instanceof ValueSelection) {
            this.setInput(((ValueSelection)selection).value);
        }
        this.valueViewer.selectionChanged(source, selection);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this.valueViewer);
        super.dispose();
    }

    public void setFocus() {
        this.valueViewer.getControl().setFocus();
    }

    private void open() {
        String resName;
        Shell shell = this.valueViewer.getControl().getShell();
        FileDialog fileDialog = new FileDialog(shell, 4096);
        String selectedFile = fileDialog.open();
        if (selectedFile == null) {
            return;
        }
        ResourceManager rm = BilabPlugin.getResourceManager();
        Object o = rm.instantiateObjectFromResource(resName = ResourceManager.filenameToResourceName(selectedFile), "unknown");
        if (o != null) {
            this.setInput(new Value(o));
        } else {
            Notify.userWarning((Object)this, "unable to determine file content type for import.  File:" + selectedFile);
        }
    }

    private void makeActions() {
        this.openAction = new Action(){

            public void run() {
                ValueView.this.open();
            }
        };
        this.openAction.setText("Open");
        this.openAction.setToolTipText("Open file and show content");
        this.openAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
    }

    public static ValueView getInstance() {
        return instance;
    }
}

