/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabPlugin;
import bilab.IUserText;
import bilab.Notify;
import bilab.ValueSelection;
import bilab.ViewerBase;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import scigol.TypeSpec;
import scigol.Value;

public class ValueViewer
extends Viewer
implements ISelectionListener {
    private ISelectionChangedListener viewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ValueViewer.this.fireSelectionChanged(event);
        }
    };
    private Composite top;
    private Composite child;
    private Label label;
    private ViewerBase viewer;
    private Value input = null;

    public ValueViewer(Composite parent) {
        this.top = new Composite(parent, 0);
        this.top.setLayout((Layout)new FillLayout());
        this.child = new Composite(this.top, 0);
        this.child.setLayout((Layout)new FillLayout());
        this.label = new Label(this.child, 0);
        this.viewer = null;
        this.input = null;
        this.refresh();
    }

    public Control getControl() {
        return this.top;
    }

    public Point preferedSize() {
        if (this.viewer != null) {
            return this.viewer.preferedSize();
        }
        return this.top.computeSize(-1, -1);
    }

    public Point maximumSize() {
        if (this.viewer != null) {
            return this.viewer.maximumSize();
        }
        return this.top.computeSize(-1, -1);
    }

    public String get_title() {
        if (this.viewer != null) {
            return this.viewer.get_title();
        }
        return "";
    }

    public String get_description() {
        if (this.viewer != null) {
            return this.viewer.get_description();
        }
        return "";
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        if (input == this.input) {
            return;
        }
        if (!(input instanceof Value)) {
            return;
        }
        this.input = (Value)input;
        if (!this.child.isDisposed()) {
            this.child.dispose();
            this.label = null;
        }
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener(this.viewerListener);
            this.viewer.dispose();
            this.viewer = null;
        }
        this.child = new Composite(this.top, 0);
        this.child.setLayout((Layout)new FillLayout());
        if (input != null) {
            Object model = TypeSpec.unwrapAnyOrNum(input);
            this.viewer = BilabPlugin.getResourceManager().instantiateViewer(TypeSpec.typeOf(model), this.child);
        }
        if (this.viewer == null) {
            this.label = new Label(this.child, 0);
        } else {
            this.viewer.addSelectionChangedListener(this.viewerListener);
        }
        this.refresh();
    }

    public ISelection getSelection() {
        if (this.viewer != null) {
            return this.viewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection, reveal);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ValueSelection vs;
        if (selection instanceof ValueSelection && !(vs = (ValueSelection)selection).isEmpty()) {
            Object model = TypeSpec.unwrapAnyOrNum(vs.value);
            if (BilabPlugin.getResourceManager().existsViewer(TypeSpec.typeOf(model))) {
                try {
                    Notify.devInfo((Object)this, "setting viewer for type " + TypeSpec.typeOf(model) + " to input " + model.toString());
                    this.setInput(vs.value);
                }
                catch (Exception e) {
                    Notify.devWarning((Object)this, "exception setting input:" + e);
                    e.printStackTrace();
                }
                return;
            }
        }
        if (this.viewer != null) {
            this.viewer.selectionChanged(part, selection);
        }
    }

    public void refresh() {
        if (this.viewer == null) {
            if (this.input != null) {
                Object v = TypeSpec.unwrapAnyOrNum(this.input);
                if (v instanceof IUserText) {
                    this.label.setText(((IUserText)v).get_DetailText());
                } else if (v != null) {
                    this.label.setText(v.toString());
                } else {
                    this.label.setText("<no value>");
                }
            } else {
                this.label.setText("<no value>");
            }
        } else {
            this.viewer.setInput(TypeSpec.unwrapAnyOrNum(this.input));
            this.viewer.refresh();
        }
        this.top.layout(true);
        this.top.redraw();
    }
}

