/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.IAnnotated;
import bilab.IResourceIOProvider;
import bilab.ResourceManager;
import bilab.Sophistication;
import bilab.Summary;
import jalview.FormatAdapter;
import jalview.ScoreSequence;
import jalview.Sequence;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;
import scigol.Debug;
import scigol.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class alignment
extends scigol.List
implements IAnnotated,
IResourceIOProvider {
    @Sophistication(value=2)
    public Sequence[] alignedSeqs = new Sequence[0];
    @Sophistication(value=2)
    public ScoreSequence[] seqScores = new ScoreSequence[0];
    protected Map annotation = new Map();
    private static final List<String> supportedImportResourceTypes = new LinkedList<String>();
    private static final List<String> supportedExportResourceTypes;

    static {
        supportedImportResourceTypes.add("MSF");
        supportedImportResourceTypes.add("CLUSTALW");
        supportedImportResourceTypes.add("FASTA");
        supportedImportResourceTypes.add("BLC");
        supportedImportResourceTypes.add("PFAM");
        supportedExportResourceTypes = new LinkedList<String>();
        for (String s : supportedImportResourceTypes) {
            supportedExportResourceTypes.add(s);
        }
        supportedExportResourceTypes.add("PhylipMultiSeq");
    }

    @Override
    public Map get_annotations() {
        return this.annotation;
    }

    public static List<String> getSupportedImportResourceTypes() {
        return supportedImportResourceTypes;
    }

    public static List<String> getSupportedExportResourceTypes() {
        return supportedExportResourceTypes;
    }

    public static Object importResource(ResourceManager rm, String resourceName, String resourceType) {
        try {
            String jalViewType;
            String line;
            Debug.WL("alignment.importResource(): asked to import " + resourceName + " of type " + resourceType);
            InputStreamReader inputStreamReader = new InputStreamReader(rm.findResourceStream(resourceName));
            if (inputStreamReader == null) {
                throw new BilabException("unable to open resource:" + resourceName);
            }
            BufferedReader buffReader = new BufferedReader(inputStreamReader);
            StringBuilder inputString = new StringBuilder();
            do {
                if ((line = buffReader.readLine()) == null) continue;
                inputString.append(String.valueOf(line) + "\n");
            } while (line != null);
            inputStreamReader.close();
            if (resourceType.equals("CLUSTALW")) {
                jalViewType = "CLUSTAL";
            } else if (resourceType.equals("FASTA")) {
                jalViewType = "FASTA";
            } else if (resourceType.equals("MSF")) {
                jalViewType = "MSF";
            } else if (resourceType.equals("BLC")) {
                jalViewType = "BLC";
            } else if (resourceType.equals("PFAM")) {
                jalViewType = "PFAM";
            } else {
                throw new BilabException("unsupported alignment resource type:" + resourceType);
            }
            alignment aln = new alignment();
            aln.alignedSeqs = FormatAdapter.read(jalViewType, inputString.toString());
            aln.seqScores = new ScoreSequence[aln.alignedSeqs.length];
            int i = 0;
            while (i < aln.alignedSeqs.length) {
                aln.seqScores[i] = new ScoreSequence(aln.alignedSeqs[i]);
                ++i;
            }
            return aln;
        }
        catch (BilabException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BilabException("unable to locate/import resource as alignment(s): " + resourceName + " - " + e);
        }
    }

    @Summary(value="create a resource containing data in a supported format from a seq")
    public static void exportResource(ResourceManager rm, alignment a, String resourceName, String resourceType) {
        try {
            String outString = "";
            if (resourceType.equals("PhylipMultiSeq")) {
                Sequence seq2;
                StringBuilder sb = new StringBuilder();
                int seqLen = 0;
                Sequence[] sequenceArray = a.alignedSeqs;
                int n = 0;
                int n2 = sequenceArray.length;
                while (n < n2) {
                    seq2 = sequenceArray[n];
                    if (seq2.end > seqLen) {
                        seqLen = seq2.end;
                    }
                    ++n;
                }
                sb.append("  " + a.alignedSeqs.length + "   " + seqLen + "\n");
                sequenceArray = a.alignedSeqs;
                n = 0;
                n2 = sequenceArray.length;
                while (n < n2) {
                    seq2 = sequenceArray[n];
                    String rawSeq = seq2.getSequence();
                    String name = seq2.getName();
                    if (name.length() > 10) {
                        name = name.substring(0, 10);
                    } else if (name.length() < 10) {
                        name = String.valueOf(name) + "                                                                                               ".substring(0, 10 - name.length());
                    }
                    sb.append(name);
                    rawSeq = rawSeq.replace(".", "-");
                    sb.append(String.valueOf(rawSeq) + "\n");
                    ++n;
                }
                outString = sb.toString();
            } else {
                String jalViewType;
                if (resourceType.equals("CLUSTALW")) {
                    jalViewType = "CLUSTAL";
                } else if (resourceType.equals("FASTA")) {
                    jalViewType = "FASTA";
                } else if (resourceType.equals("MSF")) {
                    jalViewType = "MSF";
                } else if (resourceType.equals("BLC")) {
                    jalViewType = "BLC";
                } else if (resourceType.equals("PFAM")) {
                    jalViewType = "PFAM";
                } else {
                    throw new BilabException("unsupported alignment resource type:" + resourceType);
                }
                outString = FormatAdapter.get(jalViewType, a.alignedSeqs);
            }
            OutputStream outStream = rm.createResourceStream(resourceName);
            OutputStreamWriter outStreamWriter = new OutputStreamWriter(outStream);
            BufferedWriter buffWriter = new BufferedWriter(outStreamWriter);
            buffWriter.write(outString);
            buffWriter.flush();
            outStream.close();
        }
        catch (Exception exception) {
            throw new BilabException("unable to export sequence as resource: " + resourceName);
        }
    }

    @Override
    public String toString() {
        String s = "alignment(";
        int i = 0;
        while (i < this.alignedSeqs.length) {
            s = String.valueOf(s) + this.alignedSeqs[i].name;
            if (i != this.alignedSeqs.length - 1) {
                s = String.valueOf(s) + ",";
            }
            ++i;
        }
        s = String.valueOf(s) + ")";
        return s;
    }
}

