/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ColorSelect;
import jalview.ColourCanvas;
import jalview.ColourPanel;
import jalview.ResidueProperties;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ColourChooserPanel
extends Panel {
    Vector cp;
    ColourPanel none;
    Color[] color;
    ColorSelect cs;
    Hashtable hash;
    Frame f;
    AlignFrame af;

    public ColourChooserPanel(AlignFrame af, Color[] color) {
        this.af = af;
        this.color = color;
        this.cs = new ColorSelect();
        this.hash = new Hashtable();
        this.makeHash(color);
        this.cp = new Vector(this.hash.size());
        Enumeration e = this.hash.keys();
        int count = 0;
        while (e.hasMoreElements()) {
            Color c = (Color)e.nextElement();
            String s = (String)this.hash.get(c);
            this.cp.addElement(new ColourPanel(c, s));
            ++count;
        }
        Panel p = new Panel();
        p.setLayout(new GridLayout(this.cp.size() + 1, 1));
        int i = 0;
        while (i < this.cp.size()) {
            p.add((ColourPanel)this.cp.elementAt(i));
            ++i;
        }
        p.resize(250, (this.cp.size() + 1) * 50);
        p.invalidate();
        this.setLayout(new BorderLayout());
        this.add("Center", p);
        Panel p2 = new Panel();
        p2.setLayout(new BorderLayout());
        p2.add("Center", this.cs);
        this.cs.resize(this.size().width, 150);
        p2.resize(this.size().width, 150);
        this.add("South", p2);
    }

    public void makeHash(Color[] color) {
        int i = 0;
        while (i < color.length) {
            if (this.hash.containsKey(color[i])) {
                String tmp = (String)this.hash.get(color[i]);
                String res = this.findResidueString(i);
                this.hash.put(color[i], String.valueOf(tmp) + res);
            } else {
                String res = this.findResidueString(i);
                this.hash.put(color[i], res);
            }
            ++i;
        }
    }

    public void updateHash() {
        int i = 0;
        while (i < this.cp.size()) {
            Color tmp = ((ColourPanel)this.cp.elementAt((int)i)).cc.c;
            ((ColourPanel)this.cp.elementAt(i)).setString((String)this.hash.get(tmp));
            ++i;
        }
    }

    public String findResidueString(int i) {
        Enumeration e = ResidueProperties.aaHash.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            int num = (Integer)ResidueProperties.aaHash.get(key);
            if (i != num) continue;
            return key;
        }
        return null;
    }

    public void makeArray() {
        Enumeration e = this.hash.keys();
        while (e.hasMoreElements()) {
            Color key = (Color)e.nextElement();
            String restr = (String)this.hash.get(key);
            int i = 0;
            while (i < restr.length()) {
                String res = restr.substring(i, i + 1);
                int num = ResidueProperties.aaHash.size();
                try {
                    num = (Integer)ResidueProperties.aaHash.get(res);
                    this.color[num] = key;
                }
                catch (Exception exception) {}
                ++i;
            }
        }
    }

    public void changeColour(ColourPanel cp) {
        String tmp;
        String oldres = cp.s;
        String resstr = cp.getString();
        int i = 0;
        while (i < oldres.length()) {
            tmp = oldres.substring(i, i + 1);
            if (resstr.indexOf(tmp) < 0) {
                this.hash.put(Color.white, this.hash.get(Color.white) + tmp);
            }
            ++i;
        }
        i = 0;
        while (i < resstr.length()) {
            tmp = resstr.substring(i, i + 1);
            Enumeration e = this.hash.keys();
            while (e.hasMoreElements()) {
                Color key = (Color)e.nextElement();
                if (((String)this.hash.get(key)).indexOf(tmp) < 0) continue;
                String tmp2 = (String)this.hash.get(key);
                tmp2 = String.valueOf(tmp2.substring(0, tmp2.indexOf(tmp))) + tmp2.substring(tmp2.indexOf(tmp) + 1);
                this.hash.put(key, tmp2);
            }
            ++i;
        }
        this.hash.put(cp.cc.c, resstr);
        this.updateHash();
    }

    public boolean handleEvent(Event e) {
        Button b;
        if (e.target instanceof Button && e.id == 1001 && (b = (Button)e.target).getParent() instanceof ColourPanel) {
            ColourPanel tmp = (ColourPanel)b.getParent();
            this.changeColour(tmp);
            if (this.af != null) {
                this.makeArray();
                this.af.ap.color = this.color;
                this.af.ap.setSequenceColor();
                this.af.updateFont();
            }
            return true;
        }
        return super.handleEvent(e);
    }

    public boolean action(Event e, Object arg) {
        if (e.target instanceof TextField) {
            return false;
        }
        return super.action(e, arg);
    }

    public boolean mouseDown(Event e, int x, int y) {
        if (e.target instanceof ColourCanvas) {
            ColourCanvas cc = (ColourCanvas)e.target;
            if ((e.modifiers & 4) != 0) {
                this.cs.setColor(cc.c);
                this.cs.myColorPanel.pogCanvas.paint(this.cs.myColorPanel.pogCanvas.getGraphics());
            } else {
                this.cs.getColor();
                cc.c = this.cs.getColor();
                cc.repaint();
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        ColourChooserPanel cp = new ColourChooserPanel(null, ResidueProperties.color);
        f.setLayout(new BorderLayout());
        f.add("Center", cp);
        f.resize(cp.getPreferredSize().width, cp.getPreferredSize().height);
        f.show();
    }

    public Dimension getPreferredSize() {
        return new Dimension(((ColourPanel)this.cp.elementAt((int)0)).getPreferredSize().width, this.cp.size() * ((ColourPanel)this.cp.elementAt((int)0)).getPreferredSize().height + 150);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

