/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.FileParse;
import jalview.Format;
import jalview.Sequence;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MSFfile
extends FileParse {
    int noSeqs;
    int maxLength = 0;
    Hashtable myHash;
    Vector seqs;
    Vector headers;
    Vector words = new Vector();
    long start;
    long end;

    public MSFfile(String inStr) {
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.readLines(inStr);
        System.out.println(this.noLines);
        System.out.println(this.lineArray.size());
        this.parse();
    }

    public MSFfile(String inFile, String type) throws IOException {
        super(inFile, type);
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        System.out.print("Reading file....");
        this.readLines();
        System.out.println("done");
        System.out.println("Total time taken = " + (this.end - this.start) + "ms");
        System.out.println("Parsing file....");
        this.parse();
    }

    public void parse() {
        int i = 0;
        boolean seqFlag = false;
        String key = new String();
        i = 0;
        while (i < this.noLines) {
            StringTokenizer str = new StringTokenizer(this.lineArray.elementAt(i).toString());
            while (str.hasMoreTokens()) {
                String inStr = str.nextToken();
                if (inStr.indexOf("Name:") != -1) {
                    key = str.nextToken();
                    this.headers.addElement(key);
                    System.out.println(key);
                }
                if (inStr.indexOf("//") != -1) {
                    seqFlag = true;
                }
                if (inStr.indexOf("//") != -1 || !seqFlag) continue;
                key = inStr;
                StringBuffer tempseq = new StringBuffer();
                if (this.myHash.containsKey(key)) {
                    tempseq = new StringBuffer(this.myHash.get(key).toString());
                }
                while (str.hasMoreTokens()) {
                    tempseq.append(str.nextToken());
                }
                this.myHash.put(key, tempseq.toString());
            }
            ++i;
        }
        this.noSeqs = this.headers.size();
        i = 0;
        while (i < this.headers.size()) {
            if (this.myHash.get(this.headers.elementAt(i)) != null) {
                StringTokenizer st;
                String head = this.headers.elementAt(i).toString();
                String seq2 = this.myHash.get(head).toString();
                int start = 1;
                int end = seq2.length();
                if (this.maxLength < head.length()) {
                    this.maxLength = head.length();
                }
                if (head.indexOf("/") > 0 && (st = new StringTokenizer(head, "/")).countTokens() == 2) {
                    head = st.nextToken();
                    String tmp = st.nextToken();
                    if ((st = new StringTokenizer(tmp, "-")).countTokens() == 2) {
                        start = Integer.valueOf(st.nextToken());
                        end = Integer.valueOf(st.nextToken());
                    }
                }
                Sequence newSeq = new Sequence(head, seq2, start, end);
                this.seqs.addElement(newSeq);
            } else {
                System.out.println("Can't find sequence for " + this.headers.elementAt(i));
            }
            ++i;
        }
        this.end = System.currentTimeMillis();
        System.out.println("done");
    }

    public static int checkSum(String seq2) {
        int check = 0;
        String index = "--------------------------------------&---*---.-----------------@ABCDEFGHIJKLMNOPQRSTUVWXYZ------ABCDEFGHIJKLMNOPQRSTUVWXYZ----@";
        index = String.valueOf(index) + "--------------------------------------------------------------------------------------------------------------------------------";
        int i = 0;
        while (i < seq2.length()) {
            try {
                int pos;
                if (i < seq2.length() && !index.substring(pos = index.indexOf(seq2.substring(i, i + 1)), pos + 1).equals("_")) {
                    check += (i % 57 + 1) * pos;
                }
            }
            catch (Exception e) {
                System.err.println("Exception " + e);
            }
            ++i;
        }
        return check % 10000;
    }

    public static String print(Sequence[] s) {
        StringBuffer out = new StringBuffer("PileUp\n\n");
        int max = 0;
        int maxid = 0;
        int i = 0;
        String big = "";
        while (i < s.length && s[i] != null) {
            big = String.valueOf(big) + s[i].getSequence();
            ++i;
        }
        i = 0;
        int bigcheck = MSFfile.checkSum(big);
        out.append("   MSF: " + s[0].getSequence().length() + "   Type: P    Check:  " + bigcheck + "   ..\n\n\n");
        while (i < s.length && s[i] != null) {
            String seq2 = s[i].getSequence();
            String name = String.valueOf(s[i].getName()) + "/" + s[i].start + "-" + s[i].end;
            int check = MSFfile.checkSum(s[i].getSequence());
            out.append(" Name: " + name + " oo  Len:  " + s[i].getSequence().length() + "  Check:  " + check + "  Weight:  1.00\n");
            if (seq2.length() > max) {
                max = seq2.length();
            }
            if (name.length() > maxid) {
                maxid = name.length();
            }
            ++i;
        }
        if (maxid < 10) {
            maxid = 10;
        }
        ++maxid;
        out.append("\n\n//\n\n");
        int len = 50;
        int nochunks = max / len + 1;
        if (max % len == 0) {
            --nochunks;
        }
        i = 0;
        while (i < nochunks) {
            int j = 0;
            while (j < s.length && s[j] != null) {
                String name = s[j].getName();
                out.append(String.valueOf(new Format("%-" + maxid + "s").form(String.valueOf(name) + "/" + s[j].start + "-" + s[j].end)) + " ");
                int k = 0;
                while (k < 5) {
                    int start = i * 50 + k * 10;
                    int end = start + 10;
                    if (end < s[j].getSequence().length() && start < s[j].getSequence().length()) {
                        out.append(s[j].getSequence().substring(start, end));
                        if (k < 4) {
                            out.append(" ");
                        } else {
                            out.append("\n");
                        }
                    } else if (start < s[j].getSequence().length()) {
                        out.append(s[j].getSequence().substring(start));
                        out.append("\n");
                    } else if (k == 0) {
                        out.append("\n");
                    }
                    ++k;
                }
                ++j;
            }
            out.append("\n");
            ++i;
        }
        return out.toString();
    }
}

