/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.BinarySequence;
import jalview.Format;
import jalview.Matrix;
import jalview.Sequence;
import java.io.PrintStream;

public class PCA
implements Runnable {
    Matrix m;
    Matrix symm;
    Matrix m2;
    double[] eigenvalue;
    Matrix eigenvector;

    public PCA(Matrix m) {
        this.m = m;
    }

    public PCA(Sequence[] s) {
        Runtime rt = Runtime.getRuntime();
        BinarySequence[] bs = new BinarySequence[s.length];
        int ii = 0;
        while (ii < s.length && s[ii] != null) {
            bs[ii] = new BinarySequence(s[ii]);
            bs[ii].encode();
            ++ii;
        }
        BinarySequence[] bs2 = new BinarySequence[s.length];
        ii = 0;
        while (ii < s.length && s[ii] != null) {
            bs2[ii] = new BinarySequence(s[ii]);
            bs2[ii].blosumEncode();
            ++ii;
        }
        int count = 0;
        while (count < bs.length && bs[count] != null) {
            ++count;
        }
        double[][] seqmat = new double[count][bs[0].dbinary.length];
        double[][] seqmat2 = new double[count][bs2[0].dbinary.length];
        int i = 0;
        while (i < count) {
            seqmat[i] = bs[i].dbinary;
            seqmat2[i] = bs2[i].dbinary;
            ++i;
        }
        this.m = new Matrix(seqmat, count, bs[0].dbinary.length);
        this.m2 = new Matrix(seqmat2, count, bs2[0].dbinary.length);
        PCA.printMemory(rt);
    }

    public static void printMemory(Runtime rt) {
        System.out.println("Free memory = " + rt.freeMemory());
    }

    public double[] getEigenvector(int i) {
        return this.eigenvector.getColumn(i);
    }

    public double getEigenvalue(int i) {
        return this.eigenvector.d[i];
    }

    public float[][] getComponents(int l, int n, int mm) {
        return this.getComponents(l, n, mm, 1.0f);
    }

    public float[][] getComponents(int l, int n, int mm, float factor) {
        float[][] out = new float[this.m.rows][3];
        int i = 0;
        while (i < this.m.rows) {
            out[i][0] = (float)this.component(i, l) * factor;
            out[i][1] = (float)this.component(i, n) * factor;
            out[i][2] = (float)this.component(i, mm) * factor;
            ++i;
        }
        return out;
    }

    public double[] component(int n) {
        double[] out = new double[this.m.rows];
        int i = 0;
        while (i < this.m.rows) {
            out[i] = this.component(i, n);
            ++i;
        }
        return out;
    }

    public double component(int row, int n) {
        double out = 0.0;
        int i = 0;
        while (i < this.symm.cols) {
            out += this.symm.value[row][i] * this.eigenvector.value[i][n];
            ++i;
        }
        return out / this.eigenvector.d[n];
    }

    public void checkEigenvector(int n, PrintStream ps) {
        ps.println(" --- Eigenvector " + n + " --- ");
        double[] eigenv = this.eigenvector.getColumn(n);
        int i = 0;
        while (i < eigenv.length) {
            Format.print(ps, "%15.4f", eigenv[i]);
            ++i;
        }
        System.out.println();
        double[] neigenv = this.symm.vectorPostMultiply(eigenv);
        System.out.println(" --- symmat * eigenv / lambda --- ");
        if (this.eigenvector.d[n] > 1.0E-4) {
            int i2 = 0;
            while (i2 < neigenv.length) {
                Format.print(System.out, "%15.4f", neigenv[i2] / this.eigenvector.d[n]);
                ++i2;
            }
        }
        System.out.println();
    }

    public void run() {
        Matrix mt = this.m.transpose();
        this.eigenvector = mt.preMultiply(this.m2);
        this.symm = this.eigenvector.copy();
        System.currentTimeMillis();
        this.eigenvector.tred();
        System.currentTimeMillis();
        System.currentTimeMillis();
        this.eigenvector.tqli();
        System.currentTimeMillis();
    }
}

