/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignSeq;
import jalview.FileParse;
import jalview.Sequence;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PIRFile
extends FileParse {
    int noSeqs;
    int maxLength = 0;
    Hashtable myHash;
    Vector seqs;
    Vector headers;
    Vector words = new Vector();
    long start;
    long end;

    public PIRFile(String inStr) {
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.readLines(inStr);
        this.parse();
    }

    public PIRFile(String inFile, String type) throws IOException {
        super(inFile, type);
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        System.out.print("Reading file....");
        this.start = System.currentTimeMillis();
        this.readLines();
        this.end = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (this.end - this.start) + "ms");
        System.out.println("Parsing file....");
        this.start = System.currentTimeMillis();
        this.parse();
    }

    public void parse() {
        String id = "";
        String seq2 = "";
        int count = 0;
        boolean flag = false;
        int sstart = -1;
        int send = -1;
        int i = 0;
        while (i < this.lineArray.size()) {
            if (((String)this.lineArray.elementAt(i)).length() > 0) {
                if (((String)this.lineArray.elementAt(i)).indexOf(">P1;") == 0) {
                    flag = true;
                    if (count != 0) {
                        if (seq2.indexOf("*") > 0) {
                            seq2 = seq2.substring(0, seq2.indexOf("*"));
                        }
                        this.seqs.addElement(new Sequence(id, seq2, 1, seq2.length()));
                    }
                    ++count;
                    StringTokenizer str = new StringTokenizer((String)this.lineArray.elementAt(i), " ");
                    id = str.nextToken();
                    if ((id = id.substring(4)).indexOf("/") > 0) {
                        StringTokenizer st = new StringTokenizer(id, "/");
                        if (st.countTokens() == 2) {
                            id = st.nextToken();
                            String tmp = st.nextToken();
                            if ((st = new StringTokenizer(tmp, "-")).countTokens() == 2) {
                                sstart = Integer.valueOf(st.nextToken());
                                send = Integer.valueOf(st.nextToken());
                            } else {
                                sstart = -1;
                                send = -1;
                            }
                        } else {
                            sstart = -1;
                            send = -1;
                        }
                    }
                    String cfr_ignored_0 = (String)this.lineArray.elementAt(++i);
                    seq2 = "";
                } else {
                    StringTokenizer st = new StringTokenizer((String)this.lineArray.elementAt(i), " ");
                    while (st.hasMoreTokens()) {
                        seq2 = String.valueOf(seq2) + st.nextToken();
                    }
                }
            }
            ++i;
        }
        if (flag) {
            if (seq2.indexOf("*") > 0) {
                seq2 = seq2.substring(0, seq2.indexOf("*"));
            }
            if (sstart >= 0 && send >= 0) {
                this.seqs.addElement(new Sequence(id, seq2, sstart, send));
            } else {
                this.seqs.addElement(new Sequence(id, seq2, 1, seq2.length()));
            }
        }
    }

    public static String print(Sequence[] s, int len) {
        return PIRFile.print(s, len, true);
    }

    public static String print(Sequence[] s, int len, boolean gaps) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < s.length && s[i] != null) {
            String seq2 = "";
            if (gaps) {
                seq2 = String.valueOf(s[i].getSequence()) + "*";
            } else {
                seq2 = AlignSeq.extractGaps(s[i].getSequence(), "-");
                seq2 = AlignSeq.extractGaps(seq2, ".");
                seq2 = AlignSeq.extractGaps(seq2, " ");
                seq2 = String.valueOf(seq2) + "*";
            }
            out.append(">P1;" + s[i].getName() + "/" + s[i].start + "-" + s[i].end + "\n");
            out.append(" Dummy title\n");
            int nochunks = seq2.length() / len + 1;
            int j = 0;
            while (j < nochunks) {
                int start = j * len;
                int end = start + len;
                if (end < seq2.length()) {
                    out.append(String.valueOf(seq2.substring(start, end)) + "\n");
                } else if (start < seq2.length()) {
                    out.append(String.valueOf(seq2.substring(start)) + "\n");
                }
                ++j;
            }
            ++i;
        }
        return out.toString();
    }

    public static void main(String[] args) {
        String inStr = ">P1;LCAT_MOUSE_90.35\nMGLPGSPWQRVLLLLGLLLPPATPFWLLNVLFPPHTTPKAELSNHTRPVILVPGCLGNRLEAKLDKPDVVNW\nMCYRKTEDFFTIWLDFNLFLPLGVDCWIDNTRIVYNHSSGRVSNAPGVQIRVPGFGKTESVEYVDDNKLAGY\n\n>LCAT_PAPAN_95.78\nMGPPGSPWQWVPLLLGLLLPPAAPFWLLNVLFPPHTTPKAELSNHTRPVILVPGCLGNQLEAKLDKPDVVNW\nMCYRKTEDFFTIWLDLNMFLPLGVDCWIDNTRVVYNRSSGLVSNAPGVQIRVPGFGKTYSVEYLDSSKLAGY\nLHTLVQNLVNNGYVRDETVRAAPYDWRLEPGQQEEYYHKLAGLVEEMHAAYGKPVFLIGHSLGCLHLLYFLL\n";
        new PIRFile(inStr);
    }
}

