/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ColourAdapter;
import jalview.Popup;
import jalview.ThresholdPanel;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;

public class PercentIdentityPopup
extends Popup {
    ThresholdPanel tp;

    public PercentIdentityPopup(Frame parent, String title, String label, int low, int high, int value) {
        super(parent, title);
        this.tp = new ThresholdPanel(parent, label, low, high, value);
        this.status.setText("Enter the threshold above which to colour sequences");
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.tp, this.gb, this.gbc, 0, 0, 2, 1);
        this.add(this.status, this.gb, this.gbc, 0, 1, 2, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 2, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 2, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event e) {
        if (e.target == this.apply && e.id == 1001) {
            int threshold = 0;
            try {
                threshold = Integer.valueOf(this.tp.tf.getText());
            }
            catch (Exception exception) {
                threshold = this.tp.sb.getValue();
                this.tp.tf.setText(new Integer(threshold).toString());
            }
            if (this.parent instanceof AlignFrame) {
                AlignFrame af = (AlignFrame)this.parent;
                af.threshold = threshold;
                af.ap.setSequenceColor(threshold, ColourAdapter.get(af.getScheme()));
                af.updateFont();
            }
            return true;
        }
        if (e.target == this.close && e.id == 1001) {
            this.hide();
            this.dispose();
            return true;
        }
        return super.handleEvent(e);
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        PercentIdentityPopup pip = new PercentIdentityPopup(f, "title", "Percent identity", 0, 100, 80);
        pip.show();
    }
}

