/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ClustalwThread;
import jalview.CommandThread;
import jalview.ConsThread;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;

public class ProgressPanel
extends Panel
implements Runnable {
    Thread ct = null;
    Object parent;
    long tstart;
    long tend;
    GridBagLayout gb;
    GridBagConstraints gbc;
    Button cancel;
    Label status;
    Label time;

    public ProgressPanel(Object parent, Thread ct) {
        this.ct = ct;
        this.parent = parent;
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.setLayout(this.gb);
        this.status = new Label("Status: Process stopped", 0);
        this.time = new Label("Time elapsed = ", 0);
        this.cancel = new Button("Cancel");
        this.gbc.insets = new Insets(10, 10, 0, 0);
        this.gbc.fill = 13;
        this.add(this.status, this.gb, this.gbc, 0, 0, 1, 1);
        this.add(this.time, this.gb, this.gbc, 0, 1, 1, 1);
        this.gbc.fill = 0;
        this.add(this.cancel, this.gb, this.gbc, 0, 2, 1, 1);
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 200);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void run() {
        this.tstart = System.currentTimeMillis();
        boolean done = false;
        boolean running = false;
        while (!done) {
            if (this.ct != null && this.ct.isAlive()) {
                running = true;
                this.tend = System.currentTimeMillis();
                this.status.setText("Process running");
                this.time.setText("Time elapsed = " + (this.tend - this.tstart) / 1000L + " seconds");
            } else if (running) {
                done = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                System.out.println("Interrupted Exception : " + ex);
            }
        }
        this.tend = System.currentTimeMillis();
        this.status.setText("Process finished");
        if (done && this.ct instanceof ClustalwThread) {
            this.viewOutput();
        }
        this.time.setText("Total time taken = " + (this.tend - this.tstart) / 1000L + " seconds");
    }

    public boolean handleEvent(Event evt) {
        if (evt.target == this.cancel && evt.id == 1001) {
            if (this.ct != null && this.ct.isAlive()) {
                if (this.ct instanceof CommandThread) {
                    CommandThread tmp = (CommandThread)this.ct;
                    System.out.println("Destroying process");
                    tmp.p.destroy();
                }
                this.ct.stop();
                this.ct = null;
                this.status.setText("Status: Process stopped");
            } else {
                this.status.setText("No process running");
            }
        }
        return super.handleEvent(evt);
    }

    public void add(Component c, GridBagLayout gbl, GridBagConstraints gbc, int x, int y, int w, int h) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbl.setConstraints(c, gbc);
        this.add(c);
    }

    public void viewOutput() {
        if (this.ct instanceof ClustalwThread) {
            AlignFrame af = new AlignFrame(this.parent, ((ClustalwThread)this.ct).outFile, "File", "CLUSTAL");
            if (this.parent instanceof AlignFrame) {
                AlignFrame af2 = (AlignFrame)this.parent;
                Font f = af2.getAlignFont();
                af.setAlignFont(f.getName(), f.getStyle(), f.getSize());
            }
            af.resize(700, 500);
            af.show();
            ConsThread ct = new ConsThread(af);
            ct.start();
        }
    }

    public static void main(String[] args) {
        Frame f = new Frame("Testy");
        ClustalwThread ct = new ClustalwThread("pog.msf", "pog.aln");
        ProgressPanel pp = new ProgressPanel(f, ct);
        Thread t = new Thread(pp);
        t.start();
        f.add(pp);
        f.resize(350, 150);
        f.show();
        ct.start();
    }
}

