/*
 * Decompiled with CFR 0.152.
 */
package jalview;

public class RotatableMatrix {
    float[][] matrix;
    float[] temp;
    float[][] rot;

    public RotatableMatrix(int rows, int cols) {
        this.matrix = new float[rows][cols];
        this.temp = new float[3];
        this.rot = new float[3][3];
    }

    public void addElement(int i, int j, float value) {
        this.matrix[i][j] = value;
    }

    public void print() {
        System.out.println(String.valueOf(this.matrix[0][0]) + " " + this.matrix[0][1] + " " + this.matrix[0][2]);
        System.out.println(String.valueOf(this.matrix[1][0]) + " " + this.matrix[1][1] + " " + this.matrix[1][2]);
        System.out.println(String.valueOf(this.matrix[2][0]) + " " + this.matrix[2][1] + " " + this.matrix[2][2]);
    }

    public void rotate(float degrees, char axis) {
        float costheta = (float)Math.cos((double)degrees * Math.PI / 180.0);
        float sintheta = (float)Math.sin((double)degrees * Math.PI / 180.0);
        if (axis == 'z') {
            this.rot[0][0] = costheta;
            this.rot[0][1] = -sintheta;
            this.rot[0][2] = 0.0f;
            this.rot[1][0] = sintheta;
            this.rot[1][1] = costheta;
            this.rot[1][2] = 0.0f;
            this.rot[2][0] = 0.0f;
            this.rot[2][1] = 0.0f;
            this.rot[2][2] = 1.0f;
            this.preMultiply(this.rot);
        }
        if (axis == 'x') {
            this.rot[0][0] = 1.0f;
            this.rot[0][1] = 0.0f;
            this.rot[0][2] = 0.0f;
            this.rot[1][0] = 0.0f;
            this.rot[1][1] = costheta;
            this.rot[1][2] = sintheta;
            this.rot[2][0] = 0.0f;
            this.rot[2][1] = -sintheta;
            this.rot[2][2] = costheta;
            this.preMultiply(this.rot);
        }
        if (axis == 'y') {
            this.rot[0][0] = costheta;
            this.rot[0][1] = 0.0f;
            this.rot[0][2] = -sintheta;
            this.rot[1][0] = 0.0f;
            this.rot[1][1] = 1.0f;
            this.rot[1][2] = 0.0f;
            this.rot[2][0] = sintheta;
            this.rot[2][1] = 0.0f;
            this.rot[2][2] = costheta;
            this.preMultiply(this.rot);
        }
    }

    public float[] vectorMultiply(float[] vect) {
        this.temp[0] = vect[0];
        this.temp[1] = vect[1];
        this.temp[2] = vect[2];
        int i = 0;
        while (i < 3) {
            this.temp[i] = this.matrix[i][0] * vect[0] + this.matrix[i][1] * vect[1] + this.matrix[i][2] * vect[2];
            ++i;
        }
        vect[0] = this.temp[0];
        vect[1] = this.temp[1];
        vect[2] = this.temp[2];
        return vect;
    }

    public void preMultiply(float[][] mat) {
        int j;
        float[][] tmp = new float[3][3];
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                tmp[i][j] = mat[i][0] * this.matrix[0][j] + mat[i][1] * this.matrix[1][j] + mat[i][2] * this.matrix[2][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                this.matrix[i][j] = tmp[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void postMultiply(float[][] mat) {
        int j;
        float[][] tmp = new float[3][3];
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                tmp[i][j] = this.matrix[i][0] * mat[0][j] + this.matrix[i][1] * mat[1][j] + this.matrix[i][2] * mat[2][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                this.matrix[i][j] = tmp[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        RotatableMatrix m = new RotatableMatrix(3, 3);
        m.addElement(0, 0, 1.0f);
        m.addElement(0, 1, 0.0f);
        m.addElement(0, 2, 0.0f);
        m.addElement(1, 0, 0.0f);
        m.addElement(1, 1, 2.0f);
        m.addElement(1, 2, 0.0f);
        m.addElement(2, 0, 0.0f);
        m.addElement(2, 1, 0.0f);
        m.addElement(2, 2, 1.0f);
        m.print();
        RotatableMatrix n = new RotatableMatrix(3, 3);
        n.addElement(0, 0, 2.0f);
        n.addElement(0, 1, 1.0f);
        n.addElement(0, 2, 1.0f);
        n.addElement(1, 0, 2.0f);
        n.addElement(1, 1, 1.0f);
        n.addElement(1, 2, 1.0f);
        n.addElement(2, 0, 2.0f);
        n.addElement(2, 1, 1.0f);
        n.addElement(2, 2, 1.0f);
        n.print();
        float[] vect = new float[]{2.0f, 4.0f, 6.0f};
        vect = m.vectorMultiply(vect);
        System.out.println(String.valueOf(vect[0]) + " " + vect[1] + " " + vect[2]);
    }

    public void setIdentity() {
        this.matrix[0][0] = 1.0f;
        this.matrix[1][1] = 1.0f;
        this.matrix[2][2] = 1.0f;
        this.matrix[0][1] = 0.0f;
        this.matrix[0][2] = 0.0f;
        this.matrix[1][0] = 0.0f;
        this.matrix[1][2] = 0.0f;
        this.matrix[2][0] = 0.0f;
        this.matrix[2][1] = 0.0f;
    }
}

