/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignSeq;
import jalview.ResidueProperties;
import jalview.SwissprotFile;
import java.io.IOException;
import java.util.Vector;

public class Sequence {
    public String name;
    public String sequence;
    public int[] num;
    public int start;
    public int end;
    String desc;
    Vector features;
    Vector[] score;
    Vector pdbcode;
    SwissprotFile sp;

    public Sequence(Sequence s) {
        this.name = s.name;
        this.sequence = new String(s.getSequence());
        this.num = new int[this.sequence.length()];
        this.start = s.start;
        this.end = s.end;
        this.score = s.score;
        this.num = Sequence.setNums(s.getSequence());
    }

    public Sequence(String name, String sequence, int start, int end) {
        this.name = name;
        this.sequence = sequence;
        this.num = new int[sequence.length()];
        this.start = start;
        this.end = end;
        this.score = new Vector[10];
        this.num = Sequence.setNums(sequence);
    }

    public static int[] setNums(String s) {
        int[] out = new int[s.length()];
        int i = 0;
        while (i < s.length()) {
            try {
                out[i] = (Integer)ResidueProperties.aaHash.get(s.substring(i, i + 1));
            }
            catch (Exception exception) {
                System.out.println("Exception in Sequence:setNums " + i + " " + s.substring(i, i + 1));
                out[i] = 23;
            }
            ++i;
        }
        return out;
    }

    public void setScore(int i, float s, int num) {
        if (num < 10 && this.score[num] == null) {
            this.score[num] = new Vector();
        } else {
            System.out.println("ERROR: maximum number of scores = 10 " + num);
        }
        if (this.score[num].size() <= i) {
            int j = this.score[num].size();
            while (j <= i) {
                this.score[num].addElement(null);
                ++j;
            }
        }
        this.score[num].setElementAt(new Double(s), i);
    }

    public void getFeatures(String server, String database) {
        System.out.println("ark");
        if (this.features == null) {
            try {
                String id = this.name;
                if (id.indexOf("/") > 0) {
                    id = this.name.substring(0, id.indexOf("/"));
                }
                this.sp = new SwissprotFile("http://" + server + "wgetz?-e+[" + database + "-id:" + id + "]", "URL");
                if (this.sp == null || this.sp.sequence == null) {
                    this.sp = new SwissprotFile("http://" + server + "wgetz?-e+[" + database + "-acc:" + id + "]", "URL");
                }
                if (this.sp != null && this.sp.sequence != null) {
                    String ungap = AlignSeq.extractChars(". -", this.sequence);
                    System.out.println(ungap);
                    System.out.println(this.sp.sequence.sequence);
                    System.out.println(String.valueOf(this.start) + " " + this.end);
                    System.out.println(this.sp.sequence.sequence.indexOf(ungap));
                    if (this.sp.sequence.sequence.indexOf(ungap) != this.start - 1) {
                        this.start = this.sp.sequence.sequence.indexOf(ungap) + 1;
                        this.end = this.start + this.sequence.length() - 1;
                    }
                    if (!this.sp.id.equals("")) {
                        System.out.println("Fetched features for " + this.name);
                        this.features = this.sp.features;
                        this.pdbcode = this.sp.pdbcode;
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Exception in fetching features " + e);
            }
        }
    }

    public int length() {
        return this.sequence.length();
    }

    public String getName() {
        return this.name;
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public char charAt(int i) {
        if (i < this.sequence.length()) {
            return this.sequence.charAt(i);
        }
        return ' ';
    }

    public int findIndex(int pos) {
        int j = this.start;
        int i = 0;
        while (i < this.sequence.length() && j <= this.end && j <= pos) {
            String s = this.sequence.substring(i, i + 1);
            if (!(s.equals(".") || s.equals("-") || s.equals(" "))) {
                ++j;
            }
            ++i;
        }
        if (j == this.end && j < pos) {
            return this.end + 1;
        }
        return i;
    }

    public int findPosition(int i) {
        int j = 0;
        int pos = this.start;
        while (j < i) {
            String s = this.sequence.substring(j, j + 1);
            if (!(s.equals(".") || s.equals("-") || s.equals(" "))) {
                ++pos;
            }
            ++j;
        }
        return pos;
    }

    public void deleteCharAt(int i, int n) {
        if (this.score[n].size() > i) {
            this.score[n].removeElementAt(i);
        }
    }

    public void insertCharAt(int i, char c, int n) {
        if (this.score[n] != null) {
            int j = this.score[n].size();
            while (j < i) {
                this.score[n].addElement(new Double(0.0));
                ++j;
            }
            this.score[n].insertElementAt(new Double(0.0), i);
        }
    }

    public void deleteCharAt(int i) {
        this.sequence = i + 1 < this.sequence.length() ? String.valueOf(this.sequence.substring(0, i)) + this.sequence.substring(i + 1) : this.sequence.substring(0, i);
        int[] tmp = new int[this.num.length];
        int j = 0;
        while (j < i) {
            tmp[j] = this.num[j];
            ++j;
        }
        j = i + 1;
        while (j < this.num.length) {
            tmp[j - 1] = this.num[j];
            ++j;
        }
        this.num[this.num.length - 1] = 23;
        this.num = tmp;
        j = 0;
        while (j < this.score.length && this.score[j] != null) {
            this.deleteCharAt(i, j);
            ++j;
        }
    }

    public void insertCharAt(int i, char c) {
        this.insertCharAt(i, c, true);
    }

    public void insertCharAt(int i, char c, boolean chop) {
        String tmp = new String(this.sequence);
        this.sequence = i < this.sequence.length() ? String.valueOf(tmp.substring(0, i)) + String.valueOf(c) + tmp.substring(i) : String.valueOf(tmp) + String.valueOf(c);
        int len = this.num.length + 1;
        if (chop && (this.sequence.substring(this.sequence.length() - 1).equals("-") || this.sequence.substring(this.sequence.length() - 1).equals(".") || this.sequence.substring(this.sequence.length() - 1).equals(" ")) && i < this.sequence.length() - 1) {
            len = this.num.length;
            this.sequence = this.sequence.substring(0, this.sequence.length() - 1);
        }
        int[] newnum = new int[len];
        int j = 0;
        j = 0;
        while (j < i) {
            newnum[j] = this.num[j];
            ++j;
        }
        try {
            newnum[j] = (Integer)ResidueProperties.aaHash.get(String.valueOf(c));
        }
        catch (Exception exception) {
            System.out.println("Exception in insertChar " + c);
            newnum[j] = 23;
        }
        j = i + 1;
        while (j < len) {
            newnum[j] = this.num[j - 1];
            ++j;
        }
        this.num = newnum;
        j = 0;
        while (j < this.score.length && this.score[j] != null) {
            this.insertCharAt(i, c, j);
            ++j;
        }
    }

    public void setScore(int i, float s) {
        int j = 0;
        while (j < this.score.length && this.score[j] != null) {
            this.setScore(i, s, j);
            ++j;
        }
    }
}

