/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import scigol.ClassInfo;
import scigol.ClassScope;
import scigol.Debug;
import scigol.Entry;
import scigol.Func;
import scigol.FuncInfo;
import scigol.ScigolTreeParser;
import scigol.Scope;
import scigol.TypeManager;
import scigol.TypeSpec;
import scigol.Value;

public class Class {
    protected Scope _scope;
    protected ClassType _classType;
    protected ClassInfo _info;
    protected ArrayList _members;
    Object _sysValue;

    public Class(ClassInfo info, ArrayList members) {
        this._classType = ClassType.Local;
        this._info = info;
        this._members = members;
        for (Object o : this._members) {
            Debug.Assert(!(o instanceof Value), "members can't be Values");
        }
    }

    public Class(ClassInfo info, Object value) {
        Debug.Assert(!(value instanceof Value), "must be an Object (not a Value)");
        this._classType = ClassType.External;
        this._info = info;
        this._sysValue = value;
        this._scope = null;
    }

    protected static void setLocalProperty(Entry e, FuncInfo callSig, Object[] args, Object value, Class instance) {
        Debug.Assert(instance != null || e.isStatic(), "instance required for non-static/const properties");
        ClassScope classScope = (ClassScope)e.scope;
        if (!e.hasSetter()) {
            ScigolTreeParser.semanticError("the value of property '" + e.name + "' of class " + ((ClassScope)e.scope).getClassType() + "' cannot be set (no set accessor)");
        }
        String accessorName = FuncInfo.accessorName(e.name, false);
        Entry accessorEntry = classScope.getClassType().getClassInfo().getDeclaredEntries(accessorName)[0];
        FuncInfo setterCallSig = callSig.accessorSig("set", e.type);
        Object[] setterArgs = new Object[args.length + 1];
        int i = 0;
        while (i < args.length) {
            setterArgs[i] = args[i];
            ++i;
        }
        setterArgs[args.length] = value;
        Func accessor2 = (Func)Class.getMemberValue(accessorEntry, instance);
        Object[] convertedArgs = accessor2.getInfo().convertParameters(setterCallSig, setterArgs, false);
        accessor2.call((Object)instance, convertedArgs);
    }

    protected static Object getLocalProperty(Entry e, FuncInfo callSig, Object[] args, Class instance) {
        Object[] convertedArgs;
        Debug.Assert(instance != null || e.isStatic(), "instance required for non-static/const properties");
        ClassScope classScope = (ClassScope)e.scope;
        if (!e.hasGetter()) {
            ScigolTreeParser.semanticError("the value of property '" + e.name + "' of class " + ((ClassScope)e.scope).getClassType() + "' cannot be read (no get accessor)");
        }
        String accessorName = FuncInfo.accessorName(e.name, true);
        Entry accessorEntry = classScope.getClassType().getClassInfo().getDeclaredEntries(accessorName)[0];
        Func accessor2 = (Func)Class.getMemberValue(accessorEntry, instance);
        Object getterRet = accessor2.call((Object)instance, convertedArgs = accessor2.getInfo().convertParameters(callSig, args, false));
        TypeSpec getterRetType = TypeSpec.typeOf(getterRet);
        if (!TypeManager.existsImplicitConversion(getterRetType, e.type, new Value(getterRet))) {
            ScigolTreeParser.semanticError("the 'get' accessor for property '" + e.name + "' of class " + ((ClassScope)e.scope).getClassType() + "' should evaluate to the property type '" + e.type + "', not type '" + getterRetType + "'");
        }
        getterRet = TypeManager.performImplicitConversion(getterRetType, e.type, new Value(getterRet)).getValue();
        return getterRet;
    }

    protected static void setExternalProperty(Entry e, FuncInfo callSig, Object[] args, Object value, Object sysValue) {
        java.lang.Class type;
        java.lang.Class clazz = type = sysValue != null ? sysValue.getClass() : null;
        if (type == null) {
            Debug.Assert(e.scope instanceof ClassScope, "property isn't in a class!");
            type = (java.lang.Class)((ClassScope)e.scope).getClassType().getSysType();
        }
        Entry.EntryPair ep = (Entry.EntryPair)e.getStaticValue();
        if (ep.setter == null) {
            ScigolTreeParser.semanticError("the value of property '" + e.name + "' of class '" + new ClassInfo(type) + "' cannot be set (no set accessor)");
        }
        FuncInfo setterCallSig = callSig.accessorSig("set", e.type);
        Object[] setterArgs = new Object[args.length + 1];
        int i = 0;
        while (i < args.length) {
            setterArgs[i] = args[i];
            ++i;
        }
        setterArgs[args.length] = value;
        Func setter = (Func)ep.setter.getStaticValue();
        Object[] convertedArgs = setter.getInfo().convertParameters(setterCallSig, setterArgs, true);
        setter.call(sysValue, convertedArgs);
    }

    protected static Object getExternalProperty(Entry e, FuncInfo callSig, Object[] args, Object sysValue) {
        Object[] convertedArgs;
        Func getter;
        Object getterRet;
        TypeSpec getterRetType;
        java.lang.Class type;
        java.lang.Class clazz = type = sysValue != null ? sysValue.getClass() : null;
        if (type == null) {
            Debug.Assert(e.scope instanceof ClassScope, "property isn't in a class!");
            type = (java.lang.Class)((ClassScope)e.scope).getClassType().getSysType();
        }
        Entry.EntryPair ep = (Entry.EntryPair)e.getStaticValue();
        if (ep.getter == null) {
            ScigolTreeParser.semanticError("the value of property '" + e.name + "' of class '" + new ClassInfo(type) + "' cannot be read (no get accessor)");
        }
        if (!TypeManager.existsImplicitConversion(getterRetType = TypeSpec.typeOf(getterRet = (getter = (Func)ep.getter.getStaticValue()).call(sysValue, convertedArgs = getter.getInfo().convertParameters(callSig, args, true))), e.type, new Value(getterRet))) {
            ScigolTreeParser.semanticError("the 'get' accessor for property '" + e.name + "' of class " + new ClassInfo(type) + "' should evaluate to the property type '" + e.type + "', not type '" + getterRetType + "'");
        }
        getterRet = TypeManager.performImplicitConversion(getterRetType, e.type, new Value(getterRet)).getValue();
        return getterRet;
    }

    protected static Method findExternalPropertyAccessor(java.lang.Class declaringClass, String accessorName, Entry e, FuncInfo callSig, Object[] args) {
        boolean getAccessor = accessorName.equals("get");
        Entry.EntryPair ep = (Entry.EntryPair)e.getStaticValue();
        Entry accessorEntry = null;
        if (getAccessor) {
            if (ep.getter == null) {
                return null;
            }
            accessorEntry = ep.getter;
        } else {
            if (ep.setter == null) {
                return null;
            }
            accessorEntry = ep.setter;
        }
        String accessorMethodName = accessorEntry.name;
        java.lang.Class[] argTypes = accessorEntry.type.getFuncInfo().getExternParamTypes();
        Debug.WL("static value's type of property accessor entry is:" + accessorEntry.getStaticValue().getClass());
        try {
            Debug.Write("looking for accessor " + accessorMethodName + " of class " + declaringClass + " with arg types :");
            int i = 0;
            while (i < argTypes.length) {
                Debug.Write("arg" + i + ":" + argTypes[i]);
                ++i;
            }
            Debug.WL("");
            return declaringClass.getDeclaredMethod(accessorMethodName, argTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Debug.WL(" not found");
            return null;
        }
    }

    public static Object getPropertyValue(Entry e, FuncInfo callSig, Object[] args, Object instance) {
        boolean isExternal;
        Debug.Assert(e != null);
        Debug.Assert(e.isClassMember(), "e must be a class member");
        Debug.Assert(!e.isAbstract(), "e is an abstract member!");
        Debug.Assert(e.isProperty(), "e must be a property");
        if (args == null) {
            args = new Object[]{};
        }
        if (!(isExternal = ((ClassScope)e.scope).getClassType().getClassInfo().isExternal())) {
            Debug.Assert(instance instanceof Class, "Class instance required");
            return Class.getLocalProperty(e, callSig, args, (Class)instance);
        }
        if (instance instanceof Class) {
            instance = ((Class)instance).getSysValue();
        }
        return Class.getExternalProperty(e, callSig, args, instance);
    }

    public static void setPropertyValue(Entry e, FuncInfo callSig, Object[] args, Object value, Object instance) {
        boolean isExternal;
        Debug.Assert(e.isClassMember(), "e must be a class member");
        Debug.Assert(!e.isAbstract(), "e is an abstract member!");
        Debug.Assert(e.isProperty(), "e must be a property");
        if (args == null) {
            args = new Object[]{};
        }
        if (!(isExternal = ((ClassScope)e.scope).getClassType().getClassInfo().isExternal())) {
            Debug.Assert(instance instanceof Class, "Class instance required");
            Class.setLocalProperty(e, callSig, args, value, (Class)instance);
        } else {
            if (instance instanceof Class) {
                instance = ((Class)instance).getSysValue();
            }
            Class.setExternalProperty(e, callSig, args, value, instance);
        }
    }

    public static Object getMemberValue(Entry e, Object instance) {
        Debug.Assert(e.isClassMember(), "e must be a class member");
        Debug.Assert(!e.isAbstract(), "e is an abstract member!");
        Debug.Assert(instance != null || e.isStatic(), "instance required");
        if (e.isProperty()) {
            return Class.getPropertyValue(e, new FuncInfo(), null, instance);
        }
        boolean isExternal = ((ClassScope)e.scope).getClassType().getClassInfo().isExternal();
        boolean isStatic = e.isStatic();
        if (!isExternal) {
            if (isStatic) {
                return e.getStaticValue();
            }
            Debug.Assert(e.index >= 0, "inherited Java members can't currently be accessed in local classes (unimplemented)");
            Debug.Assert(instance instanceof Class, "Class instance required");
            return ((Class)instance)._members.get(e.index);
        }
        if (instance instanceof Class) {
            instance = ((Class)instance).getSysValue();
        }
        TypeSpec declaringClassType = ((ClassScope)e.scope).getClassType();
        java.lang.Class sysClass = (java.lang.Class)declaringClassType.getSysType();
        if (e.isField()) {
            if (e.type.isType()) {
                Debug.Unimplemented("nested types");
            }
            try {
                Field field = sysClass.getField(e.name);
                return field.get(instance);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Debug.Assert(false, "unable to find field " + e.name + " of extern type '" + sysClass.getName() + "'");
            }
            catch (IllegalAccessException ex) {
                ScigolTreeParser.semanticError("illegal access for field '" + e.name + "' of '" + sysClass.getName() + "' - " + ex.getMessage());
            }
        } else {
            if (e.isMethod()) {
                Func func = (Func)e.getStaticValue();
                Debug.Assert(func != null, "entry for external method has no Func value!");
                return func;
            }
            Debug.Unimplemented("unknown member type of type '" + sysClass.getName() + "'");
        }
        return null;
    }

    public static void setMemberValue(Entry e, Object value, Object instance) {
        Debug.Assert(e.isClassMember(), "e must be a class member");
        Debug.Assert(!e.isAbstract(), "e is an abstract member!");
        Debug.Assert(instance != null || e.isStatic(), "instance required");
        if (e.isProperty()) {
            Class.setPropertyValue(e, new FuncInfo(), null, value, instance);
        }
        boolean isExternal = ((ClassScope)e.scope).getClassType().getClassInfo().isExternal();
        e.isStatic();
        if (!isExternal) {
            if (e.isStatic()) {
                e.setStaticValue(value);
            } else {
                Debug.Assert(e.index >= 0, "inherited Java members can't currently be accessed in local classes (unimplemented)");
                Debug.Assert(instance instanceof Class, "Class instance required");
                ((Class)instance)._members.set(e.index, value);
            }
        } else {
            if (instance instanceof Class) {
                instance = ((Class)instance).getSysValue();
            }
            TypeSpec declaringClassType = ((ClassScope)e.scope).getClassType();
            java.lang.Class sysClass = (java.lang.Class)declaringClassType.getSysType();
            if (e.isField()) {
                if (e.type.isType()) {
                    ScigolTreeParser.semanticError("external classes have const nested type members, hence cannot be set");
                }
                try {
                    Field field = sysClass.getField(e.name);
                    field.set(instance, value);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Debug.Assert(false, "unable to find field " + e.name + " of extern type '" + sysClass.getName() + "'");
                }
                catch (IllegalAccessException ex) {
                    ScigolTreeParser.semanticError("illegal access for field '" + e.name + "' of '" + sysClass.getName() + "' - " + ex.getMessage());
                }
            } else if (e.isMethod()) {
                ScigolTreeParser.semanticError("external classes have const method members, hence cannot be set");
            } else {
                Debug.Unimplemented("unknown member type of type " + sysClass.getName());
            }
        }
    }

    public Scope getOuterScope() {
        return this._scope;
    }

    public ClassInfo getInfo() {
        return this._info;
    }

    public ArrayList getMemberValues() {
        return this._members;
    }

    public Object getSysValue() {
        Debug.Assert(this._classType == ClassType.External);
        return this._sysValue;
    }

    public boolean isExternal() {
        return this._classType == ClassType.External;
    }

    public String toString() {
        if (this._classType == ClassType.External) {
            return this._sysValue.toString();
        }
        return this._info.instanceToString(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ClassType {
        Local,
        External;

    }
}

