/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import antlr.collections.AST;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import scigol.Debug;
import scigol.Location;
import scigol.ScigolAnnotation;
import scigol.ScigolTreeParser;
import scigol.Scope;
import scigol.TypeSpec;
import scigol.Value;
import scigol.redirect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry {
    public String name;
    public String actualName;
    public TypeSpec type;
    public TypeSpec actualType;
    public Object _staticValue;
    public AST initializer;
    public EnumSet<TypeSpec.Modifier> modifiers;
    public Scope scope;
    public Location location;
    public int index;
    public EnumSet<Flags> flags;
    public Entry aliasedEntry;
    public Entry propertyEntry;
    public LinkedList<Annotation> annotations;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Entry(String name, TypeSpec type, Object staticValue, AST initializer, EnumSet<TypeSpec.Modifier> modifiers, EnumSet<Flags> flags, int index, Scope scope) {
        this.name = name;
        this.type = type;
        this._staticValue = staticValue;
        this.initializer = initializer;
        this.modifiers = modifiers;
        this.scope = scope;
        this.location = null;
        this.index = index;
        this.flags = flags;
        this.actualName = null;
        this.aliasedEntry = null;
        Debug.Assert(scope != null);
    }

    public Entry(String name, String actualName, TypeSpec type, Object staticValue, AST initializer, EnumSet<TypeSpec.Modifier> modifiers, EnumSet<Flags> flags, int index, Scope scope) {
        this.name = name;
        this.type = type;
        this._staticValue = staticValue;
        this.initializer = initializer;
        this.modifiers = modifiers;
        this.scope = scope;
        this.location = null;
        this.index = index;
        this.flags = flags;
        this.actualName = actualName;
        this.aliasedEntry = null;
        Debug.Assert(scope != null);
    }

    public Entry(String name, TypeSpec type, Object staticValue, AST initializer, EnumSet<TypeSpec.Modifier> modifiers, EnumSet<Flags> flags, int index, Scope scope, Location l) {
        this.name = name;
        this.type = type;
        this._staticValue = staticValue;
        this.initializer = initializer;
        this.modifiers = modifiers;
        this.scope = scope;
        this.location = null;
        this.index = index;
        this.flags = flags;
        this.location = l;
        this.actualName = null;
        this.aliasedEntry = null;
        Debug.Assert(scope != null);
    }

    public Entry createAliasEntry(String alias) {
        Entry aliasEntry = new Entry(alias, this.actualName, this.type, this._staticValue, this.initializer, this.modifiers, this.flags, this.index, this.scope);
        aliasEntry.aliasedEntry = this;
        aliasEntry.location = this.location;
        aliasEntry.actualName = this.name;
        aliasEntry.addAnnotations(this.getAnnotations());
        return aliasEntry;
    }

    public Object getStaticValue() {
        if (this.aliasedEntry != null) {
            return this.aliasedEntry.getStaticValue();
        }
        return this._staticValue;
    }

    public void setStaticValue(Object value) {
        if (this.aliasedEntry != null) {
            this.aliasedEntry.setStaticValue(value);
        } else {
            this._staticValue = value;
        }
    }

    public boolean isClassMember() {
        return this.scope.isClassScope();
    }

    public boolean isLocalName() {
        return this.scope.isLocalScope();
    }

    public boolean isNamespaceName() {
        return this.scope.isNamespaceScope();
    }

    public boolean isStatic() {
        return this.modifiers.contains((Object)TypeSpec.Modifier.Static);
    }

    public boolean isAbstract() {
        return this.modifiers.contains((Object)TypeSpec.Modifier.Abstract);
    }

    public boolean isImplicit() {
        return this.modifiers.contains((Object)TypeSpec.Modifier.Implicit);
    }

    public boolean isConst() {
        return this.modifiers.contains((Object)TypeSpec.Modifier.Const);
    }

    public boolean isField() {
        return this.flags.contains((Object)Flags.Field);
    }

    public boolean isMethod() {
        return this.flags.contains((Object)Flags.Method);
    }

    public boolean isProperty() {
        return this.flags.contains((Object)Flags.Property);
    }

    public boolean hasGetter() {
        return this.flags.contains((Object)Flags.HasGetter);
    }

    public boolean hasSetter() {
        return this.flags.contains((Object)Flags.HasSetter);
    }

    public boolean isAccessor() {
        return this.flags.contains((Object)Flags.Accessor);
    }

    public boolean isCovariant() {
        return this.flags.contains((Object)Flags.IsCovariant);
    }

    public boolean hasAnnotations() {
        return this.annotations != null && this.annotations.size() > 0;
    }

    public void addAnnotation(Annotation a) {
        if (this.annotations == null) {
            this.annotations = new LinkedList();
        }
        this.annotations.add(a);
    }

    public void addAnnotations(LinkedList<Annotation> as) {
        if (this.annotations == null) {
            this.annotations = new LinkedList();
        }
        for (Annotation a : as) {
            this.annotations.add(a);
        }
    }

    public void addAnnotations(Annotation[] as) {
        if (this.annotations == null) {
            this.annotations = new LinkedList();
        }
        Annotation[] annotationArray = as;
        int n = 0;
        int n2 = annotationArray.length;
        while (n < n2) {
            Annotation a = annotationArray[n];
            this.annotations.add(a);
            ++n;
        }
    }

    public Annotation[] getAnnotations() {
        Annotation[] as = new Annotation[this.annotations.size()];
        int i = 0;
        for (Annotation a : this.annotations) {
            as[i++] = a;
        }
        return as;
    }

    public Annotation getAnnotation(TypeSpec annotationType) {
        Debug.Assert(annotationType.isInterface());
        Debug.Assert(annotationType.isA(new TypeSpec((Type)((Object)Annotation.class))));
        if (this.annotations == null) {
            return null;
        }
        for (Annotation a : this.annotations) {
            if (!a.annotationType().equals(annotationType.getSysType())) continue;
            return a;
        }
        for (Annotation a : this.annotations) {
            Entry[] memberEntries;
            if (!a.annotationType().equals(redirect.class)) continue;
            String redirectTarget = null;
            if (a instanceof ScigolAnnotation) {
                Value v = (Value)((ScigolAnnotation)a).getMembers().get(0);
                redirectTarget = (String)v.getValue();
            } else {
                redirectTarget = ((redirect)a).value();
            }
            int lastDotIndex = redirectTarget.lastIndexOf(".");
            String redirectClassName = redirectTarget.substring(0, lastDotIndex);
            String redirectMethodName = redirectTarget.substring(lastDotIndex + 1);
            TypeSpec javaClassType = TypeSpec.typeOf(redirectClassName);
            if (javaClassType != null && (memberEntries = javaClassType.getClassInfo().getAllEntries(redirectMethodName)).length > 0) {
                if (memberEntries.length > 1) {
                    ScigolTreeParser.semanticError("redirect annotation target '" + redirectTarget + "' is ambiguous");
                }
                return memberEntries[0].getAnnotation(annotationType);
            }
            ScigolTreeParser.semanticError("redirect annotation target '" + redirectTarget + "' not found");
        }
        return null;
    }

    public String toString() {
        String s = "";
        if (this.isField()) {
            s = String.valueOf(s) + "field";
        }
        if (this.isMethod()) {
            s = String.valueOf(s) + "method";
        }
        if (this.isProperty()) {
            s = String.valueOf(s) + "property";
        }
        if (this.isAccessor()) {
            s = String.valueOf(s) + " accessor";
        }
        s = String.valueOf(s) + " " + this.name;
        s = String.valueOf(s) + " mods:" + TypeSpec.modifiersString(this.modifiers) + ";";
        s = String.valueOf(s) + " actualName:" + this.actualName;
        s = String.valueOf(s) + " type:" + this.type;
        s = String.valueOf(s) + " actualType:" + this.actualType;
        s = String.valueOf(s) + " staticValue:" + this._staticValue;
        return s;
    }

    public static ArrayList toArrayList(Entry[] entryArray) {
        if (entryArray == null) {
            return new ArrayList();
        }
        ArrayList<Entry> l = new ArrayList<Entry>(entryArray.length);
        int i = 0;
        while (i < entryArray.length) {
            l.add(entryArray[i]);
            ++i;
        }
        return l;
    }

    public static Entry[] toArray(ArrayList entryList) {
        if (entryList == null) {
            return new Entry[0];
        }
        Entry[] a = new Entry[entryList.size()];
        int i = 0;
        while (i < entryList.size()) {
            a[i] = (Entry)entryList.get(i);
            ++i;
        }
        return a;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flags {
        Field,
        Method,
        Property,
        HasGetter,
        HasSetter,
        Accessor,
        IsCovariant;

    }

    public static class EntryPair {
        public Entry getter;
        public Entry setter;

        public EntryPair() {
            this.setter = null;
            this.getter = null;
        }

        public EntryPair(Entry get, Entry set) {
            this.getter = get;
            this.setter = set;
        }
    }
}

