/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import scigol.Any;
import scigol.Class;
import scigol.ClassInfo;
import scigol.Debug;
import scigol.Func;
import scigol.Location;
import scigol.ScigolTreeParser;
import scigol.TypeManager;
import scigol.TypeSpec;
import scigol.Value;

public class FuncInfo {
    public static final DefaultArgument defaultArg = DefaultArgument.getInstance();
    protected String[] _paramNames;
    protected TypeSpec[] _paramTypes;
    protected Object[] _paramDefaults;
    protected boolean[] _paramHasDefault;
    protected TypeSpec _returnType;
    protected boolean _isCallSig;
    protected Location _location = new Location();
    static /* synthetic */ java.lang.Class class$0;
    static /* synthetic */ java.lang.Class class$1;
    static /* synthetic */ java.lang.Class class$2;

    public FuncInfo() {
        this._paramNames = new String[0];
        this._paramTypes = new TypeSpec[0];
        this._paramDefaults = new Object[0];
        this._paramHasDefault = new boolean[0];
        this._returnType = TypeSpec.typeOf("any");
        this._isCallSig = false;
    }

    public FuncInfo(FuncInfo fi) {
        this._paramNames = fi._paramNames;
        this._paramTypes = fi._paramTypes;
        this._paramDefaults = fi._paramDefaults;
        this._paramHasDefault = fi._paramHasDefault;
        this._returnType = fi._returnType;
        this._location = fi._location;
        this._isCallSig = fi._isCallSig;
    }

    public FuncInfo(String[] paramNames, TypeSpec[] paramTypes, Object[] paramDefaults, boolean[] paramHasDefault, TypeSpec returnType) {
        Debug.Assert(paramNames.length == paramTypes.length);
        Debug.Assert(paramNames.length == paramDefaults.length);
        Debug.Assert(paramNames.length == paramHasDefault.length);
        this._paramNames = paramNames;
        this._paramTypes = paramTypes;
        this._paramDefaults = paramDefaults;
        this._paramHasDefault = paramHasDefault;
        this._returnType = returnType;
        this._isCallSig = false;
    }

    public FuncInfo(TypeSpec[] paramTypes, TypeSpec returnType) {
        int numArgs = paramTypes.length;
        this._paramNames = new String[numArgs];
        this._paramDefaults = new Object[numArgs];
        this._paramHasDefault = new boolean[numArgs];
        int a = 0;
        while (a < numArgs) {
            this._paramNames[a] = null;
            this._paramDefaults[a] = null;
            this._paramHasDefault[a] = false;
            ++a;
        }
        this._paramTypes = paramTypes;
        this._returnType = returnType;
        this._isCallSig = true;
    }

    public FuncInfo(Member member) {
        Debug.Assert(member != null, "no Member!");
        java.lang.Class[] parameters = null;
        parameters = member instanceof Method ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
        this._paramNames = new String[parameters.length];
        this._paramTypes = new TypeSpec[parameters.length];
        this._paramDefaults = new Object[parameters.length];
        this._paramHasDefault = new boolean[parameters.length];
        int p = 0;
        while (p < parameters.length) {
            this._paramTypes[p] = new TypeSpec(parameters[p]);
            this._paramHasDefault[p] = false;
            this._paramDefaults[p] = null;
            this._paramNames[p] = "arg" + p;
            ++p;
        }
        if (member instanceof Method) {
            java.lang.Class<?> returnType = ((Method)member).getReturnType();
            this._returnType = returnType.equals(Void.TYPE) ? TypeSpec.anyTypeSpec : new TypeSpec(returnType);
        } else if (member instanceof Constructor) {
            this._returnType = new TypeSpec(((Constructor)member).getDeclaringClass());
        }
        this._isCallSig = false;
    }

    public FuncInfo(ArrayList args) {
        this._isCallSig = true;
        if (args == null) {
            this._paramNames = new String[0];
            this._paramTypes = new TypeSpec[0];
            this._paramDefaults = new Object[0];
            this._paramHasDefault = new boolean[0];
            this._returnType = TypeSpec.typeOf("any");
        } else {
            int n = args.size();
            this._paramNames = new String[n];
            this._paramTypes = new TypeSpec[n];
            this._paramDefaults = new Object[n];
            this._paramHasDefault = new boolean[n];
            this._returnType = TypeSpec.typeOf("any");
            int a = 0;
            while (a < n) {
                this._paramNames[a] = null;
                this._paramTypes[a] = null;
                Object arg = args.get(a);
                boolean isValue = arg instanceof Value;
                if (arg instanceof NamedArgument || isValue && ((Value)arg).getValue() instanceof NamedArgument) {
                    NamedArgument na = isValue ? (NamedArgument)((Value)arg).getValue() : (NamedArgument)arg;
                    arg = na.value;
                    isValue = true;
                    this._paramNames[a] = na.paramName;
                }
                if (isValue) {
                    boolean isNull;
                    Value v = (Value)arg;
                    boolean bl = isNull = v.getValue() == null || v.getValue() instanceof Any && ((Any)v.getValue()).value == null;
                    if (isNull && v.isLValue()) {
                        this._paramTypes[a] = v.getLValue().getSymbol().getType();
                    } else if (v.getValue() instanceof Any && v.getValue() != null) {
                        this._paramTypes[a] = TypeSpec.typeOf(((Any)v.getValue()).value);
                    }
                }
                if (this._paramTypes[a] == null) {
                    this._paramTypes[a] = TypeSpec.typeOf(arg);
                }
                this._paramDefaults[a] = null;
                this._paramHasDefault[a] = false;
                ++a;
            }
        }
    }

    public boolean isFormal() {
        if (this._paramNames.length == 0) {
            return true;
        }
        return this._paramNames[0] != null;
    }

    public String[] getParamNames() {
        return this._paramNames;
    }

    public TypeSpec[] getParamTypes() {
        return this._paramTypes;
    }

    public java.lang.Class[] getExternParamTypes() {
        java.lang.Class[] eParamTypes = new java.lang.Class[this._paramTypes.length];
        int i = 0;
        while (i < this._paramTypes.length) {
            ClassInfo ci;
            TypeSpec type = this._paramTypes[i];
            eParamTypes[i] = type.isBuiltin() || type.isBuiltinClass() ? (java.lang.Class)type.getSysType() : (type.isClassOrInterface() ? ((ci = type.getClassInfo()).isExternal() ? (java.lang.Class)ci.getSysType() : Class.class) : Func.class);
            ++i;
        }
        return eParamTypes;
    }

    public Object[] getParamDefaults() {
        return this._paramDefaults;
    }

    public boolean[] getParamHasDefault() {
        return this._paramHasDefault;
    }

    public TypeSpec getReturnType() {
        return this._returnType;
    }

    public void setReturnType(TypeSpec value) {
        this._returnType = value;
    }

    public int numArgs() {
        return this._paramTypes.length;
    }

    public int numRequiredArgs() {
        int c = 0;
        boolean[] blArray = this._paramHasDefault;
        int n = 0;
        int n2 = blArray.length;
        while (n < n2) {
            boolean paramHasDefault = blArray[n];
            if (!paramHasDefault) {
                ++c;
            }
            ++n;
        }
        return c;
    }

    public String toString() {
        return this.toStringArgs(null);
    }

    public String toStringWithLocation() {
        String s = this.toStringArgs(null);
        if (this._location.isKnown()) {
            s = String.valueOf(s) + "[" + this._location + "]";
        }
        return s;
    }

    public String toStringArgs(Object[] args) {
        boolean haveArgs;
        TypeSpec defaultArgType = new TypeSpec((Type)((Object)DefaultArgument.class));
        boolean bl = haveArgs = args != null;
        if (haveArgs && args.length < this._paramNames.length) {
            haveArgs = false;
        }
        String s = "func(";
        int i = 0;
        while (i < this._paramNames.length) {
            if (this._paramNames[i] != null) {
                s = String.valueOf(s) + this._paramNames[i];
                s = !this._isCallSig ? String.valueOf(s) + ":" : String.valueOf(s) + "=";
            }
            if (!this._paramTypes[i].equals(defaultArgType)) {
                s = String.valueOf(s) + this._paramTypes[i].typeName();
            }
            if (!haveArgs) {
                if (this._paramHasDefault[i]) {
                    if (this._paramDefaults[i] != null) {
                        String str = null;
                        try {
                            str = this._paramDefaults[i].toString();
                        }
                        catch (Exception exception) {}
                        s = str != null ? (!this._paramTypes[i].isString() ? String.valueOf(s) + " =" + str : String.valueOf(s) + " =\"" + str + "\"") : String.valueOf(s) + " =?";
                    } else {
                        s = String.valueOf(s) + " =null";
                    }
                }
            } else {
                Object a = args[i];
                if (a != null) {
                    String str = null;
                    try {
                        str = a.toString();
                    }
                    catch (Exception exception) {}
                    s = str != null ? String.valueOf(s) + " =<" + str + ">" : String.valueOf(s) + " =<?>";
                } else {
                    s = String.valueOf(s) + " =<null>";
                }
            }
            if (i != this._paramNames.length - 1) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
        }
        if (this._returnType != null && !this._isCallSig) {
            s = String.valueOf(s) + " -> " + this._returnType.typeName();
        }
        s = String.valueOf(s) + ")";
        return s;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof FuncInfo)) {
            return false;
        }
        FuncInfo f = (FuncInfo)o;
        if (!this.equalsParams(f)) {
            return false;
        }
        if (this._returnType == null && f._returnType != null) {
            return false;
        }
        return this._returnType == null || this._returnType.equals(f._returnType);
    }

    public boolean equalsParams(FuncInfo f) {
        if (f == null) {
            return false;
        }
        if (f.numArgs() != this.numArgs()) {
            return false;
        }
        if (f.numRequiredArgs() != this.numRequiredArgs()) {
            return false;
        }
        int a = 0;
        while (a < this.numArgs()) {
            if (!this._paramTypes[a].equals(f._paramTypes[a])) {
                return false;
            }
            ++a;
        }
        return true;
    }

    public boolean callCompatible(FuncInfo callSig) {
        Debug.Assert(callSig != null);
        if (callSig.numArgs() < this.numRequiredArgs()) {
            return false;
        }
        if (callSig.numArgs() > this.numArgs()) {
            return false;
        }
        int a = 0;
        while (a < callSig.numArgs()) {
            if (!this._paramTypes[a].equals(callSig._paramTypes[a])) {
                return false;
            }
            ++a;
        }
        return callSig.getReturnType() == null || callSig.getReturnType().equals(TypeSpec.typeOf("any")) || this._returnType.equals(callSig.getReturnType());
    }

    public Object[] convertParameters(FuncInfo callSig, Object[] args, boolean externCall) {
        TypeSpec argType;
        boolean needImplicitConversion;
        Object arg;
        if (args == null) {
            args = new Object[]{};
        }
        Debug.Assert(callSig != null);
        Debug.Assert(callSig.numArgs() == args.length, "supplied arg count must match callSig");
        boolean lastParamObjArray = false;
        TypeSpec objArrayType = new TypeSpec(new Object[0].getClass());
        if (this.numArgs() > 0 && this._paramTypes[this.numArgs() - 1].equals(objArrayType)) {
            lastParamObjArray = true;
        }
        boolean[] haveValue = new boolean[this.numArgs()];
        Object[] convertedArgs = new Object[this.numArgs()];
        int pi = 0;
        while (pi < this.numArgs()) {
            haveValue[pi] = false;
            ++pi;
        }
        boolean sawNamedArg = false;
        int p = 0;
        int a = 0;
        while (a < args.length) {
            boolean vararg;
            arg = args[a];
            if (arg instanceof Value) {
                arg = ((Value)arg).getValue();
            }
            if (arg instanceof NamedArgument) {
                sawNamedArg = true;
                NamedArgument na = (NamedArgument)arg;
                String paramName = na.paramName;
                int paramIndex = this.getParamIndex(paramName);
                if (paramIndex == -1) {
                    ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "function " + this + " doesn't have a formal parameter named '" + paramName + "' in call with signature " + callSig);
                }
                arg = na.value.getValue();
                p = paramIndex;
            } else {
                if (sawNamedArg) {
                    ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "cannot use a positional argument after named arguments in call with signature " + callSig);
                }
                if (p >= this.numArgs()) {
                    ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "too many arguments for function " + this + " in call with signature " + callSig);
                }
            }
            if (arg == defaultArg) {
                Debug.Assert(!sawNamedArg, "a named argument with a defaulted value is non-sensical");
                if (!this._paramHasDefault[p]) {
                    ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "argument " + p + " (" + this._paramNames[p] + ") to func with signature " + this + " was omitted, but has no default value");
                }
                arg = this._paramDefaults[p];
            }
            haveValue[p] = true;
            needImplicitConversion = true;
            argType = TypeSpec.typeOf(arg);
            if (argType.isAny() || argType.isNum()) {
                arg = TypeSpec.unwrapAnyOrNum(arg);
                argType = TypeSpec.typeOf(arg);
                needImplicitConversion = false;
            }
            boolean argIsObjArray = argType.equals(objArrayType);
            int numRemainingArgs = args.length - (a + 1) + 1;
            boolean bl = vararg = lastParamObjArray && !sawNamedArg && p == this.numArgs() - 1 && (!argIsObjArray || numRemainingArgs != 1);
            if (!vararg) {
                Value convertedArg;
                if (needImplicitConversion && !TypeManager.existsImplicitConversion(argType, this._paramTypes[p], new Value(arg))) {
                    ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "argument " + p + " (" + this._paramNames[p] + ") to func with signature " + this + " is of type '" + argType + "' which is incompatible with parameter type '" + this._paramTypes[p] + "'");
                }
                if ((convertedArg = TypeManager.performImplicitConversion(argType, this._paramTypes[p], new Value(arg))) == null) {
                    ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "argument " + p + " (" + this._paramNames[p] + ") to func with signature " + this + " is of type '" + argType + "' which cannot be converted into the required parameter type '" + this._paramTypes[p] + "'");
                }
                convertedArgs[p] = convertedArg.getValue();
            } else {
                Object[] remainingArgs = new Object[numRemainingArgs];
                int ra = a;
                while (ra < args.length) {
                    arg = args[ra];
                    if (arg instanceof Value) {
                        arg = ((Value)arg).getValue();
                    }
                    if ((arg = TypeSpec.unwrapAnyOrNum(arg)) == defaultArg) {
                        arg = null;
                    }
                    remainingArgs[ra - a] = arg;
                    ++ra;
                }
                convertedArgs[p] = remainingArgs;
                a = args.length;
            }
            if (!sawNamedArg) {
                ++p;
            }
            ++a;
        }
        int numMissingParams = 0;
        p = 0;
        while (p < this.numArgs()) {
            if (!haveValue[p]) {
                if (this._paramHasDefault[p]) {
                    Value convertedArg;
                    arg = this._paramDefaults[p];
                    needImplicitConversion = true;
                    argType = TypeSpec.typeOf(arg);
                    if (argType.isAny() || argType.isNum()) {
                        arg = TypeSpec.unwrapAnyOrNum(arg);
                        argType = TypeSpec.typeOf(arg);
                        needImplicitConversion = false;
                    }
                    if (needImplicitConversion && !TypeManager.existsImplicitConversion(argType, this._paramTypes[p], new Value(arg))) {
                        ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "default value of argument " + p + " (" + this._paramNames[p] + ") of func with signature " + this + " is of type '" + argType + "' which is incompatible with parameter type '" + this._paramTypes[p] + "'");
                    }
                    if ((convertedArg = TypeManager.performImplicitConversion(argType, this._paramTypes[p], new Value(arg))) == null) {
                        ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "default value of argument " + p + " (" + this._paramNames[p] + ") of func with signature " + this + " is of type '" + argType + "' which cannot be converted into the required parameter type '" + this._paramTypes[p] + "'");
                    }
                    convertedArgs[p] = convertedArg.getValue();
                    haveValue[p] = true;
                } else {
                    ++numMissingParams;
                }
            }
            ++p;
        }
        if (numMissingParams == 1 && !haveValue[this.numArgs() - 1] && lastParamObjArray) {
            p = this.numArgs() - 1;
            convertedArgs[p] = new Object[0];
            haveValue[p] = true;
            --numMissingParams;
        }
        if (numMissingParams > 0) {
            ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "too few arguments for function " + this + " in call with signature " + callSig);
        }
        return convertedArgs;
    }

    private int getParamIndex(String paramName) {
        int p = 0;
        while (p < this._paramNames.length) {
            if (this._paramNames[p].equals(paramName)) {
                return p;
            }
            ++p;
        }
        return -1;
    }

    public Object[] convertParameters(FuncInfo callSig, ArrayList args, boolean externCall) {
        Object[] aargs = new Object[args.size()];
        int a = 0;
        while (a < aargs.length) {
            aargs[a] = args.get(a);
            ++a;
        }
        return this.convertParameters(callSig, aargs, externCall);
    }

    public FuncInfo accessorSig(String accessorName, TypeSpec propertyType) {
        FuncInfo fi = null;
        if (accessorName.equals("set")) {
            fi = new FuncInfo();
            int numPropArgs = this._paramTypes.length;
            TypeSpec[] pTypes = new TypeSpec[numPropArgs + 1];
            int i = 0;
            while (i < numPropArgs) {
                pTypes[i] = this._paramTypes[i];
                ++i;
            }
            pTypes[numPropArgs] = propertyType;
            String[] pNames = new String[numPropArgs + 1];
            int i2 = 0;
            while (i2 < numPropArgs) {
                pNames[i2] = this._paramNames[i2];
                ++i2;
            }
            pNames[numPropArgs] = "value";
            Object[] pDefaults = new Object[numPropArgs + 1];
            int i3 = 0;
            while (i3 < numPropArgs) {
                pDefaults[i3] = this._paramDefaults[i3];
                ++i3;
            }
            pDefaults[numPropArgs] = null;
            boolean[] pHasDefault = new boolean[numPropArgs + 1];
            int i4 = 0;
            while (i4 < numPropArgs) {
                pHasDefault[i4] = this._paramHasDefault[i4];
                ++i4;
            }
            pHasDefault[numPropArgs] = false;
            fi._paramNames = pNames;
            fi._paramTypes = pTypes;
            fi._paramDefaults = pDefaults;
            fi._paramHasDefault = pHasDefault;
        } else if (accessorName.equals("get")) {
            fi = new FuncInfo(this);
            fi._returnType = propertyType;
        } else {
            Debug.Assert(false, "invalid accessor kind name (should be 'get' or 'set'");
        }
        return fi;
    }

    public FuncInfo propertySig(String accessorName) {
        FuncInfo fi = null;
        if (accessorName.equals("set")) {
            Debug.Assert(this._paramTypes.length > 0, "a set accessor must have at least one argument (the value arg)");
            fi = new FuncInfo(this);
            int numPropArgs = this._paramTypes.length - 1;
            TypeSpec[] pTypes = new TypeSpec[numPropArgs];
            int i = 0;
            while (i < numPropArgs) {
                pTypes[i] = this._paramTypes[i];
                ++i;
            }
            String[] pNames = new String[numPropArgs];
            int i2 = 0;
            while (i2 < numPropArgs) {
                pNames[i2] = this._paramNames[i2];
                ++i2;
            }
            Object[] pDefaults = new Object[numPropArgs];
            int i3 = 0;
            while (i3 < numPropArgs) {
                pDefaults[i3] = this._paramDefaults[i3];
                ++i3;
            }
            boolean[] pHasDefault = new boolean[numPropArgs];
            int i4 = 0;
            while (i4 < numPropArgs) {
                pHasDefault[i4] = this._paramHasDefault[i4];
                ++i4;
            }
            fi._paramNames = pNames;
            fi._paramTypes = pTypes;
            fi._paramDefaults = pDefaults;
            fi._paramHasDefault = pHasDefault;
        } else if (accessorName.equals("get")) {
            fi = new FuncInfo(this);
        } else {
            Debug.Assert(false, "invalid accessor kind name (should be 'get' or 'set'");
        }
        return fi;
    }

    public static TypeSpec propertyTypeFromAccessor(String accessorName, FuncInfo accessorSig) {
        if (accessorName.equals("get")) {
            return accessorSig._returnType;
        }
        if (accessorName.equals("set")) {
            return accessorSig._paramTypes[accessorSig.numArgs() - 1];
        }
        Debug.Assert(false, "invalid accessor name");
        return null;
    }

    public static String accessorName(String propertyName, boolean get) {
        String suffix = propertyName;
        if (propertyName.equals("operator()")) {
            suffix = "Item";
        }
        return get ? "get_" + suffix : "set_" + suffix;
    }

    public static String propertyName(String accessorName) {
        String propName = accessorName.substring(4);
        if (propName.equals("Item")) {
            propName = "operator()";
        }
        return propName;
    }

    public Location getDefinitionLocation() {
        if (this._location != null) {
            return this._location;
        }
        return new Location();
    }

    public void setDefinitionLocation(Location value) {
        this._location = value;
    }

    public static ArrayList toArrayList(Object[] argArray) {
        if (argArray == null) {
            return new ArrayList();
        }
        ArrayList<Object> l = new ArrayList<Object>(argArray.length);
        int i = 0;
        while (i < argArray.length) {
            l.add(argArray[i]);
            ++i;
        }
        return l;
    }

    public static Object[] toArray(ArrayList argList) {
        if (argList == null) {
            return new Object[0];
        }
        Object[] a = new Object[argList.size()];
        int i = 0;
        while (i < argList.size()) {
            a[i] = argList.get(i);
            ++i;
        }
        return a;
    }

    public static class DefaultArgument {
        private static DefaultArgument instance = null;

        protected DefaultArgument() {
        }

        public static DefaultArgument getInstance() {
            if (instance == null) {
                instance = new DefaultArgument();
            }
            return instance;
        }

        public String toString() {
            return "default";
        }
    }

    public static class NamedArgument {
        public String paramName;
        public Value value;

        public NamedArgument(String paramName, Value value) {
            this.paramName = paramName;
            this.value = value;
        }
    }
}

