/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import java.util.ArrayList;
import scigol.Any;
import scigol.Debug;
import scigol.Range;
import scigol.ScigolTreeParser;
import scigol.TypeSpec;
import scigol.Vector;
import scigol.accessor;

public class Matrix {
    protected int _rows;
    protected int _cols;
    protected ArrayList a;

    public Matrix() {
        this._cols = 0;
        this._rows = 0;
        this.a = new ArrayList();
    }

    public Matrix(double n) {
        this._cols = 1;
        this._rows = 1;
        this.a = new ArrayList();
        Vector row = new Vector(n);
        this.a.add(row);
    }

    public Matrix(Vector row) {
        this._rows = 1;
        this._cols = row.get_size();
        this.a = new ArrayList();
        this.a.add(row);
    }

    public static Matrix zero(int rows, int cols) {
        Matrix m = new Matrix();
        int r = 0;
        while (r < rows) {
            m.appendRowVector(Vector.zero(cols));
            ++r;
        }
        return m;
    }

    public static Matrix identity(int dim) {
        Matrix m = new Matrix();
        int r = 0;
        while (r < dim) {
            Vector v = Vector.zero(dim);
            v.set_Item(r, new Any(new Double(1.0)));
            m.appendRowVector(v);
            ++r;
        }
        return m;
    }

    @accessor
    public int get_rows() {
        return this._rows;
    }

    @accessor
    public int get_cols() {
        return this._cols;
    }

    public Vector row(int i) {
        Debug.Assert(i >= 0 && i < this.get_rows());
        return (Vector)this.a.get(i);
    }

    public Vector col(int i) {
        Debug.Assert(i >= 0 && i < this.get_cols());
        Vector _col = new Vector();
        int r = 0;
        while (r < this.get_rows()) {
            _col.appendElement(((Vector)this.a.get(r)).get_Item(i));
            ++r;
        }
        return _col;
    }

    public static Matrix op_Prime(Matrix m) {
        Matrix t = new Matrix(m.col(0));
        int c = 1;
        while (c < m.get_cols()) {
            t.appendRowVector(m.col(c));
            ++c;
        }
        return t;
    }

    public static Matrix op_UnaryNegation(Matrix m) {
        Matrix mm = new Matrix(Vector.op_UnaryNegation(m.row(0)));
        int r = 1;
        while (r < m.get_rows()) {
            mm.appendRowVector(Vector.op_UnaryNegation(m.row(r)));
            ++r;
        }
        return mm;
    }

    public static Matrix op_Addition(Matrix m1, Matrix m2) {
        if (m1.get_rows() != m2.get_rows() || m1.get_cols() != m2.get_cols()) {
            throw new IllegalArgumentException("matrices have incompatible dimensions for addition");
        }
        Matrix m = new Matrix(Vector.op_Addition(m1.row(0), m2.row(0)));
        int r = 1;
        while (r < m1.get_rows()) {
            m.appendRowVector(Vector.op_Addition(m1.row(r), m2.row(r)));
            ++r;
        }
        return m;
    }

    public static Matrix op_Subtraction(Matrix m1, Matrix m2) {
        if (m1.get_rows() != m2.get_rows() || m1.get_cols() != m2.get_cols()) {
            throw new IllegalArgumentException("matrices have incompatible dimensions for subtraction");
        }
        Matrix m = new Matrix(Vector.op_Subtraction(m1.row(0), m2.row(0)));
        int r = 1;
        while (r < m1.get_rows()) {
            m.appendRowVector(Vector.op_Subtraction(m1.row(r), m2.row(r)));
            ++r;
        }
        return m;
    }

    public static Matrix op_Multiply(Matrix m1, Matrix m2) {
        if (m1.get_cols() != m2.get_rows()) {
            throw new IllegalArgumentException("matrices have incompatible dimensions for multiplication");
        }
        Matrix m = null;
        if (m1.get_Item((int)0, (int)0).value instanceof Double) {
            m = Matrix.zero(m1.get_rows(), m2.get_cols());
            int i = 0;
            while (i < m1.get_rows()) {
                int j = 0;
                while (j < m2.get_cols()) {
                    int k = 0;
                    while (k < m1.get_cols()) {
                        double mij = (Double)m.get_Item((int)i, (int)j).value;
                        m.set_Item(i, j, new Any(new Double(mij += (Double)m1.get_Item((int)i, (int)k).value * (Double)m2.get_Item((int)k, (int)j).value)));
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else if (m1.get_Item((int)0, (int)0).value instanceof Integer) {
            m = new Matrix();
            int r = 0;
            while (r < m1.get_rows()) {
                Vector v = new Vector();
                int c = 0;
                while (c < m2.get_cols()) {
                    v.appendElement(new Integer(0));
                    ++c;
                }
                m.appendRowVector(v);
                ++r;
            }
            int i = 0;
            while (i < m1.get_rows()) {
                int j = 0;
                while (j < m2.get_cols()) {
                    int k = 0;
                    while (k < m1.get_cols()) {
                        int mij = (Integer)m.get_Item((int)i, (int)j).value;
                        m.set_Item(i, j, new Any(new Integer(mij += (Integer)m1.get_Item((int)i, (int)k).value * (Integer)m2.get_Item((int)k, (int)j).value)));
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            Debug.Unimplemented();
        }
        return m;
    }

    @accessor
    public Matrix get_Item(Range rr, Range cc) {
        Debug.Unimplemented("submatrices");
        return this;
    }

    @accessor
    public void set_Item(Range rr, Range cc, Matrix value) {
        Debug.Unimplemented("submatrices");
    }

    @accessor
    public Any get_Item(int r, int c) {
        if (r >= 0 && r < this.get_rows() && c >= 0 && c < this.get_cols()) {
            return ((Vector)this.a.get(r)).get_Item(c);
        }
        throw new IndexOutOfBoundsException("matrix index (" + r + ", " + c + ") out of range (0.." + (this.get_rows() - 1) + "), (0.." + (this.get_cols() - 1) + ")");
    }

    @accessor
    public void set_Item(int r, int c, Any value) {
        if (r < 0 || r >= this.get_rows() || c < 0 || c >= this.get_cols()) {
            throw new IndexOutOfBoundsException("matrix index (" + r + ", " + c + ") out of range (0.." + (this.get_rows() - 1) + "), (0.." + (this.get_cols() - 1) + ")");
        }
        ((Vector)this.a.get(r)).set_Item(c, value);
    }

    @accessor
    public Any get_Item(int r) {
        if (r >= 0 && r < this.get_rows()) {
            return new Any((Vector)this.a.get(r));
        }
        throw new IndexOutOfBoundsException("matrix row index (" + r + ") out of range (0.." + (this.get_rows() - 1) + ")");
    }

    @accessor
    public void set_Item(int r, Any value) {
        if (!TypeSpec.typeOf(value.value).equals(TypeSpec.vectorTypeSpec) || ((Vector)value.value).get_size() != this.get_cols()) {
            throw new IllegalArgumentException("vector with dimension equals to number of matrix columns required");
        }
        if (r < 0 || r >= this.get_rows()) {
            throw new IndexOutOfBoundsException("matrix row index (" + r + ") out of range (0.." + (this.get_rows() - 1) + ")");
        }
        this.a.set(r, value.value);
    }

    public void appendRowVector(Object r) {
        Debug.Assert(r instanceof Vector);
        Vector v = (Vector)r;
        if (this._rows == 0) {
            this._cols = v.get_size();
        } else if (v.get_size() != ((Vector)this.a.get(0)).get_size()) {
            ScigolTreeParser.semanticError("incorrect number of elements in row vector");
        }
        this.a.add(v);
        ++this._rows;
    }

    public String toString() {
        String s = "";
        int r = 0;
        while (r < this._rows) {
            s = String.valueOf(s) + ((Vector)this.a.get(r)).toString() + "\n";
            ++r;
        }
        return s;
    }
}

