/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.util.StringVector;

public class FeatureKeyQualifierPredicate
implements FeaturePredicate {
    private Key key = null;
    private String qualifier_name = null;
    private String qualifier_value = null;
    private boolean qualifier_must_exist = true;
    private boolean sub_string_match = false;
    private boolean ignore_case = false;

    public FeatureKeyQualifierPredicate(Key key, String qualifier_name, String qualifier_value) {
        this.key = key;
        this.qualifier_name = qualifier_name;
        this.qualifier_value = qualifier_value;
        this.qualifier_must_exist = false;
    }

    public FeatureKeyQualifierPredicate(Key key, String qualifier_name, String qualifier_value, boolean sub_string_match, boolean ignore_case) {
        this.key = key;
        this.qualifier_name = qualifier_name;
        this.qualifier_must_exist = false;
        this.sub_string_match = sub_string_match;
        this.ignore_case = ignore_case;
        this.qualifier_value = ignore_case ? qualifier_value.toLowerCase() : qualifier_value;
    }

    public FeatureKeyQualifierPredicate(Key key, String qualifier_name) {
        this(key, qualifier_name, true);
    }

    public FeatureKeyQualifierPredicate(Key key, String qualifier_name, boolean qualifier_must_exist) {
        this.key = key;
        this.qualifier_name = qualifier_name;
        this.qualifier_value = null;
        this.qualifier_must_exist = qualifier_must_exist;
    }

    public boolean testPredicate(Feature feature) {
        if (this.key != null && !feature.getKey().equals(this.key)) {
            return false;
        }
        if (this.qualifier_value == null) {
            boolean has_qualifier;
            Qualifier qualifier = null;
            try {
                qualifier = feature.getQualifierByName(this.qualifier_name);
            }
            catch (InvalidRelationException invalidRelationException) {}
            boolean bl = has_qualifier = qualifier != null;
            return this.qualifier_must_exist && has_qualifier || !this.qualifier_must_exist && !has_qualifier;
        }
        StringVector qualifier_names_to_search = this.qualifier_name == null ? null : new StringVector(this.qualifier_name);
        return feature.containsText(this.qualifier_value, this.ignore_case, this.sub_string_match, qualifier_names_to_search);
    }
}

