/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.util.NoSuchElementException;
import uk.ac.sanger.artemis.ActionController;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.EntryVector;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.FeatureEnumeration;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class FilteredEntryGroup
implements EntryGroup {
    private EntryGroup entry_group;
    private FeaturePredicate feature_predicate;
    private FeatureVector filtered_features = null;
    private String filter_name;

    public FilteredEntryGroup(EntryGroup entry_group, FeaturePredicate feature_predicate, String filter_name) {
        this.entry_group = entry_group;
        this.feature_predicate = feature_predicate;
        this.filter_name = filter_name;
        this.getEntryGroup().addFeatureChangeListener(new FeatureChangeListener(){

            public void featureChanged(FeatureChangeEvent event) {
                FilteredEntryGroup.this.filtered_features = null;
            }
        });
        this.getEntryGroup().addEntryChangeListener(new EntryChangeListener(){

            public void entryChanged(EntryChangeEvent event) {
                switch (event.getType()) {
                    case 1: 
                    case 2: {
                        FilteredEntryGroup.this.filtered_features = null;
                        return;
                    }
                }
            }
        });
        EntryGroupChangeListener entry_group_listener = new EntryGroupChangeListener(){

            public void entryGroupChanged(EntryGroupChangeEvent event) {
                FilteredEntryGroup.this.filtered_features = null;
            }
        };
        this.getEntryGroup().addEntryGroupChangeListener(entry_group_listener);
    }

    public Entry getDefaultEntry() {
        return this.getEntryGroup().getDefaultEntry();
    }

    public void setDefaultEntry(Entry entry) {
        this.getEntryGroup().setDefaultEntry(entry);
    }

    public String getFilterName() {
        return this.filter_name;
    }

    public boolean hasUnsavedChanges() {
        return this.getEntryGroup().hasUnsavedChanges();
    }

    public int indexOf(Feature feature) {
        return this.getFilteredFeatures().indexOf(feature);
    }

    public int indexOf(Entry entry) {
        return this.getEntryGroup().indexOf(entry);
    }

    public boolean contains(Feature feature) {
        if (this.getPredicate().testPredicate(feature)) {
            return this.getEntryGroup().contains(feature);
        }
        return false;
    }

    public boolean isActive(Entry entry) {
        return this.getEntryGroup().isActive(entry);
    }

    public void setIsActive(int index, boolean new_active) {
        this.getEntryGroup().setIsActive(index, new_active);
    }

    public void setIsActive(Entry entry, boolean new_active) {
        this.setIsActive(this.indexOf(entry), new_active);
    }

    public Entry getSequenceEntry() {
        return this.getEntryGroup().getSequenceEntry();
    }

    public int getSequenceLength() {
        return this.getEntryGroup().getSequenceLength();
    }

    public Bases getBases() {
        return this.getEntryGroup().getBases();
    }

    public void reverseComplement() throws ReadOnlyException {
        this.getEntryGroup().reverseComplement();
    }

    public int size() {
        return this.getEntryGroup().size();
    }

    public Entry elementAt(int i) {
        return this.getEntryGroup().elementAt(i);
    }

    public Feature featureAt(int index) {
        return this.getFilteredFeatures().elementAt(index);
    }

    public FeatureVector getFeaturesInIndexRange(int start_index, int end_index) {
        FeatureVector features = this.getFilteredFeatures();
        FeatureVector return_vector = new FeatureVector();
        int i = start_index;
        while (i <= end_index) {
            return_vector.add(features.elementAt(i));
            ++i;
        }
        return return_vector;
    }

    public FeatureVector getFeaturesInRange(Range range) throws OutOfRangeException {
        return this.filterFeatures(this.getEntryGroup().getFeaturesInRange(range));
    }

    public FeatureVector getAllFeatures() {
        return this.getFilteredFeatures();
    }

    public int getAllFeaturesCount() {
        return this.getFilteredFeatures().size();
    }

    public void addElement(Entry entry) {
        this.getEntryGroup().addElement(entry);
    }

    public void add(Entry entry) {
        this.getEntryGroup().add(entry);
    }

    public boolean removeElement(Entry entry) {
        return this.getEntryGroup().removeElement(entry);
    }

    public boolean remove(Entry entry) {
        return this.getEntryGroup().remove(entry);
    }

    public Feature createFeature() throws ReadOnlyException {
        return this.getEntryGroup().createFeature();
    }

    public Entry createEntry() {
        return this.getEntryGroup().createEntry();
    }

    public Entry createEntry(String name) {
        return this.getEntryGroup().createEntry(name);
    }

    public FeatureEnumeration features() {
        return new FeatureEnumerator();
    }

    public void featureChanged(FeatureChangeEvent event) {
        this.getEntryGroup().featureChanged(event);
    }

    public void entryChanged(EntryChangeEvent event) {
        this.getEntryGroup().entryChanged(event);
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        this.filtered_features = null;
    }

    public void addEntryGroupChangeListener(EntryGroupChangeListener l) {
        this.getEntryGroup().addEntryGroupChangeListener(l);
    }

    public void removeEntryGroupChangeListener(EntryGroupChangeListener l) {
        this.getEntryGroup().removeEntryGroupChangeListener(l);
    }

    public void addEntryChangeListener(EntryChangeListener l) {
        this.getEntryGroup().addEntryChangeListener(l);
    }

    public void removeEntryChangeListener(EntryChangeListener l) {
        this.getEntryGroup().removeEntryChangeListener(l);
    }

    public void addFeatureChangeListener(FeatureChangeListener l) {
        this.getEntryGroup().addFeatureChangeListener(l);
    }

    public void removeFeatureChangeListener(FeatureChangeListener l) {
        this.getEntryGroup().removeFeatureChangeListener(l);
    }

    public EntryVector getActiveEntries() {
        return this.getEntryGroup().getActiveEntries();
    }

    public EntryGroup truncate(Range constraint) {
        return this.getEntryGroup().truncate(constraint);
    }

    public ActionController getActionController() {
        return this.getEntryGroup().getActionController();
    }

    public boolean isReadOnly() {
        return this.getEntryGroup().isReadOnly();
    }

    public void ref() {
        this.getEntryGroup().ref();
    }

    public void unref() {
        this.getEntryGroup().unref();
    }

    public int refCount() {
        return this.getEntryGroup().refCount();
    }

    protected FeatureVector filterFeatures(FeatureVector features) {
        FeatureVector return_features = new FeatureVector();
        int i = 0;
        while (i < features.size()) {
            Feature this_feature = features.elementAt(i);
            if (this.getPredicate().testPredicate(this_feature)) {
                return_features.add(this_feature);
            }
            ++i;
        }
        return return_features;
    }

    private FeatureVector getFilteredFeatures() {
        if (this.filtered_features == null) {
            this.filtered_features = this.filterFeatures(this.getEntryGroup().getAllFeatures());
        }
        return this.filtered_features;
    }

    private EntryGroup getEntryGroup() {
        return this.entry_group;
    }

    private FeaturePredicate getPredicate() {
        return this.feature_predicate;
    }

    public class FeatureEnumerator
    implements FeatureEnumeration {
        private EntryVector active_entries;
        private int entry_index = -1;
        private FeatureEnumeration feature_enumerator;
        private Feature next_feature;

        public FeatureEnumerator() {
            this.active_entries = FilteredEntryGroup.this.getEntryGroup().getActiveEntries();
            this.entry_index = 0;
            this.feature_enumerator = this.active_entries.size() > 0 ? this.active_entries.elementAt(this.entry_index).features() : null;
        }

        public boolean hasMoreFeatures() {
            if (this.feature_enumerator == null) {
                return false;
            }
            while (true) {
                if (this.feature_enumerator.hasMoreFeatures()) {
                    this.next_feature = this.feature_enumerator.nextFeature();
                    if (!FilteredEntryGroup.this.getPredicate().testPredicate(this.next_feature)) continue;
                    return true;
                }
                ++this.entry_index;
                if (this.entry_index == this.active_entries.size()) {
                    this.feature_enumerator = null;
                    return false;
                }
                this.feature_enumerator = this.active_entries.elementAt(this.entry_index).features();
            }
        }

        public Feature nextFeature() throws NoSuchElementException {
            if (this.feature_enumerator == null) {
                throw new NoSuchElementException();
            }
            if (this.next_feature == null) {
                throw new NoSuchElementException();
            }
            Feature return_feature = this.next_feature;
            this.next_feature = null;
            return return_feature;
        }
    }
}

