/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JFrame;
import uk.ac.sanger.artemis.ComparisonData;
import uk.ac.sanger.artemis.ComparisonDataFactory;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.ComparatorDialog;
import uk.ac.sanger.artemis.components.EntryFileDialog;
import uk.ac.sanger.artemis.components.FileManager;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.MessageFrame;
import uk.ac.sanger.artemis.components.MultiComparator;
import uk.ac.sanger.artemis.components.ProgressThread;
import uk.ac.sanger.artemis.components.Splash;
import uk.ac.sanger.artemis.components.SwingWorker;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.DocumentFactory;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class ActMain
extends Splash {
    public static final String version = "Release 3";
    protected static FileManager filemanager = null;

    public ActMain() {
        super("Artemis Comparison Tool", "ACT", version);
        ActionListener open_listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ActMain.this.makeOpenDialog();
            }
        };
        Splash.makeMenuItem(this.file_menu, "Open ...", open_listener);
        ActionListener quit_listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ActMain.this.exit();
            }
        };
        Splash.makeMenuItem(this.file_menu, "Quit", quit_listener);
    }

    public static boolean makeMultiComparator(final JFrame frame, final InputStreamProgressListener progress_listener, final String[] file_names) {
        final ProgressThread progress_thread = new ProgressThread(null, "Loading Entry...");
        SwingWorker entryWorker = new SwingWorker(){

            public Object construct() {
                progress_thread.start();
                EntryGroup[] entry_group_array = new EntryGroup[file_names.length / 2 + 1];
                ComparisonData[] comparison_data_array = new ComparisonData[file_names.length / 2];
                int i = 0;
                while (i < file_names.length) {
                    uk.ac.sanger.artemis.io.Entry embl_entry;
                    SimpleEntryInformation entry_information = new SimpleEntryInformation(Options.getArtemisEntryInformation());
                    String this_file_name = file_names[i];
                    Document entry_document = DocumentFactory.makeDocument(this_file_name);
                    if (progress_listener != null) {
                        entry_document.addInputStreamProgressListener(progress_listener);
                    }
                    if ((embl_entry = EntryFileDialog.getEntryFromFile(frame, entry_document, entry_information, true)) == null) {
                        return null;
                    }
                    Sequence sequence = embl_entry.getSequence();
                    if (sequence == null) {
                        new MessageDialog(frame, "This file contains no sequence: " + this_file_name);
                        return null;
                    }
                    Bases embl_bases = new Bases(sequence);
                    SimpleEntryGroup entry_group = new SimpleEntryGroup(embl_bases);
                    try {
                        Entry entry = new Entry(entry_group.getBases(), embl_entry);
                        entry_group.add(entry);
                        entry_group_array[i / 2] = entry_group;
                    }
                    catch (OutOfRangeException e) {
                        new MessageDialog(frame, "read failed: one of the features has an out of range location: " + e.getMessage());
                        return null;
                    }
                    i += 2;
                }
                if (file_names.length % 2 == 0) {
                    entry_group_array[entry_group_array.length - 1] = entry_group_array[0];
                }
                try {
                    i = 1;
                    while (i < file_names.length) {
                        Bases next_bases;
                        String comparison_data_file_name = file_names[i];
                        Document comparison_data_document = DocumentFactory.makeDocument(comparison_data_file_name);
                        comparison_data_array[i / 2] = ComparisonDataFactory.readComparisonData(comparison_data_document);
                        Bases prev_bases = entry_group_array[i / 2].getBases();
                        ComparisonData swapped_comparison_data = comparison_data_array[i / 2].flipMatchesIfNeeded(prev_bases, next_bases = entry_group_array[i / 2 + 1].getBases());
                        if (swapped_comparison_data != null) {
                            comparison_data_array[i / 2] = swapped_comparison_data;
                        }
                        if (swapped_comparison_data != null) {
                            MessageFrame message_frame = new MessageFrame("note: hits from " + comparison_data_file_name + " have been flipped to match the " + "sequences");
                            message_frame.setVisible(true);
                        }
                        i += 2;
                    }
                }
                catch (IOException e) {
                    new MessageDialog(frame, "error while reading: " + e.getMessage());
                    return null;
                }
                catch (OutOfRangeException e) {
                    new MessageDialog(frame, "comparison file read failed:  out of range error: " + e.getMessage());
                    return null;
                }
                MultiComparator comparator = new MultiComparator(entry_group_array, comparison_data_array, progress_listener);
                comparator.setVisible(true);
                return null;
            }

            public void finished() {
                if (progress_thread != null) {
                    progress_thread.finished();
                }
            }
        };
        entryWorker.start();
        return true;
    }

    private void makeOpenDialog() {
        if (filemanager == null) {
            filemanager = new FileManager(this, null);
        } else {
            filemanager.setVisible(true);
        }
        new ComparatorDialog(this).setVisible(true);
    }

    protected void exit() {
        System.exit(0);
    }

    public static void main(String[] args) {
        ActMain main_window = new ActMain();
        main_window.setVisible(true);
        InputStreamProgressListener progress_listener = main_window.getInputStreamProgressListener();
        if (args.length >= 3) {
            ActMain.makeMultiComparator(main_window, progress_listener, args);
        } else if (args.length != 0) {
            System.err.println("Error - this program needs either no  arguments or an odd number\n(3 or more):");
            System.err.println("   act sequence_1 comparison_data sequence_2");
            System.err.println("or");
            System.err.println("   act seq_1 comparison_data_2_v_1 seq_2 comparison_data_3_v_2 seq_3");
            System.err.println("or");
            System.err.println("   act");
            System.exit(1);
        }
    }
}

