/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Vector;
import javax.swing.JScrollBar;
import uk.ac.sanger.artemis.components.ScoreChangeEvent;
import uk.ac.sanger.artemis.components.ScoreChangeListener;

public class ScoreScrollbar
extends JScrollBar
implements AdjustmentListener {
    private final Vector score_change_listeners = new Vector();

    public ScoreScrollbar(int minimum_value, int maximum_value) {
        this(0, minimum_value, minimum_value, maximum_value);
    }

    public ScoreScrollbar(int orientation, int value, int minimum_value, int maximum_value) throws IllegalArgumentException {
        super(orientation, value < minimum_value || value > maximum_value ? minimum_value : value, 1, minimum_value, maximum_value + 1);
    }

    public void addScoreChangeListener(ScoreChangeListener l) {
        this.score_change_listeners.addElement(l);
        if (this.score_change_listeners.size() == 1) {
            this.addAdjustmentListener(this);
        }
    }

    public void removeScoreChangeListener(ScoreChangeListener l) {
        this.score_change_listeners.addElement(l);
        if (this.score_change_listeners.size() == 0) {
            this.removeAdjustmentListener(this);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        int i = 0;
        while (i < this.score_change_listeners.size()) {
            ScoreChangeEvent event = new ScoreChangeEvent(this, this.getValue());
            ScoreChangeListener this_listener = (ScoreChangeListener)this.score_change_listeners.elementAt(i);
            this_listener.scoreChanged(event);
            ++i;
        }
    }
}

