/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.sequence.MarkerRange;

public class SelectionMenu
extends JMenu {
    private Selection selection;
    private JFrame frame = null;

    public SelectionMenu(JFrame frame, String menu_name, Selection selection) {
        super(menu_name);
        this.frame = frame;
        this.selection = selection;
    }

    public JFrame getParentFrame() {
        return this.frame;
    }

    protected boolean checkForSelectionFeatures() {
        return SelectionMenu.checkForSelectionFeatures(this.getParentFrame(), this.getSelection());
    }

    static boolean checkForSelectionFeatures(JFrame frame, Selection selection) {
        FeatureVector features_to_check = selection.getAllFeatures();
        if (features_to_check.size() == 0) {
            new MessageDialog(frame, "No features selected");
            return false;
        }
        return true;
    }

    protected boolean checkForSelectionFeatures(int maximum_size, String message) {
        return SelectionMenu.checkForSelectionFeatures(this.getParentFrame(), this.getSelection(), maximum_size, message);
    }

    static boolean checkForSelectionFeatures(JFrame frame, Selection selection, int maximum_size, String message) {
        FeatureVector features_to_check = selection.getAllFeatures();
        if (features_to_check.size() == 0) {
            new MessageDialog(frame, "No features selected");
            return false;
        }
        if (features_to_check.size() > maximum_size) {
            YesNoDialog dialog = new YesNoDialog(frame, message);
            return dialog.getResult();
        }
        return true;
    }

    static boolean checkForSelectionCDSFeatures(JFrame frame, Selection selection, int maximum_size, String max_message) {
        FeatureVector features_to_check = selection.getAllFeatures();
        if (features_to_check.size() == 0) {
            new MessageDialog(frame, "No CDS features selected");
            return false;
        }
        int i = 0;
        while (i < features_to_check.size()) {
            Feature this_feature = features_to_check.elementAt(i);
            if (!this_feature.isCDS()) {
                String message = "a non-CDS feature(" + this_feature.getIDString() + ") is selected - can't continue";
                new MessageDialog(frame, message);
                return false;
            }
            ++i;
        }
        if (features_to_check.size() > maximum_size) {
            YesNoDialog dialog = new YesNoDialog(frame, max_message);
            return dialog.getResult();
        }
        return true;
    }

    protected boolean checkForSelectionFeatureSegments(int maximum_size, String message) {
        FeatureSegmentVector segments_to_check = this.getSelection().getSelectedSegments();
        if (segments_to_check.size() == 0) {
            new MessageDialog(this.getParentFrame(), "No exons selected");
            return false;
        }
        if (segments_to_check.size() > maximum_size) {
            YesNoDialog dialog = new YesNoDialog(this.getParentFrame(), message);
            return dialog.getResult();
        }
        return true;
    }

    protected boolean checkForSelectionRange() {
        return SelectionMenu.checkForSelectionRange(this.getParentFrame(), this.getSelection());
    }

    static boolean checkForSelectionRange(JFrame frame, Selection selection) {
        MarkerRange marker_range = selection.getMarkerRange();
        if (marker_range == null) {
            new MessageDialog(frame, "No bases selected");
            return false;
        }
        return true;
    }

    protected Selection getSelection() {
        return this.selection;
    }

    protected static KeyStroke makeMenuKeyStroke(int key_code) {
        return KeyStroke.getKeyStroke(key_code, 2);
    }
}

