/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.SelectionMenu;
import uk.ac.sanger.artemis.components.StickyFileChooser;
import uk.ac.sanger.artemis.components.TextRequester;
import uk.ac.sanger.artemis.components.TextRequesterEvent;
import uk.ac.sanger.artemis.components.TextRequesterListener;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;

public class WriteMenu
extends SelectionMenu {
    private EntryGroup entry_group;

    public WriteMenu(JFrame frame, Selection selection, EntryGroup entry_group, String menu_name) {
        super(frame, menu_name, selection);
        this.entry_group = entry_group;
        JMenuItem aa_item = new JMenuItem("Amino Acids Of Selected Features");
        aa_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeAminoAcids();
            }
        });
        this.add(aa_item);
        JMenuItem pir_item = new JMenuItem("PIR Database Of Selected Features");
        pir_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writePIRDataBase();
            }
        });
        this.add(pir_item);
        this.addSeparator();
        JMenu bases_menu = new JMenu("Bases Of Selection");
        JMenuItem raw_bases_item = new JMenuItem("Raw Format");
        raw_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeBasesOfSelection(3);
            }
        });
        bases_menu.add(raw_bases_item);
        JMenuItem fasta_bases_item = new JMenuItem("FASTA Format");
        fasta_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeBasesOfSelection(4);
            }
        });
        bases_menu.add(fasta_bases_item);
        JMenuItem embl_bases_item = new JMenuItem("EMBL Format");
        embl_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeBasesOfSelection(1);
            }
        });
        bases_menu.add(embl_bases_item);
        JMenuItem genbank_bases_item = new JMenuItem("Genbank Format");
        genbank_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeBasesOfSelection(2);
            }
        });
        bases_menu.add(genbank_bases_item);
        this.add(bases_menu);
        JMenu upstream_bases_menu = new JMenu("Upstream Bases Of Selected Features");
        JMenuItem raw_upstream_bases_item = new JMenuItem("Raw Format");
        raw_upstream_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeUpstreamBases(3);
            }
        });
        upstream_bases_menu.add(raw_upstream_bases_item);
        JMenuItem fasta_upstream_bases_item = new JMenuItem("FASTA Format");
        fasta_upstream_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeUpstreamBases(4);
            }
        });
        upstream_bases_menu.add(fasta_upstream_bases_item);
        JMenuItem embl_upstream_bases_item = new JMenuItem("EMBL Format");
        embl_upstream_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeUpstreamBases(1);
            }
        });
        upstream_bases_menu.add(embl_upstream_bases_item);
        JMenuItem genbank_upstream_bases_item = new JMenuItem("Genbank Format");
        genbank_upstream_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeUpstreamBases(2);
            }
        });
        upstream_bases_menu.add(genbank_upstream_bases_item);
        this.add(upstream_bases_menu);
        JMenu downstream_bases_menu = new JMenu("Downstream Bases Of Selected Features");
        JMenuItem raw_downstream_bases_item = new JMenuItem("Raw Format");
        raw_downstream_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeDownstreamBases(3);
            }
        });
        downstream_bases_menu.add(raw_downstream_bases_item);
        JMenuItem fasta_downstream_bases_item = new JMenuItem("FASTA Format");
        fasta_downstream_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeDownstreamBases(4);
            }
        });
        downstream_bases_menu.add(fasta_downstream_bases_item);
        JMenuItem embl_downstream_bases_item = new JMenuItem("EMBL Format");
        embl_downstream_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeDownstreamBases(1);
            }
        });
        downstream_bases_menu.add(embl_downstream_bases_item);
        JMenuItem genbank_downstream_bases_item = new JMenuItem("Genbank Format");
        genbank_downstream_bases_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeDownstreamBases(2);
            }
        });
        downstream_bases_menu.add(genbank_downstream_bases_item);
        this.add(downstream_bases_menu);
        this.addSeparator();
        JMenu write_all_bases_menu = new JMenu("Write All Bases");
        JMenuItem write_raw_item = new JMenuItem("Raw Format");
        write_raw_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeAllSequence(3);
            }
        });
        write_all_bases_menu.add(write_raw_item);
        JMenuItem write_fasta_item = new JMenuItem("FASTA Format");
        write_fasta_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeAllSequence(4);
            }
        });
        write_all_bases_menu.add(write_fasta_item);
        JMenuItem write_embl_item = new JMenuItem("EMBL Format");
        write_embl_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeAllSequence(1);
            }
        });
        write_all_bases_menu.add(write_embl_item);
        JMenuItem write_genbank_item = new JMenuItem("Genbank Format");
        write_genbank_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeAllSequence(2);
            }
        });
        write_all_bases_menu.add(write_genbank_item);
        this.add(write_all_bases_menu);
        this.addSeparator();
        JMenuItem codon_usage_item = new JMenuItem("Write Codon Usage of Selected Features");
        codon_usage_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WriteMenu.this.writeCodonUsage();
            }
        });
        this.add(codon_usage_item);
    }

    public WriteMenu(JFrame frame, Selection selection, EntryGroup entry_group) {
        this(frame, selection, entry_group, "Write");
    }

    private void writePIRDataBase() {
        if (!this.checkForSelectionFeatures()) {
            return;
        }
        File write_file = this.getWriteFile("Select a PIR output file name ...", "cosmid.pir");
        if (write_file == null) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(write_file);
            FeatureVector features_to_write = this.getSelection().getAllFeatures();
            int i = 0;
            while (i < features_to_write.size()) {
                Feature selection_feature = features_to_write.elementAt(i);
                selection_feature.writePIROfFeature(writer);
                ++i;
            }
            writer.close();
        }
        catch (IOException e) {
            new MessageDialog(this.getParentFrame(), "error while writing: " + e.getMessage());
        }
    }

    private void writeAminoAcids() {
        if (!this.checkForSelectionFeatures()) {
            return;
        }
        File write_file = this.getWriteFile("Select an output file name..", "amino_acids");
        if (write_file == null) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(write_file);
            FeatureVector features_to_write = this.getSelection().getAllFeatures();
            int i = 0;
            while (i < features_to_write.size()) {
                Feature selection_feature = features_to_write.elementAt(i);
                selection_feature.writeAminoAcidsOfFeature(writer);
                ++i;
            }
            writer.close();
        }
        catch (IOException e) {
            new MessageDialog(this.getParentFrame(), "error while writing: " + e.getMessage());
        }
    }

    private void writeBasesOfSelection(int output_type) {
        MarkerRange marker_range = this.getSelection().getMarkerRange();
        if (marker_range == null) {
            this.writeFeatureBases(output_type);
        } else {
            String selection_bases = Strand.markerRangeBases(marker_range);
            this.writeBases(selection_bases, "selected bases", this.getSequenceFileName(output_type), output_type);
        }
    }

    private void writeBases(String sequence, String header, String default_output_filename, int output_type) {
        File write_file = this.getWriteFile("Select an output file name ...", default_output_filename);
        if (write_file == null) {
            return;
        }
        try {
            StreamSequence stream_sequence;
            FileWriter writer = new FileWriter(write_file);
            switch (output_type) {
                case 4: {
                    stream_sequence = new FastaStreamSequence(sequence, header);
                    break;
                }
                case 1: {
                    stream_sequence = new EmblStreamSequence(sequence);
                    break;
                }
                case 2: {
                    stream_sequence = new GenbankStreamSequence(sequence);
                    break;
                }
                default: {
                    stream_sequence = new RawStreamSequence(sequence);
                }
            }
            stream_sequence.writeToStream(writer);
            writer.close();
        }
        catch (IOException e) {
            new MessageDialog(this.getParentFrame(), "error while writing: " + e.getMessage());
        }
    }

    private void writeFeatureBases(int output_type) {
        if (!this.checkForSelectionFeatures()) {
            return;
        }
        File write_file = this.getWriteFile("Select an output file name ...", "bases");
        if (write_file == null) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(write_file);
            FeatureVector features_to_write = this.getSelection().getAllFeatures();
            int i = 0;
            while (i < features_to_write.size()) {
                Feature selection_feature = features_to_write.elementAt(i);
                StringBuffer header_buffer = new StringBuffer();
                header_buffer.append(selection_feature.getSystematicName());
                header_buffer.append(" ");
                header_buffer.append(selection_feature.getIDString());
                header_buffer.append(" ");
                String product = selection_feature.getProductString();
                if (product == null) {
                    header_buffer.append("undefined product");
                } else {
                    header_buffer.append(product);
                }
                header_buffer.append(" ").append(selection_feature.getWriteRange());
                StreamSequence stream_sequence = this.getStreamSequence(selection_feature.getBases(), header_buffer.toString(), output_type);
                stream_sequence.writeToStream(writer);
                ++i;
            }
            writer.close();
        }
        catch (IOException e) {
            new MessageDialog(this.getParentFrame(), "error while writing: " + e.getMessage());
        }
    }

    private StreamSequence getStreamSequence(String sequence, String header, int output_type) {
        switch (output_type) {
            case 4: {
                return new FastaStreamSequence(sequence, header);
            }
            case 1: {
                return new EmblStreamSequence(sequence);
            }
            case 2: {
                return new GenbankStreamSequence(sequence);
            }
        }
        return new RawStreamSequence(sequence);
    }

    private void writeUpstreamBases(final int output_type) {
        if (!this.checkForSelectionFeatures()) {
            return;
        }
        TextRequester text_requester = new TextRequester("write how many bases upstream of each feature?", 18, "");
        text_requester.addTextRequesterListener(new TextRequesterListener(){

            public void actionPerformed(TextRequesterEvent event) {
                if (event.getType() == 2) {
                    return;
                }
                String base_count_string = event.getRequesterText().trim();
                if (base_count_string.length() == 0) {
                    new MessageDialog(WriteMenu.this.getParentFrame(), "no bases written");
                    return;
                }
                try {
                    int base_count = Integer.valueOf(base_count_string);
                    File write_file = WriteMenu.this.getWriteFile("Select an output file name ...", "upstream_" + WriteMenu.this.getSequenceFileName(output_type));
                    if (write_file == null) {
                        return;
                    }
                    try {
                        FileWriter writer = new FileWriter(write_file);
                        FeatureVector features_to_write = WriteMenu.this.getSelection().getAllFeatures();
                        int i = 0;
                        while (i < features_to_write.size()) {
                            Feature selection_feature = features_to_write.elementAt(i);
                            String sequence_string = selection_feature.getUpstreamBases(base_count);
                            String header_line = String.valueOf(selection_feature.getIDString()) + " - " + sequence_string.length() + " bases upstream";
                            StreamSequence stream_sequence = WriteMenu.this.getStreamSequence(sequence_string, header_line, output_type);
                            stream_sequence.writeToStream(writer);
                            ++i;
                        }
                        writer.close();
                    }
                    catch (IOException e) {
                        new MessageDialog(WriteMenu.this.getParentFrame(), "error while writing: " + e.getMessage());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    new MessageDialog(WriteMenu.this.getParentFrame(), "this is not a number: " + base_count_string);
                }
            }
        });
        text_requester.show();
    }

    private void writeDownstreamBases(final int output_type) {
        if (!this.checkForSelectionFeatures()) {
            return;
        }
        TextRequester text_requester = new TextRequester("write how many bases downstream of each feature?", 18, "");
        text_requester.addTextRequesterListener(new TextRequesterListener(){

            public void actionPerformed(TextRequesterEvent event) {
                if (event.getType() == 2) {
                    return;
                }
                String base_count_string = event.getRequesterText().trim();
                if (base_count_string.length() == 0) {
                    new MessageDialog(WriteMenu.this.getParentFrame(), "no bases written");
                    return;
                }
                try {
                    int base_count = Integer.valueOf(base_count_string);
                    File write_file = WriteMenu.this.getWriteFile("Select an output file name ...", "downstream_" + WriteMenu.this.getSequenceFileName(output_type));
                    if (write_file == null) {
                        return;
                    }
                    try {
                        FileWriter writer = new FileWriter(write_file);
                        FeatureVector features_to_write = WriteMenu.this.getSelection().getAllFeatures();
                        int i = 0;
                        while (i < features_to_write.size()) {
                            Feature selection_feature = features_to_write.elementAt(i);
                            String sequence_string = selection_feature.getDownstreamBases(base_count);
                            String header_line = String.valueOf(selection_feature.getIDString()) + " - " + sequence_string.length() + " bases downstream ";
                            StreamSequence stream_sequence = WriteMenu.this.getStreamSequence(sequence_string, header_line, output_type);
                            stream_sequence.writeToStream(writer);
                            ++i;
                        }
                        writer.close();
                    }
                    catch (IOException e) {
                        new MessageDialog(WriteMenu.this.getParentFrame(), "error while writing: " + e.getMessage());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    new MessageDialog(WriteMenu.this.getParentFrame(), "this is not a number: " + base_count_string);
                }
            }
        });
        text_requester.show();
    }

    private static String getWriteRange(Feature feature) {
        return feature.isForwardFeature() ? String.valueOf(feature.getFirstCodingBaseMarker().getRawPosition()) + ":" + feature.getLastBaseMarker().getRawPosition() + " forward" : String.valueOf(feature.getLastBaseMarker().getRawPosition()) + ":" + feature.getFirstCodingBaseMarker().getRawPosition() + " reverse";
    }

    private String getSequenceFileName(int output_type) {
        switch (output_type) {
            case 4: {
                return "sequence.dna";
            }
            case 1: {
                return "sequence.embl";
            }
            case 2: {
                return "sequence.genbank";
            }
        }
        return "sequence.seq";
    }

    private void writeAllSequence(int output_type) {
        String file_name = this.getSequenceFileName(output_type);
        this.writeBases(this.entry_group.getBases().toString(), "all_bases", file_name, output_type);
    }

    private File getWriteFile(String title, String default_name) {
        YesNoDialog yes_no_dialog;
        StickyFileChooser dialog = new StickyFileChooser();
        dialog.setDialogTitle(title);
        dialog.setFileSelectionMode(0);
        dialog.setSelectedFile(new File(default_name));
        dialog.setDialogType(1);
        int status = dialog.showSaveDialog((Component)this.getParentFrame());
        if (status != 0) {
            return null;
        }
        if (dialog.getSelectedFile() == null) {
            return null;
        }
        File write_file = dialog.getSelectedFile();
        if (write_file.exists() && !(yes_no_dialog = new YesNoDialog(this.getParentFrame(), "this file exists: " + write_file + " overwrite it?")).getResult()) {
            return null;
        }
        return write_file;
    }

    private void writeCodonUsage() {
        if (!this.checkForSelectionFeatures()) {
            return;
        }
        File write_file = this.getWriteFile("Select a codon usage output file ...", "usage");
        if (write_file == null) {
            return;
        }
        try {
            int base2;
            PrintWriter writer = new PrintWriter(new FileWriter(write_file));
            int[][][] codon_counts = new int[4][4][4];
            FeatureVector features_to_write = this.getSelection().getAllFeatures();
            int codon_total = 0;
            int i = 0;
            while (i < features_to_write.size()) {
                Feature selection_feature = features_to_write.elementAt(i);
                int base1 = 0;
                while (base1 < 4) {
                    base2 = 0;
                    while (base2 < 4) {
                        int base3 = 0;
                        while (base3 < 4) {
                            int[] nArray = codon_counts[base1][base2];
                            int n = base3;
                            nArray[n] = nArray[n] + selection_feature.getCodonCount(base1, base2, base3);
                            ++base3;
                        }
                        ++base2;
                    }
                    ++base1;
                }
                codon_total += selection_feature.getTranslationBasesLength() / 3;
                ++i;
            }
            int base1 = 0;
            while (base1 < 4) {
                int base3 = 0;
                while (base3 < 4) {
                    StringBuffer buffer = new StringBuffer();
                    base2 = 0;
                    while (base2 < 4) {
                        buffer.append(Bases.letter_index[base1]);
                        buffer.append(Bases.letter_index[base2]);
                        buffer.append(Bases.letter_index[base3]);
                        buffer.append(' ');
                        float per_thousand = codon_total > 0 ? (float)(10000 * codon_counts[base1][base2][base3] / codon_total) * 1.0f / 10.0f : 0.0f;
                        buffer.append(per_thousand);
                        buffer.append("( ").append(codon_counts[base1][base2][base3]);
                        buffer.append(")  ");
                        ++base2;
                    }
                    writer.println(buffer.toString());
                    ++base3;
                }
                ++base1;
            }
            writer.close();
        }
        catch (IOException e) {
            new MessageDialog(this.getParentFrame(), "error while writing: " + e.getMessage());
        }
    }
}

