/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import uk.ac.sanger.artemis.io.LowerInteger;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.UpperInteger;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class FuzzyRange
extends Range {
    private Object start_object = null;
    private Object end_object = null;

    private FuzzyRange(Object start_object, Object end_object) throws OutOfRangeException {
        super(FuzzyRange.getStartPosition(start_object), FuzzyRange.getEndPosition(end_object));
        this.start_object = start_object;
        this.end_object = end_object;
    }

    private FuzzyRange(Object position_object) {
        super(FuzzyRange.getPosition(position_object));
        this.start_object = position_object;
        this.end_object = null;
    }

    public static Range makeRange(Object start_object, Object end_object) throws OutOfRangeException {
        if (end_object == null) {
            return FuzzyRange.makeRange(start_object);
        }
        if (start_object instanceof Integer && end_object instanceof Integer) {
            int end_pos;
            int start_pos = (Integer)start_object;
            if (start_pos <= (end_pos = ((Integer)end_object).intValue())) {
                return new Range(start_pos, end_pos);
            }
            return new Range(end_pos, start_pos);
        }
        return new FuzzyRange(start_object, end_object);
    }

    public static Range makeRange(Object start_object) {
        if (start_object instanceof Integer) {
            return new Range((Integer)start_object);
        }
        return new FuzzyRange(start_object);
    }

    private static int getStartPosition(Object start_object) {
        if (start_object instanceof Integer) {
            return (Integer)start_object;
        }
        if (start_object instanceof LowerInteger) {
            return ((LowerInteger)start_object).getPosition();
        }
        if (start_object instanceof Range) {
            return ((Range)start_object).getStart();
        }
        throw new Error("internal error: object is not recognised: " + start_object);
    }

    private static int getEndPosition(Object end_object) {
        if (end_object instanceof Integer) {
            return (Integer)end_object;
        }
        if (end_object instanceof UpperInteger) {
            return ((UpperInteger)end_object).getPosition();
        }
        if (end_object instanceof Range) {
            return ((Range)end_object).getEnd();
        }
        throw new Error("internal error: object is not recognised: " + end_object);
    }

    private static int getPosition(Object position_object) {
        if (position_object instanceof Integer) {
            return (Integer)position_object;
        }
        if (position_object instanceof LowerInteger) {
            return ((LowerInteger)position_object).getPosition();
        }
        if (position_object instanceof UpperInteger) {
            return ((UpperInteger)position_object).getPosition();
        }
        if (position_object instanceof Range) {
            return ((Range)position_object).getStart();
        }
        throw new Error("internal error: object is not recognised: " + position_object);
    }

    public boolean equals(Range test_range) {
        if (test_range instanceof FuzzyRange) {
            FuzzyRange fuzzy_range = (FuzzyRange)test_range;
            if (this.getStart() != fuzzy_range.getStart()) {
                return false;
            }
            if (this.getEnd() != fuzzy_range.getEnd()) {
                return false;
            }
            if (this.start_object instanceof Integer && fuzzy_range.start_object instanceof Integer && ((Integer)this.start_object).intValue() != ((Integer)fuzzy_range.start_object).intValue()) {
                return false;
            }
            if (this.start_object instanceof LowerInteger && fuzzy_range.start_object instanceof LowerInteger && ((LowerInteger)this.start_object).getPosition() != ((LowerInteger)fuzzy_range.start_object).getPosition()) {
                return false;
            }
            if (this.start_object instanceof Range && fuzzy_range.start_object instanceof Range && ((Range)this.start_object).getStart() != ((Range)fuzzy_range.start_object).getStart()) {
                return false;
            }
            if (this.end_object instanceof Integer && fuzzy_range.end_object instanceof Integer && ((Integer)this.end_object).intValue() != ((Integer)fuzzy_range.end_object).intValue()) {
                return false;
            }
            if (this.end_object instanceof UpperInteger && fuzzy_range.end_object instanceof UpperInteger && ((UpperInteger)this.end_object).getPosition() != ((UpperInteger)fuzzy_range.end_object).getPosition()) {
                return false;
            }
            return !(this.end_object instanceof Range) || !(fuzzy_range.end_object instanceof Range) || ((Range)this.end_object).getEnd() == ((Range)fuzzy_range.end_object).getEnd();
        }
        return false;
    }

    public String toString() {
        String start_string = this.start_object instanceof Range ? "(" + ((Range)this.start_object).getStart() + "." + ((Range)this.start_object).getEnd() + ")" : this.start_object.toString();
        if (this.end_object == null) {
            return start_string;
        }
        String end_string = this.end_object instanceof Range ? "(" + ((Range)this.end_object).getStart() + "." + ((Range)this.end_object).getEnd() + ")" : this.end_object.toString();
        return String.valueOf(start_string) + ".." + end_string;
    }

    public Range change(int start, int end) throws OutOfRangeException {
        if ((this.start_object instanceof Integer || this.start_object instanceof LowerInteger) && (this.end_object instanceof Integer || this.end_object instanceof UpperInteger)) {
            Object new_start_object = this.start_object instanceof Integer ? new Integer(start) : new LowerInteger(new Integer(start));
            Object new_end_object = this.end_object instanceof Integer ? new Integer(end) : new UpperInteger(new Integer(end));
            return new FuzzyRange(new_start_object, new_end_object);
        }
        return new Range(start, end);
    }

    public Range copy() {
        try {
            return FuzzyRange.makeRange(this.start_object, this.end_object);
        }
        catch (OutOfRangeException outOfRangeException) {
            throw new Error("internal error - unexpected exception");
        }
    }
}

