/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.util.Calendar;
import java.util.Date;
import nsdb.Datestamp;
import nsdb.InvalidKey;
import nsdb.InvalidQualifier;
import nsdb.LocationParse;
import nsdb.NucFeaturePackage.QualifierValue_u;
import nsdb.NucFeatureWriter;
import nsdb.OutOfDate;
import nsdb.QualifierParse;
import type.IndexOutOfRange;
import type.InvalidRelation;
import type.NoResult;
import uk.ac.sanger.artemis.io.DateStampFeature;
import uk.ac.sanger.artemis.io.EMBLObject;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.LocationParseException;
import uk.ac.sanger.artemis.io.OutOfDateException;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.RWCorbaEntry;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class RWCorbaFeature
extends EMBLObject
implements DateStampFeature {
    private Date last_query_time = null;
    private final EntryInformation entry_information;
    private NucFeatureWriter feature_handle;
    private Key key;
    private Location location;
    private QualifierVector qualifiers;
    private RWCorbaEntry entry;
    private final long id = id_counter++;
    private static long id_counter = 0L;
    private Date datestamp = null;
    private Location old_location = null;

    public RWCorbaFeature(EntryInformation entry_information, NucFeatureWriter feature_handle) throws NoResult, EntryInformationException {
        this.feature_handle = feature_handle;
        this.entry_information = entry_information;
    }

    public void set(Key key, Location location, QualifierVector qualifiers) throws InvalidRelationException, OutOfRangeException, ReadOnlyException {
        this.setKey(key);
        this.setLocation(location);
        this.setQualifiers(qualifiers);
    }

    public void set(Date datestamp, Key key, Location location, QualifierVector qualifiers) throws InvalidRelationException, OutOfRangeException, ReadOnlyException, OutOfDateException {
        this.setKey(datestamp, key);
        this.setLocation(null, location);
        this.setQualifiers(null, qualifiers);
    }

    private void setEntry(RWCorbaEntry entry) {
        this.entry = entry;
    }

    void setRWCorbaEntry(RWCorbaEntry entry) {
        this.setEntry(entry);
    }

    public void setKey(Key key) throws InvalidRelationException, ReadOnlyException {
        try {
            this.setKey(null, key);
        }
        catch (OutOfDateException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public void setKey(Date datestamp, Key key) throws InvalidRelationException, ReadOnlyException, OutOfDateException {
        if (key == null) {
            return;
        }
        try {
            this.feature_handle.setKey(RWCorbaFeature.makeServerStamp(datestamp), key.toString());
            this.key = key;
        }
        catch (nsdb.ReadOnlyException readOnlyException) {
            throw new ReadOnlyException();
        }
        catch (OutOfDate outOfDate) {
            throw new OutOfDateException();
        }
        catch (InvalidKey e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
        catch (InvalidRelation e) {
            throw new InvalidRelationException(e.reason, key);
        }
    }

    public void setLocation(Location location) throws OutOfRangeException, ReadOnlyException {
        try {
            this.setLocation(null, location);
        }
        catch (OutOfDateException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public void setLocation(Date datestamp, Location location) throws ReadOnlyException, OutOfDateException, OutOfRangeException {
        if (location == null) {
            return;
        }
        try {
            this.feature_handle.setLocation(RWCorbaFeature.makeServerStamp(datestamp), location.toString());
            this.location = location;
            this.old_location = location;
        }
        catch (nsdb.ReadOnlyException readOnlyException) {
            throw new ReadOnlyException();
        }
        catch (OutOfDate outOfDate) {
            throw new OutOfDateException();
        }
        catch (LocationParse e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
        catch (IndexOutOfRange indexOutOfRange) {
            throw new OutOfRangeException(location.toString());
        }
    }

    public void setQualifiers(QualifierVector qualifiers) throws InvalidRelationException, ReadOnlyException {
        try {
            this.setQualifiers(null, qualifiers);
        }
        catch (OutOfDateException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public void setQualifiers(Date datestamp, QualifierVector qualifiers) throws InvalidRelationException, ReadOnlyException, OutOfDateException {
        if (qualifiers == null) {
            return;
        }
        try {
            nsdb.NucFeaturePackage.Qualifier[] qualifier_list = new nsdb.NucFeaturePackage.Qualifier[qualifiers.size()];
            int i = 0;
            while (i < qualifier_list.length) {
                qualifier_list[i] = this.getStructFromQualifier(qualifiers.elementAt(i));
                ++i;
            }
            this.feature_handle.setQualifiers(RWCorbaFeature.makeServerStamp(datestamp), qualifier_list);
            this.qualifiers = qualifiers;
        }
        catch (nsdb.ReadOnlyException readOnlyException) {
            throw new ReadOnlyException();
        }
        catch (OutOfDate outOfDate) {
            throw new OutOfDateException();
        }
        catch (InvalidRelation e) {
            throw new InvalidRelationException(e.reason, this.getKey());
        }
        catch (InvalidQualifier e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
        catch (QualifierParse e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
    }

    public void setQualifier(Qualifier qualifier) throws InvalidRelationException, ReadOnlyException {
        try {
            nsdb.NucFeaturePackage.Qualifier new_qualifier = this.getStructFromQualifier(qualifier);
            this.feature_handle.setQualifier(new Datestamp(0), new_qualifier);
            this.qualifiers = null;
        }
        catch (nsdb.ReadOnlyException readOnlyException) {
            throw new ReadOnlyException();
        }
        catch (OutOfDate outOfDate) {
            System.err.println("setQualifier (): OutOfDate");
        }
        catch (InvalidRelation e) {
            throw new InvalidRelationException(e.reason, this.getKey(), qualifier);
        }
        catch (InvalidQualifier e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
        catch (QualifierParse e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
    }

    public void removeQualifierByName(String name) throws ReadOnlyException {
    }

    public Qualifier addQualifierValues(Qualifier qualifier) throws InvalidRelationException, ReadOnlyException {
        return null;
    }

    long getNumericID() {
        return this.id;
    }

    public Key getKey() {
        this.checkStamp();
        if (this.key == null) {
            this.key = new Key(this.feature_handle.getKey());
        }
        return this.key;
    }

    public Location getLocation() {
        this.checkStamp();
        if (this.location == null) {
            return this.grabLocation();
        }
        return this.location;
    }

    public QualifierVector getQualifiers() {
        this.checkStamp();
        if (this.qualifiers == null) {
            this.qualifiers = new QualifierVector();
            try {
                nsdb.NucFeaturePackage.Qualifier[] corba_qualifier_handles = this.feature_handle.getQualifiers();
                int i = 0;
                while (i < corba_qualifier_handles.length) {
                    nsdb.NucFeaturePackage.Qualifier this_corba_qualifier = corba_qualifier_handles[i];
                    Qualifier new_qualifier = this.getQualifierFromStruct(this_corba_qualifier);
                    this.qualifiers.setQualifier(new_qualifier);
                    ++i;
                }
            }
            catch (NoResult noResult) {}
        }
        return this.qualifiers;
    }

    public Qualifier getQualifierByName(String name) throws InvalidRelationException {
        this.checkStamp();
        return this.getQualifiers().getQualifierByName(name);
    }

    private nsdb.NucFeaturePackage.Qualifier getStructFromQualifier(Qualifier qualifier) {
        StringVector qualifier_values = qualifier.getValues();
        if (qualifier_values == null) {
            return new nsdb.NucFeaturePackage.Qualifier(qualifier.getName(), new QualifierValue_u[0]);
        }
        QualifierValue_u[] return_values = new QualifierValue_u[qualifier_values.size()];
        int i = 0;
        while (i < return_values.length) {
            return_values[i] = new QualifierValue_u();
            return_values[i].text(qualifier_values.elementAt(i));
            ++i;
        }
        return new nsdb.NucFeaturePackage.Qualifier(qualifier.getName(), return_values);
    }

    private Qualifier getQualifierFromStruct(nsdb.NucFeaturePackage.Qualifier handle) {
        try {
            StringVector values = this.getQualifierStringValues(handle);
            EntryInformation entry_info = this.getEntryInformation();
            if (!entry_info.isValidQualifier(this.getKey(), handle.name)) {
                String message = this.getKey() + " cannot have " + handle.name + " as a qualifier";
                throw new InvalidRelationException(message, this.getKey(), new Qualifier(handle.name));
            }
            if (values.size() == 0) {
                return new Qualifier(handle.name);
            }
            return new Qualifier(handle.name, values);
        }
        catch (InvalidRelationException e) {
            System.out.println("exception reading from corba: " + e);
            return null;
        }
    }

    Location grabLocation() {
        try {
            String location_string = this.feature_handle.getLocation().getLocationString();
            if (this.location == null || !this.location.toString().equals(location_string)) {
                this.location = this.old_location != null && location_string.equals(this.old_location.toString()) ? this.old_location : new Location(location_string);
            }
        }
        catch (LocationParseException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (NoResult e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
        return this.location;
    }

    public int getFirstBase() {
        return this.getLocation().getFirstBase();
    }

    public int getLastBase() {
        return this.getLocation().getLastBase();
    }

    public Entry getEntry() {
        return this.entry;
    }

    public Feature copy() {
        EmblStreamFeature new_feature = new EmblStreamFeature(this);
        return new_feature;
    }

    public Date getDatestamp() {
        this.checkServerStamp();
        return this.datestamp;
    }

    private StringVector getQualifierStringValues(nsdb.NucFeaturePackage.Qualifier qualifier) {
        QualifierValue_u[] corba_values = qualifier.values;
        StringVector return_array = new StringVector();
        int value_index = 0;
        while (value_index < corba_values.length) {
            QualifierValue_u corba_value = corba_values[value_index];
            switch (corba_value.discriminator()) {
                case 1: {
                    return_array.add(corba_value.text());
                    break;
                }
                case 3: {
                    return_array.add(String.valueOf(corba_value.integer()));
                    break;
                }
                case 4: {
                    return_array.add(String.valueOf(corba_value.real()));
                    break;
                }
                case 17: {
                    return_array.add(String.valueOf(corba_value.translation_exception()));
                    break;
                }
                case 18: {
                    return_array.add(String.valueOf(corba_value.codon_translation()));
                    break;
                }
                case 19: {
                    return_array.add(String.valueOf(corba_value.anti_codon()));
                    break;
                }
                case 20: {
                    return_array.add(String.valueOf(corba_value.splice_consensus()));
                    break;
                }
                case 21: {
                    return_array.add(String.valueOf(corba_value.repeat_unit()));
                    break;
                }
                case 22: {
                    return_array.add(String.valueOf(corba_value.db_xref()));
                }
            }
            ++value_index;
        }
        return return_array;
    }

    NucFeatureWriter getNucFeatureWriter() {
        return this.feature_handle;
    }

    private void checkStamp() {
        Calendar calendar = Calendar.getInstance();
        Date current_time = calendar.getTime();
        if (this.last_query_time == null || current_time.getTime() - this.last_query_time.getTime() > 10000L) {
            this.checkServerStamp();
            this.last_query_time = current_time;
        }
    }

    private void checkServerStamp() {
        Datestamp server_datestamp = this.feature_handle.getDatestamp();
        if (this.datestamp == null || (long)server_datestamp.value > this.datestamp.getTime() / 1000L) {
            this.datestamp = new Date((long)server_datestamp.value * 1000L);
            this.key = null;
            if (this.location != null) {
                this.old_location = this.location;
            }
            this.location = null;
            this.qualifiers = null;
        }
    }

    private static Datestamp makeServerStamp(Date datestamp) {
        Datestamp server_datestamp = datestamp == null ? new Datestamp(0) : new Datestamp((int)(datestamp.getTime() / 1000L));
        return server_datestamp;
    }

    public EntryInformation getEntryInformation() {
        return this.entry_information;
    }

    public boolean isReadOnly() {
        return false;
    }
}

