/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.plot.CodonUsageFormatException;
import uk.ac.sanger.artemis.plot.CodonWeight;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;

public class CodonUsageWeight
extends CodonWeight {
    private static char[] codon_translation_array = new char[]{'f', 's', 'y', 'c', 'f', 's', 'y', 'c', 'l', 's', '#', '*', 'l', 's', '+', 'w', 'l', 'p', 'h', 'r', 'l', 'p', 'h', 'r', 'l', 'p', 'q', 'r', 'l', 'p', 'q', 'r', 'i', 't', 'n', 's', 'i', 't', 'n', 's', 'i', 't', 'k', 'r', 'm', 't', 'k', 'r', 'v', 'a', 'd', 'g', 'v', 'a', 'd', 'g', 'v', 'a', 'e', 'g', 'v', 'a', 'e', 'g'};
    private final float[] data = new float[64];
    private final float[] residue_data = new float[AminoAcidSequence.symbol_count];
    private final float[] strand_data = new float[64];
    private final float[] strand_residue_data = new float[AminoAcidSequence.symbol_count];
    private final File usage_file;

    public CodonUsageWeight(File usage_file, Strand strand) throws IOException {
        this.usage_file = usage_file;
        this.makeSequenceData(strand);
        this.readFromFile();
    }

    public String getName() {
        return this.usage_file.getName();
    }

    public float getCodonValue(char base1, char base2, char base3) {
        int index_of_base1 = Bases.getIndexOfBase(base1);
        int index_of_base2 = Bases.getIndexOfBase(base2);
        int index_of_base3 = Bases.getIndexOfBase(base3);
        if (index_of_base1 > 3 || index_of_base2 > 3 || index_of_base3 > 3) {
            return 1.0f;
        }
        int index = index_of_base1 * 16 + index_of_base2 * 4 + index_of_base3;
        char translation_character = AminoAcidSequence.getCodonTranslation(base1, base2, base3);
        int synonymous_codon_index = AminoAcidSequence.getSymbolIndex(translation_character);
        return this.data[index] / this.residue_data[synonymous_codon_index] / (this.strand_data[index] / this.strand_residue_data[synonymous_codon_index]);
    }

    private float[] parseLine(String line) throws IOException {
        float[] return_array = new float[4];
        StringTokenizer tokeniser = new StringTokenizer(line = line.trim(), " ()");
        if (tokeniser.countTokens() != 12) {
            String message = "garbage codon usage data file at this point: " + line;
            throw new CodonUsageFormatException(message);
        }
        int i = 0;
        while (i < 4) {
            tokeniser.nextToken();
            String codon_value = tokeniser.nextToken();
            return_array[i] = Float.valueOf(codon_value).floatValue();
            tokeniser.nextToken();
            ++i;
        }
        return return_array;
    }

    private void readDataFromStream(Document document) throws IOException {
        String this_line;
        Reader document_reader = document.getReader();
        BufferedReader buffered_reader = new BufferedReader(document_reader);
        int current_index = 0;
        while ((this_line = buffered_reader.readLine()) != null) {
            if (this_line.trim().length() == 0) continue;
            if (current_index >= 64) {
                String message = "too many lines in the codon usage data file at this point: " + this_line;
                throw new CodonUsageFormatException(message);
            }
            float[] line_data = this.parseLine(this_line);
            int i = 0;
            while (i < 4) {
                int symbol_index;
                int upper_index = (current_index & 0xC) * 4;
                int lower_index = current_index & 3;
                int real_index = upper_index + lower_index + i * 4;
                this.data[real_index] = line_data[i] < 0.01f ? 0.01f : line_data[i];
                char translation_character = codon_translation_array[real_index];
                int n = symbol_index = AminoAcidSequence.getSymbolIndex(translation_character);
                this.residue_data[n] = this.residue_data[n] + this.data[real_index];
                ++i;
            }
            ++current_index;
        }
    }

    private void readFromFile() throws IOException {
        if (Options.readWritePossible()) {
            FileDocument current_dir_document = new FileDocument(this.usage_file);
            this.readDataFromStream(current_dir_document);
        }
    }

    private void makeSequenceData(Strand strand) {
        int first_index = 0;
        while (first_index < 4) {
            int first_base_count = this.getStrandBaseCount(first_index, strand);
            int second_index = 0;
            while (second_index < 4) {
                int second_base_count = this.getStrandBaseCount(second_index, strand);
                int third_index = 0;
                while (third_index < 4) {
                    int symbol_index;
                    int third_base_count = this.getStrandBaseCount(third_index, strand);
                    int strand_data_index = first_index * 16 + second_index * 4 + third_index;
                    this.strand_data[strand_data_index] = 1.0f * (float)first_base_count * (float)second_base_count * (float)third_base_count / (float)strand.getSequenceLength();
                    char translation_character = AminoAcidSequence.codon_translation_array[strand_data_index];
                    int n = symbol_index = AminoAcidSequence.getSymbolIndex(translation_character);
                    this.strand_residue_data[n] = this.strand_residue_data[n] + this.strand_data[strand_data_index];
                    ++third_index;
                }
                ++second_index;
            }
            ++first_index;
        }
    }

    private int getStrandBaseCount(int base_index, Strand strand) {
        switch (base_index) {
            case 0: {
                return strand.getTCount();
            }
            case 1: {
                return strand.getCCount();
            }
            case 2: {
                return strand.getACount();
            }
            case 3: {
                return strand.getGCount();
            }
        }
        return 0;
    }
}

