/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.sequence;

import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerChangeEvent;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.SequenceChangeListener;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

class MarkerInternal
implements SequenceChangeListener {
    private Strand strand;
    private int position;
    Marker parent = null;

    public MarkerInternal(Strand strand, int position) throws OutOfRangeException {
        this.strand = strand;
        this.position = position;
        this.checkPosition(position);
    }

    public Strand getStrand() {
        return this.strand;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) throws OutOfRangeException {
        int old_position = this.position;
        this.checkPosition(position);
        this.position = position;
        if (this.parent != null) {
            this.parent.fireEvent(new MarkerChangeEvent(this.parent, this.getStrand(), old_position));
        }
    }

    public void sequenceChanged(SequenceChangeEvent event) {
        int event_start_base;
        if (event.getType() == 3) {
            return;
        }
        int sub_sequence_length = event.getSubSequence().length();
        Bases bases = this.getStrand().getBases();
        if (this.getStrand().isForwardStrand()) {
            event_start_base = event.getPosition();
        } else if (event.getType() == 2) {
            int new_sequence_length = bases.getLength() - sub_sequence_length;
            event_start_base = new_sequence_length - event.getPosition();
        } else {
            event_start_base = bases.getLength() - event.getPosition();
        }
        if (event.getType() == 1) {
            if (this.position <= event_start_base) {
                return;
            }
            this.position = event_start_base + sub_sequence_length > this.position ? event_start_base : (this.position -= sub_sequence_length);
        } else {
            if (this.position < event_start_base) {
                return;
            }
            this.position += sub_sequence_length;
        }
    }

    private void checkPosition(int position) throws OutOfRangeException {
        if (position < 1 || position > this.strand.getSequenceLength()) {
            throw new OutOfRangeException("position: " + position);
        }
    }
}

