/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.ExactPhraseScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SloppyPhraseScorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;

public class PhraseQuery
extends Query {
    private String field;
    private Vector terms = new Vector();
    private int slop = 0;

    public void setSlop(int s) {
        this.slop = s;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        if (this.terms.size() == 0) {
            this.field = term.field();
        } else if (term.field() != this.field) {
            throw new IllegalArgumentException("All phrase terms must be in the same field: " + term);
        }
        this.terms.addElement(term);
    }

    public Term[] getTerms() {
        return this.terms.toArray(new Term[0]);
    }

    protected Weight createWeight(Searcher searcher) {
        if (this.terms.size() == 1) {
            Term term = (Term)this.terms.elementAt(0);
            TermQuery termQuery = new TermQuery(term);
            termQuery.setBoost(this.getBoost());
            return ((Query)termQuery).createWeight(searcher);
        }
        return new PhraseWeight(searcher);
    }

    public String toString(String f) {
        StringBuffer buffer = new StringBuffer();
        if (!this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        for (int i = 0; i < this.terms.size(); ++i) {
            buffer.append(((Term)this.terms.elementAt(i)).text());
            if (i == this.terms.size() - 1) continue;
            buffer.append(" ");
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PhraseQuery)) {
            return false;
        }
        PhraseQuery other = (PhraseQuery)o;
        return this.getBoost() == other.getBoost() && this.slop == other.slop && this.terms.equals(other.terms);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ Float.floatToIntBits(this.slop) ^ this.terms.hashCode();
    }

    private class PhraseWeight
    implements Weight {
        private Searcher searcher;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;

        public PhraseWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return PhraseQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.idf = this.searcher.getSimilarity().idf(PhraseQuery.this.terms, this.searcher);
            this.queryWeight = this.idf * PhraseQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            if (PhraseQuery.this.terms.size() == 0) {
                return null;
            }
            TermPositions[] tps = new TermPositions[PhraseQuery.this.terms.size()];
            for (int i = 0; i < PhraseQuery.this.terms.size(); ++i) {
                TermPositions p = reader.termPositions((Term)PhraseQuery.this.terms.elementAt(i));
                if (p == null) {
                    return null;
                }
                tps[i] = p;
            }
            if (PhraseQuery.this.slop == 0) {
                return new ExactPhraseScorer(this, tps, this.searcher.getSimilarity(), reader.norms(PhraseQuery.this.field));
            }
            return new SloppyPhraseScorer(this, tps, this.searcher.getSimilarity(), PhraseQuery.this.slop, reader.norms(PhraseQuery.this.field));
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation result = new Explanation();
            result.setDescription("weight(" + this.getQuery() + " in " + doc + "), product of:");
            StringBuffer docFreqs = new StringBuffer();
            StringBuffer query = new StringBuffer();
            query.append('\"');
            for (int i = 0; i < PhraseQuery.this.terms.size(); ++i) {
                if (i != 0) {
                    docFreqs.append(" ");
                    query.append(" ");
                }
                Term term = (Term)PhraseQuery.this.terms.elementAt(i);
                docFreqs.append(term.text());
                docFreqs.append("=");
                docFreqs.append(this.searcher.docFreq(term));
                query.append(term.text());
            }
            query.append('\"');
            Explanation idfExpl = new Explanation(this.idf, "idf(" + PhraseQuery.this.field + ": " + docFreqs + ")");
            Explanation queryExpl = new Explanation();
            queryExpl.setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation boostExpl = new Explanation(PhraseQuery.this.getBoost(), "boost");
            if (PhraseQuery.this.getBoost() != 1.0f) {
                queryExpl.addDetail(boostExpl);
            }
            queryExpl.addDetail(idfExpl);
            Explanation queryNormExpl = new Explanation(this.queryNorm, "queryNorm");
            queryExpl.addDetail(queryNormExpl);
            queryExpl.setValue(boostExpl.getValue() * idfExpl.getValue() * queryNormExpl.getValue());
            result.addDetail(queryExpl);
            Explanation fieldExpl = new Explanation();
            fieldExpl.setDescription("fieldWeight(" + PhraseQuery.this.field + ":" + query + " in " + doc + "), product of:");
            Explanation tfExpl = this.scorer(reader).explain(doc);
            fieldExpl.addDetail(tfExpl);
            fieldExpl.addDetail(idfExpl);
            Explanation fieldNormExpl = new Explanation();
            byte[] fieldNorms = reader.norms(PhraseQuery.this.field);
            float fieldNorm = fieldNorms != null ? Similarity.decodeNorm(fieldNorms[doc]) : 0.0f;
            fieldNormExpl.setValue(fieldNorm);
            fieldNormExpl.setDescription("fieldNorm(field=" + PhraseQuery.this.field + ", doc=" + doc + ")");
            fieldExpl.addDetail(fieldNormExpl);
            fieldExpl.setValue(tfExpl.getValue() * idfExpl.getValue() * fieldNormExpl.getValue());
            result.addDetail(fieldExpl);
            result.setValue(queryExpl.getValue() * fieldExpl.getValue());
            if (queryExpl.getValue() == 1.0f) {
                return fieldExpl;
            }
            return result;
        }
    }
}

