/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.presentations.ISelfUpdatingAction;
import org.eclipse.ui.internal.presentations.SystemMenuClose;
import org.eclipse.ui.internal.presentations.SystemMenuMaximize;
import org.eclipse.ui.internal.presentations.SystemMenuMinimize;
import org.eclipse.ui.internal.presentations.SystemMenuMove;
import org.eclipse.ui.internal.presentations.SystemMenuRestore;
import org.eclipse.ui.internal.presentations.UpdatingActionContributionItem;
import org.eclipse.ui.internal.presentations.r21.R21Colors;
import org.eclipse.ui.internal.presentations.r21.R21PresentationMessages;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabItem;
import org.eclipse.ui.internal.presentations.r21.widgets.R21PaneFolder;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.PresentationUtil;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public class R21BasicStackPresentation
extends StackPresentation {
    private R21PaneFolder paneFolder;
    private IPresentablePart current;
    private boolean activeState = false;
    private MenuManager systemMenuManager = new MenuManager();
    private CLabel titleLabel;
    private boolean shellActive = true;
    private static final String TAB_DATA;
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            if (e.widget instanceof Control) {
                CTabItem oldItem;
                Control ctrl = (Control)e.widget;
                Point globalPos = ctrl.toDisplay(new Point(e.x, e.y));
                CTabItem newItem = R21BasicStackPresentation.this.paneFolder.getItem(R21BasicStackPresentation.this.paneFolder.getControl().toControl(globalPos));
                if (newItem != null && newItem != (oldItem = R21BasicStackPresentation.this.paneFolder.getSelection())) {
                    return;
                }
                if (R21BasicStackPresentation.this.current != null) {
                    R21BasicStackPresentation.this.current.setFocus();
                }
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (R21BasicStackPresentation.this.getSite().getState() == 1) {
                R21BasicStackPresentation.this.getSite().setState(2);
            } else {
                R21BasicStackPresentation.this.getSite().setState(1);
            }
        }
    };
    private MouseListener titleMouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            if (e.widget instanceof Control) {
                Control ctrl = (Control)e.widget;
                Point globalPos = ctrl.toDisplay(new Point(0, ((R21BasicStackPresentation)R21BasicStackPresentation.this).titleLabel.getBounds().height));
                if (e.button == 1 && R21BasicStackPresentation.this.overImage(e.x)) {
                    R21BasicStackPresentation.this.showSystemMenu(globalPos);
                }
            }
        }
    };
    private Listener menuListener = new Listener(){

        public void handleEvent(Event event) {
            Point pos = new Point(event.x, event.y);
            R21BasicStackPresentation.this.showSystemMenu(pos);
        }
    };
    private Listener dragListener = new Listener(){

        public void handleEvent(Event event) {
            Point localPos = new Point(event.x, event.y);
            CTabItem tabUnderPointer = R21BasicStackPresentation.this.paneFolder.getItem(localPos);
            if (tabUnderPointer == null) {
                if (R21BasicStackPresentation.this.paneFolder.getTabPosition() == 1024 && localPos.y < ((R21BasicStackPresentation)R21BasicStackPresentation.this).paneFolder.getControl().getBounds().height - R21BasicStackPresentation.this.paneFolder.getTabHeight()) {
                    tabUnderPointer = R21BasicStackPresentation.this.paneFolder.getSelection();
                } else if (R21BasicStackPresentation.this.paneFolder.getTabPosition() == 128 && localPos.y > R21BasicStackPresentation.this.paneFolder.getTabHeight()) {
                    tabUnderPointer = R21BasicStackPresentation.this.paneFolder.getSelection();
                }
            }
            if (tabUnderPointer == null) {
                R21BasicStackPresentation.this.getSite().dragStart(R21BasicStackPresentation.this.paneFolder.getControl().toDisplay(localPos), false);
                return;
            }
            IPresentablePart part = R21BasicStackPresentation.this.getPartForTab(tabUnderPointer);
            if (R21BasicStackPresentation.this.getSite().isPartMoveable(part)) {
                R21BasicStackPresentation.this.getSite().dragStart(part, R21BasicStackPresentation.this.paneFolder.getControl().toDisplay(localPos), false);
            }
        }
    };
    private Listener selectionListener = new Listener(){

        public void handleEvent(Event e) {
            IPresentablePart item = R21BasicStackPresentation.this.getPartForTab((CTabItem)e.item);
            if (item != null) {
                R21BasicStackPresentation.this.getSite().selectPart(item);
            }
        }
    };
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event e) {
            R21BasicStackPresentation.this.setControlSize();
        }
    };
    private IPropertyListener childPropertyChangeListener = new IPropertyListener(){

        public void propertyChanged(Object source, int property) {
            if (source instanceof IPresentablePart) {
                IPresentablePart part = (IPresentablePart)source;
                R21BasicStackPresentation.this.childPropertyChanged(part, property);
            }
        }
    };
    private DisposeListener tabDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget instanceof CTabItem) {
                CTabItem item = (CTabItem)e.widget;
                IPresentablePart part = R21BasicStackPresentation.this.getPartForTab(item);
                part.removePropertyListener(R21BasicStackPresentation.this.childPropertyChangeListener);
            }
        }
    };
    private ShellAdapter shellListener = new ShellAdapter(){

        public void shellActivated(ShellEvent event) {
            R21BasicStackPresentation.this.shellActive = true;
            R21BasicStackPresentation.this.updateGradient();
        }

        public void shellDeactivated(ShellEvent event) {
            R21BasicStackPresentation.this.shellActive = false;
            R21BasicStackPresentation.this.updateGradient();
        }
    };
    private ToolBar viewToolBar;
    private ToolItem pullDownButton;
    private ToolItem closeButton;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.presentations.R21BasicStackPresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAB_DATA = String.valueOf(clazz.getName()) + ".partId";
    }

    public R21BasicStackPresentation(R21PaneFolder control, IStackPresentationSite stackSite) {
        super(stackSite);
        this.paneFolder = control;
        this.shellActive = this.paneFolder.getControl().getShell().equals(control.getControl().getDisplay().getActiveShell());
        this.titleLabel = new CLabel(this.paneFolder.getControl(), 32);
        this.titleLabel.setVisible(false);
        this.titleLabel.moveAbove(null);
        this.titleLabel.addMouseListener(this.titleMouseListener);
        this.titleLabel.addMouseListener(this.mouseListener);
        this.titleLabel.addListener(35, this.menuListener);
        PresentationUtil.addDragListener((Control)this.titleLabel, (Listener)this.dragListener);
        this.viewToolBar = new ToolBar(control.getControl(), 0x800100);
        this.viewToolBar.moveAbove(null);
        this.pullDownButton = new ToolItem(this.viewToolBar, 8);
        Image hoverImage = WorkbenchImages.getImage((String)"IMG_LCL_VIEW_MENU_HOVER");
        this.pullDownButton.setDisabledImage(null);
        this.pullDownButton.setImage(hoverImage);
        this.pullDownButton.setToolTipText(R21PresentationMessages.getString("BasicStackPresentation.menu"));
        this.pullDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                R21BasicStackPresentation.this.showPaneMenu();
            }
        });
        this.paneFolder.getControl().addListener(13, this.selectionListener);
        this.paneFolder.getControl().addListener(11, this.resizeListener);
        this.paneFolder.getControl().addMouseListener(this.mouseListener);
        this.paneFolder.getControl().addListener(35, this.menuListener);
        PresentationUtil.addDragListener((Control)this.paneFolder.getControl(), (Listener)this.dragListener);
        this.paneFolder.getControl().getShell().addShellListener((ShellListener)this.shellListener);
        this.populateSystemMenu((IMenuManager)this.systemMenuManager);
    }

    private boolean overImage(int x) {
        return x < this.titleLabel.getImage().getBounds().width;
    }

    private void populateSystemMenu(IMenuManager systemMenuManager) {
        systemMenuManager.add((IContributionItem)new GroupMarker("misc"));
        systemMenuManager.add((IContributionItem)new GroupMarker("restore"));
        systemMenuManager.add((IContributionItem)new UpdatingActionContributionItem((ISelfUpdatingAction)new SystemMenuRestore(this.getSite())));
        systemMenuManager.add((IContributionItem)new SystemMenuMove(this.getSite(), this.getPaneName()));
        systemMenuManager.add((IContributionItem)new GroupMarker("size"));
        systemMenuManager.add((IContributionItem)new GroupMarker("state"));
        systemMenuManager.add((IContributionItem)new UpdatingActionContributionItem((ISelfUpdatingAction)new SystemMenuMinimize(this.getSite())));
        systemMenuManager.add((IContributionItem)new UpdatingActionContributionItem((ISelfUpdatingAction)new SystemMenuMaximize(this.getSite())));
        systemMenuManager.add((IContributionItem)new Separator("close"));
        systemMenuManager.add((IContributionItem)new UpdatingActionContributionItem((ISelfUpdatingAction)new SystemMenuClose(this.getSite())));
        this.getSite().addSystemActions(systemMenuManager);
    }

    protected String getPaneName() {
        return R21PresentationMessages.getString("BasicStackPresentation.pane");
    }

    public void showPaneMenu() {
        IPartMenu menu = this.getPartMenu();
        if (menu != null) {
            Rectangle bounds = DragUtil.getDisplayBounds((Control)this.viewToolBar);
            menu.showMenu(new Point(bounds.x, bounds.y + bounds.height));
        }
    }

    protected IPresentablePart getCurrent() {
        return this.current;
    }

    private final int indexOf(IPresentablePart part) {
        if (part == null) {
            return this.paneFolder.getItemCount();
        }
        CTabItem[] items = this.paneFolder.getItems();
        int idx = 0;
        while (idx < items.length) {
            IPresentablePart tabPart = this.getPartForTab(items[idx]);
            if (part == tabPart) {
                return idx;
            }
            ++idx;
        }
        return items.length;
    }

    protected final CTabItem getTab(IPresentablePart part) {
        CTabItem[] items = this.paneFolder.getItems();
        int idx = this.indexOf(part);
        if (idx < items.length) {
            return items[idx];
        }
        return null;
    }

    protected void childPropertyChanged(IPresentablePart part, int property) {
        CTabItem tab = this.getTab(part);
        this.initTab(tab, part);
        switch (property) {
            case 146: {
                break;
            }
            case 1: 
            case 147: 
            case 148: 
            case 770: {
                this.setControlSize();
            }
        }
    }

    protected final IPresentablePart getPartForTab(CTabItem item) {
        IPresentablePart part = (IPresentablePart)item.getData(TAB_DATA);
        return part;
    }

    protected R21PaneFolder getPaneFolder() {
        return this.paneFolder;
    }

    public boolean isDisposed() {
        return this.paneFolder == null || this.paneFolder.isDisposed();
    }

    protected void updateGradient() {
        int[] bgPercents;
        Color[] bgColors;
        Color fgColor;
        if (this.isDisposed()) {
            return;
        }
        boolean vertical = false;
        if (this.isActive()) {
            if (this.getShellActivated()) {
                fgColor = R21Colors.getSystemColor(30);
                bgColors = R21Colors.getActiveViewGradient();
                bgPercents = R21Colors.getActiveViewGradientPercents();
            } else {
                fgColor = R21Colors.getSystemColor(33);
                bgColors = R21Colors.getDeactivatedViewGradient();
                bgPercents = R21Colors.getDeactivatedViewGradientPercents();
            }
        } else {
            fgColor = R21Colors.getSystemColor(24);
            bgColors = null;
            bgPercents = null;
        }
        this.drawGradient(fgColor, bgColors, bgPercents, vertical);
    }

    public void drawGradient(Color fgColor, Color[] bgColors, int[] percentages, boolean vertical) {
        if (this.titleLabel == null || this.viewToolBar == null) {
            return;
        }
        this.titleLabel.setBackground(bgColors, percentages, vertical);
        this.titleLabel.setForeground(fgColor);
        this.titleLabel.update();
    }

    public boolean isActive() {
        return this.activeState;
    }

    public void setControlSize() {
        if (this.current != null) {
            this.paneFolder.setTopLeft((Control)this.titleLabel);
            this.titleLabel.setText(this.current.getTitle());
            this.titleLabel.setImage(this.current.getTitleImage());
            this.titleLabel.setVisible(true);
        }
        Control currentToolbar = this.getCurrentToolbar();
        this.paneFolder.setTopCenter(currentToolbar);
        IPartMenu partMenu = this.getPartMenu();
        if (partMenu != null) {
            this.pullDownButton.setEnabled(true);
        } else {
            this.pullDownButton.setEnabled(false);
        }
        this.paneFolder.setTopRight((Control)this.viewToolBar);
        this.viewToolBar.setVisible(true);
        this.paneFolder.layout(true);
        if (this.current != null) {
            Rectangle clientArea = this.paneFolder.getClientArea();
            Rectangle bounds = this.paneFolder.getControl().getBounds();
            clientArea.x += bounds.x;
            clientArea.y += bounds.y;
            this.current.setBounds(clientArea);
        }
    }

    protected IPartMenu getPartMenu() {
        IPresentablePart part = this.getCurrentPart();
        if (part == null) {
            return null;
        }
        return part.getMenu();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.paneFolder.getControl().getShell().removeShellListener((ShellListener)this.shellListener);
        PresentationUtil.removeDragListener((Control)this.paneFolder.getControl(), (Listener)this.dragListener);
        PresentationUtil.removeDragListener((Control)this.titleLabel, (Listener)this.dragListener);
        this.systemMenuManager.dispose();
        this.systemMenuManager.removeAll();
        this.paneFolder.getControl().dispose();
        this.paneFolder = null;
        this.titleLabel.dispose();
        this.titleLabel = null;
        this.viewToolBar.dispose();
    }

    public void setActive(boolean isActive) {
        this.activeState = isActive;
        this.updateGradient();
    }

    boolean getShellActivated() {
        return this.shellActive;
    }

    public Window getWindow() {
        Object data;
        Control ctrl = this.getControl();
        if (ctrl != null && (data = ctrl.getShell().getData()) instanceof Window) {
            return (Window)data;
        }
        return null;
    }

    private CTabItem createPartTab(IPresentablePart part, int tabIndex) {
        int style = 0;
        if (this.getSite().isCloseable(part)) {
            style |= 0x40;
        }
        CTabItem tabItem = this.paneFolder.createItem(style, tabIndex);
        tabItem.setData(TAB_DATA, part);
        part.addPropertyListener(this.childPropertyChangeListener);
        tabItem.addDisposeListener(this.tabDisposeListener);
        this.initTab(tabItem, part);
        return tabItem;
    }

    private void updateCloseButton() {
        if (this.current == null || !this.getSite().isCloseable(this.current)) {
            if (this.closeButton != null) {
                this.closeButton.dispose();
                this.closeButton = null;
                this.paneFolder.flush();
            }
            return;
        }
        if (this.closeButton != null) {
            return;
        }
        this.closeButton = new ToolItem(this.viewToolBar, 8);
        this.closeButton.setDisabledImage(null);
        this.closeButton.setImage(WorkbenchImages.getImage((String)"IMG_LCL_CLOSE_VIEW_HOVER"));
        this.closeButton.setToolTipText(R21PresentationMessages.getString("BasicStackPresentation.close"));
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                R21BasicStackPresentation.this.close(R21BasicStackPresentation.this.getCurrent());
            }
        });
        this.paneFolder.flush();
    }

    protected void initTab(CTabItem tabItem, IPresentablePart part) {
        tabItem.setText(part.getName());
        String toolTipText = part.getTitleToolTip();
        if (!toolTipText.equals("")) {
            tabItem.setToolTipText(toolTipText);
        }
    }

    public void addPart(IPresentablePart newPart, Object cookie) {
        int idx = cookie instanceof Integer ? ((Integer)cookie).intValue() : this.paneFolder.getItemCount();
        this.addPart(newPart, idx);
    }

    public void addPart(IPresentablePart newPart, int index) {
        if (this.getTab(newPart) != null) {
            return;
        }
        this.createPartTab(newPart, index);
        this.setControlSize();
    }

    public void removePart(IPresentablePart oldPart) {
        CTabItem item;
        if (this.current == oldPart) {
            this.titleLabel.setImage(null);
            this.current = null;
        }
        if ((item = this.getTab(oldPart)) == null) {
            return;
        }
        oldPart.setVisible(false);
        item.dispose();
        this.setControlSize();
    }

    public void selectPart(IPresentablePart toSelect) {
        if (toSelect == this.current) {
            return;
        }
        if (this.current != null) {
            this.current.setVisible(false);
        }
        this.current = toSelect;
        if (this.current != null) {
            this.paneFolder.setSelection(this.indexOf(this.current));
            this.current.setVisible(true);
            this.updateCloseButton();
            this.setControlSize();
        }
    }

    public IPresentablePart getCurrentPart() {
        return this.current;
    }

    public void setBounds(Rectangle bounds) {
        if (this.getSite().getState() == 0) {
            bounds = Geometry.copy((Rectangle)bounds);
            bounds.height = this.computePreferredSize(false, Integer.MAX_VALUE, bounds.width, Integer.MAX_VALUE);
        }
        this.paneFolder.getControl().setBounds(bounds);
        this.setControlSize();
    }

    public Point computeMinimumSize() {
        Point result = Geometry.getSize((Rectangle)this.paneFolder.computeTrim(0, 0, 0, 0));
        result.x += 100;
        return result;
    }

    public void setVisible(boolean isVisible) {
        if (this.current != null) {
            this.current.setVisible(isVisible);
        }
        this.paneFolder.getControl().setVisible(isVisible);
    }

    public void setState(int state) {
    }

    public IMenuManager getSystemMenuManager() {
        return this.systemMenuManager;
    }

    protected void showSystemMenu(Point point) {
        Menu aMenu = this.systemMenuManager.createContextMenu((Control)this.paneFolder.getControl().getParent());
        this.systemMenuManager.update(true);
        aMenu.setLocation(point.x, point.y);
        aMenu.setVisible(true);
    }

    public Control getControl() {
        return this.paneFolder.getControl();
    }

    public StackDropResult dragOver(Control currentControl, Point location) {
        Point localPos = this.paneFolder.getControl().toControl(location);
        CTabItem tabUnderPointer = this.paneFolder.getItem(localPos);
        if (tabUnderPointer == null) {
            return null;
        }
        int dragOverIndex = this.paneFolder.indexOf(tabUnderPointer);
        return new StackDropResult(Geometry.toDisplay((Control)this.paneFolder.getControl(), (Rectangle)tabUnderPointer.getBounds()), (Object)new Integer(dragOverIndex));
    }

    protected Control getCurrentToolbar() {
        IPresentablePart part = this.getCurrentPart();
        if (part == null) {
            return null;
        }
        return part.getToolBar();
    }

    public void showSystemMenu() {
        IPresentablePart part = this.getCurrentPart();
        if (part != null) {
            Rectangle bounds = DragUtil.getDisplayBounds((Control)this.paneFolder.getControl());
            int idx = this.paneFolder.getSelectionIndex();
            if (idx > -1) {
                CTabItem item = this.paneFolder.getItem(idx);
                Rectangle itemBounds = item.getBounds();
                bounds.x += itemBounds.x;
                bounds.y += itemBounds.y;
            }
            Point location = new Point(bounds.x, bounds.y + this.paneFolder.getTabHeight());
            this.showSystemMenu(location);
        }
    }

    public Control[] getTabList(IPresentablePart part) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.paneFolder.getTabPosition() == 1024) {
            if (part.getToolBar() != null) {
                list.add(part.getToolBar());
            }
            if (part.getControl() != null) {
                list.add(part.getControl());
            }
            if (this.getPaneFolder() != null) {
                list.add(this.getPaneFolder().getControl());
            }
        } else {
            if (this.getPaneFolder() != null) {
                list.add(this.getPaneFolder().getControl());
            }
            if (part.getToolBar() != null) {
                list.add(part.getToolBar());
            }
            if (part.getControl() != null) {
                list.add(part.getControl());
            }
        }
        return list.toArray(new Control[list.size()]);
    }

    protected void showList(Shell parentShell, int x, int y) {
    }

    protected void showListDefaultLocation() {
        R21PaneFolder tabFolder = this.getPaneFolder();
        Shell shell = tabFolder.getControl().getShell();
        Rectangle clientArea = tabFolder.getClientArea();
        Point location = tabFolder.getControl().getDisplay().map((Control)tabFolder.getControl(), null, clientArea.x, clientArea.y);
        this.showList(shell, location.x, location.y);
    }

    void setSelection(CTabItem tabItem) {
        this.getSite().selectPart(this.getPartForTab(tabItem));
    }

    void close(IPresentablePart presentablePart) {
        this.getSite().close(new IPresentablePart[]{presentablePart});
    }

    Image getLabelImage(IPresentablePart presentablePart) {
        return presentablePart.getTitleImage();
    }

    String getLabelText(IPresentablePart presentablePart, boolean includePath) {
        String title = presentablePart.getTitle().trim();
        return title;
    }

    public void setActive(int newState) {
        this.setActive(newState == 1);
    }
}

