/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.refresh.win32;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.refresh.win32.Win32Natives;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class Win32Monitor
extends Job
implements IRefreshMonitor {
    private static final long RESCHEDULE_DELAY = 1000L;
    private static final String DEBUG_PREFIX = "Win32RefreshMonitor: ";
    private static final int WAIT_FOR_MULTIPLE_OBJECTS_TIMEOUT = 300;
    protected MultiStatus errors;
    protected long[][] fHandleValueArrays;
    protected Map fHandleValueToHandle;
    protected IRefreshResult result;

    public Win32Monitor(IRefreshResult result) {
        super(Policy.bind((String)"WM.jobName"));
        this.result = result;
        this.setPriority(50);
        this.setSystem(true);
        this.fHandleValueToHandle = new HashMap(1);
        this.setHandleValueArrays(this.createHandleArrays());
    }

    protected synchronized void addException(String message) {
        if (this.errors == null) {
            String msg = Policy.bind((String)"WM.errors");
            this.errors = new MultiStatus("org.eclipse.core.resources", 1, msg, null);
        }
        this.errors.add((IStatus)new Status(4, "org.eclipse.core.resources", 1, message, null));
    }

    private long[][] balancedSplit(long[] array, int max) {
        int elementCount = array.length;
        int subArrayCount = (elementCount - 1) / max + 1;
        int subArrayBaseLength = elementCount / subArrayCount;
        int overflow = elementCount % subArrayCount;
        long[][] result = new long[subArrayCount][];
        int count = 0;
        int i = 0;
        while (i < subArrayCount) {
            int subArrayLength = subArrayBaseLength + (overflow-- > 0 ? 1 : 0);
            long[] subArray = new long[subArrayLength];
            int j = 0;
            while (j < subArrayLength) {
                subArray[j] = array[count++];
                ++j;
            }
            result[i] = subArray;
            ++i;
        }
        return result;
    }

    private Handle createHandle(IResource resource) {
        if (resource.isLinked()) {
            return new LinkedResourceHandle(resource);
        }
        return new ResourceHandle(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[][] createHandleArrays() {
        long[] handles;
        Map map = this.fHandleValueToHandle;
        synchronized (map) {
            Set keys = this.fHandleValueToHandle.keySet();
            int size = keys.size();
            if (size == 0) {
                return new long[0][0];
            }
            handles = new long[size];
            int count = 0;
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                handles[count++] = (Long)i.next();
            }
        }
        return this.balancedSplit(handles, Win32Natives.MAXIMUM_WAIT_OBJECTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handle getHandle(IResource resource) {
        if (resource == null) {
            return null;
        }
        Map map = this.fHandleValueToHandle;
        synchronized (map) {
            Iterator i = this.fHandleValueToHandle.values().iterator();
            while (i.hasNext()) {
                ResourceHandle resourceHandle;
                Handle handle = (Handle)i.next();
                if (!(handle instanceof ResourceHandle) || !(resourceHandle = (ResourceHandle)handle).getResource().equals((Object)resource)) continue;
                return handle;
            }
        }
        return null;
    }

    private long[][] getHandleValueArrays() {
        return this.fHandleValueArrays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean monitor(IResource resource) {
        IPath location = resource.getLocation();
        if (location == null) {
            return false;
        }
        Handle handle = this.createHandle(resource);
        Win32Monitor win32Monitor = this;
        synchronized (win32Monitor) {
            handle.open();
        }
        this.schedule(1000L);
        if (RefreshManager.DEBUG) {
            System.out.println("Win32RefreshMonitor:  added monitor for: " + resource);
        }
        return true;
    }

    protected void removeHandle(Handle handle) {
        ArrayList<Handle> handles = new ArrayList<Handle>(1);
        handles.add(handle);
        this.removeHandles(handles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHandles(Collection handles) {
        Win32Monitor win32Monitor = this;
        synchronized (win32Monitor) {
            Iterator i = handles.iterator();
            while (i.hasNext()) {
                Handle handle = (Handle)i.next();
                this.fHandleValueToHandle.remove(new Long(handle.getHandleValue()));
                handle.destroy();
            }
            this.setHandleValueArrays(this.createHandleArrays());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        long start;
        block13: {
            IStatus iStatus;
            block12: {
                start = -System.currentTimeMillis();
                if (RefreshManager.DEBUG) {
                    System.out.println("Win32RefreshMonitor: job started.");
                }
                try {
                    long[][] handleArrays = this.getHandleValueArrays();
                    monitor.beginTask(Policy.bind((String)"WM.beginTask"), handleArrays.length);
                    int i = 0;
                    int length = handleArrays.length;
                    while (i < length) {
                        if (monitor.isCanceled()) {
                            iStatus = Status.CANCEL_STATUS;
                            Object var7_9 = null;
                            break block12;
                        }
                        this.waitForNotification(handleArrays[i]);
                        monitor.worked(1);
                        ++i;
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    monitor.done();
                    start += System.currentTimeMillis();
                    if (RefreshManager.DEBUG) {
                        System.out.println("Win32RefreshMonitor: job finished in: " + start + "ms");
                    }
                    throw throwable;
                }
            }
            monitor.done();
            start += System.currentTimeMillis();
            if (RefreshManager.DEBUG) {
                System.out.println("Win32RefreshMonitor: job finished in: " + start + "ms");
            }
            return iStatus;
        }
        Object var7_11 = null;
        monitor.done();
        start += System.currentTimeMillis();
        if (RefreshManager.DEBUG) {
            System.out.println("Win32RefreshMonitor: job finished in: " + start + "ms");
        }
        long delay = Math.max(1000L, start * 30L);
        if (RefreshManager.DEBUG) {
            System.out.println("Win32RefreshMonitor: rescheduling in: " + delay / 1000L + " seconds");
        }
        if (Platform.getBundle((String)"org.eclipse.core.resources").getState() == 32) {
            this.schedule(delay);
        }
        MultiStatus result = this.errors;
        this.errors = null;
        if (result != null && !result.isOK()) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)result);
        }
        return Status.OK_STATUS;
    }

    protected void setHandleValueArrays(long[][] arrays) {
        this.fHandleValueArrays = arrays;
    }

    public boolean shouldRun() {
        return !this.fHandleValueToHandle.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmonitor(IResource resource) {
        if (resource == null) {
            Map map = this.fHandleValueToHandle;
            synchronized (map) {
                this.removeHandles(new ArrayList(this.fHandleValueToHandle.values()));
            }
        } else {
            Handle handle = this.getHandle(resource);
            if (handle != null) {
                this.removeHandle(handle);
            }
        }
        if (this.fHandleValueToHandle.isEmpty()) {
            this.cancel();
        }
    }

    private void waitForNotification(long[] handleValues) {
        int handleCount = handleValues.length;
        int index = Win32Natives.WaitForMultipleObjects(handleCount, handleValues, false, 300);
        if (index == Win32Natives.WAIT_TIMEOUT) {
            return;
        }
        if (index == Win32Natives.WAIT_FAILED) {
            int error = Win32Natives.GetLastError();
            if (error != Win32Natives.ERROR_INVALID_HANDLE && error != Win32Natives.ERROR_SUCCESS) {
                this.addException(Policy.bind((String)"WM.nativeErr", (String)Integer.toString(error)));
                this.result.monitorFailed((IRefreshMonitor)this, null);
            }
            return;
        }
        Handle handle = (Handle)this.fHandleValueToHandle.get(new Long(handleValues[index -= Win32Natives.WAIT_OBJECT_0]));
        if (handle != null) {
            handle.handleNotification();
        }
    }

    protected abstract class ChainedHandle
    extends Handle {
        private ChainedHandle next;
        private ChainedHandle previous;

        protected ChainedHandle() {
        }

        public abstract boolean exists();

        public ChainedHandle getNext() {
            return this.next;
        }

        public ChainedHandle getPrevious() {
            return this.previous;
        }

        public void setNext(ChainedHandle next) {
            this.next = next;
        }

        public void setPrevious(ChainedHandle previous) {
            this.previous = previous;
        }
    }

    protected class FileHandle
    extends ChainedHandle {
        private File file;

        public FileHandle(File file) {
            this.file = file;
        }

        public boolean exists() {
            return this.file.exists();
        }

        public File getFile() {
            return this.file;
        }

        public void handleNotification() {
            if (!this.isOpen()) {
                return;
            }
            ChainedHandle next = this.getNext();
            if (next != null) {
                if (next.isOpen()) {
                    if (!next.exists()) {
                        if (next instanceof LinkedResourceHandle) {
                            next.close();
                            LinkedResourceHandle linkedResourceHandle = (LinkedResourceHandle)next;
                            linkedResourceHandle.postRefreshRequest();
                        } else {
                            next.close();
                        }
                        ChainedHandle previous = this.getPrevious();
                        if (previous != null) {
                            previous.open();
                        }
                    }
                } else {
                    next.open();
                    if (next.isOpen()) {
                        ChainedHandle previous = this.getPrevious();
                        previous.close();
                        if (next instanceof LinkedResourceHandle) {
                            ((LinkedResourceHandle)next).postRefreshRequest();
                        }
                    }
                }
            }
            this.findNextChange();
        }

        public void open() {
            if (!this.isOpen()) {
                ChainedHandle next = this.getNext();
                if (next != null && next.isOpen()) {
                    this.openHandleOn(this.file);
                } else {
                    ChainedHandle previous;
                    if (this.exists()) {
                        this.openHandleOn(this.file);
                    }
                    if ((previous = this.getPrevious()) != null) {
                        previous.open();
                    }
                }
            }
        }
    }

    protected abstract class Handle {
        protected long handleValue = Win32Natives.INVALID_HANDLE_VALUE;

        public void close() {
            if (this.isOpen()) {
                int error;
                if (!Win32Natives.FindCloseChangeNotification(this.handleValue) && (error = Win32Natives.GetLastError()) != Win32Natives.ERROR_INVALID_HANDLE) {
                    Win32Monitor.this.addException(Policy.bind((String)"WM.errCloseHandle", (String)Integer.toString(error)));
                }
                if (RefreshManager.DEBUG) {
                    System.out.println("Win32RefreshMonitor: removed handle: " + this.handleValue);
                }
                this.handleValue = Win32Natives.INVALID_HANDLE_VALUE;
            }
        }

        private long createHandleValue(String path, boolean monitorSubtree, int flags) {
            long handle = Win32Natives.FindFirstChangeNotification(path, monitorSubtree, flags);
            if (handle == Win32Natives.INVALID_HANDLE_VALUE) {
                int error = Win32Natives.GetLastError();
                Win32Monitor.this.addException(Policy.bind((String)"WM.errCreateHandle", (String)path, (String)Integer.toString(error)));
            }
            return handle;
        }

        public void destroy() {
            this.close();
        }

        protected void findNextChange() {
            if (!Win32Natives.FindNextChangeNotification(this.handleValue)) {
                int error = Win32Natives.GetLastError();
                if (error != Win32Natives.ERROR_INVALID_HANDLE && error != Win32Natives.ERROR_SUCCESS) {
                    Win32Monitor.this.addException(Policy.bind((String)"WM.errFindChange", (String)Integer.toString(error)));
                }
                Win32Monitor.this.removeHandle(this);
            }
        }

        public long getHandleValue() {
            return this.handleValue;
        }

        public abstract void handleNotification();

        public boolean isOpen() {
            return this.handleValue != Win32Natives.INVALID_HANDLE_VALUE;
        }

        public abstract void open();

        protected void openHandleOn(File file) {
            this.openHandleOn(file.getAbsolutePath(), false);
        }

        protected void openHandleOn(IResource resource) {
            this.openHandleOn(resource.getLocation().toOSString(), true);
        }

        private void openHandleOn(String path, boolean subtree) {
            this.setHandleValue(this.createHandleValue(path, subtree, Win32Natives.FILE_NOTIFY_CHANGE_FILE_NAME | Win32Natives.FILE_NOTIFY_CHANGE_DIR_NAME | Win32Natives.FILE_NOTIFY_CHANGE_LAST_WRITE | Win32Natives.FILE_NOTIFY_CHANGE_SIZE));
            if (this.isOpen()) {
                Win32Monitor.this.fHandleValueToHandle.put(new Long(this.getHandleValue()), this);
                Win32Monitor.this.setHandleValueArrays(Win32Monitor.this.createHandleArrays());
            } else {
                this.close();
            }
        }

        protected void postRefreshRequest(IResource resource) {
            Win32Monitor.this.result.refresh(resource);
        }

        public void setHandleValue(long handleValue) {
            this.handleValue = handleValue;
        }
    }

    protected class LinkedResourceHandle
    extends ChainedHandle {
        private List fileHandleChain;
        private IResource resource;

        public LinkedResourceHandle(IResource resource) {
            this.resource = resource;
            this.createFileHandleChain();
        }

        protected void createFileHandleChain() {
            this.fileHandleChain = new ArrayList(1);
            File file = new File(this.resource.getLocation().toOSString());
            file = file.getParentFile();
            while (file != null) {
                this.fileHandleChain.add(0, new FileHandle(file));
                file = file.getParentFile();
            }
            int size = this.fileHandleChain.size();
            int i = 0;
            while (i < size) {
                ChainedHandle handle = (ChainedHandle)this.fileHandleChain.get(i);
                handle.setPrevious(i > 0 ? (ChainedHandle)this.fileHandleChain.get(i - 1) : null);
                handle.setNext(i + 1 < size ? (ChainedHandle)this.fileHandleChain.get(i + 1) : this);
                ++i;
            }
            this.setPrevious((ChainedHandle)this.fileHandleChain.get(size - 1));
        }

        public void destroy() {
            super.destroy();
            Iterator i = this.fileHandleChain.iterator();
            while (i.hasNext()) {
                Handle handle = (Handle)i.next();
                handle.destroy();
            }
        }

        public boolean exists() {
            IPath location = this.resource.getLocation();
            return location == null ? false : location.toFile().exists();
        }

        public void handleNotification() {
            if (this.isOpen()) {
                this.postRefreshRequest(this.resource);
                this.findNextChange();
            }
        }

        public void open() {
            if (!this.isOpen()) {
                FileHandle handle;
                if (this.exists()) {
                    this.openHandleOn(this.resource);
                }
                if ((handle = (FileHandle)this.getPrevious()) != null && !handle.isOpen()) {
                    handle.open();
                }
            }
        }

        public void postRefreshRequest() {
            this.postRefreshRequest(this.resource);
        }
    }

    protected class ResourceHandle
    extends Handle {
        private IResource resource;

        public ResourceHandle(IResource resource) {
            this.resource = resource;
        }

        public IResource getResource() {
            return this.resource;
        }

        public void handleNotification() {
            if (this.isOpen()) {
                this.postRefreshRequest(this.resource);
                this.findNextChange();
            }
        }

        public void open() {
            if (!this.isOpen()) {
                this.openHandleOn(this.resource);
            }
        }
    }
}

