/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.wizards.ISearchProvider;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;

public class SearchRunner {
    private Shell shell;
    private IRunnableContext context;
    private ISearchProvider searchProvider;
    private IUpdateSearchResultCollector collector;
    private boolean newSearchNeeded;

    public SearchRunner(Shell shell, IRunnableContext context) {
        this.shell = shell;
        this.context = context;
    }

    public void setResultCollector(IUpdateSearchResultCollector collector) {
        this.collector = collector;
    }

    public ISearchProvider getSearchProvider() {
        return this.searchProvider;
    }

    public void setSearchProvider(ISearchProvider searchProvider) {
        if (this.searchProvider != searchProvider) {
            this.newSearchNeeded = true;
        }
        this.searchProvider = searchProvider;
    }

    public void setNewSearchNeeded(boolean value) {
        this.newSearchNeeded = value;
    }

    public boolean isNewSearchNeeded() {
        return this.newSearchNeeded;
    }

    public void runSearch() {
        if (this.searchProvider == null) {
            return;
        }
        try {
            this.context.run(true, true, this.getSearchOperation(this.collector));
            this.newSearchNeeded = false;
        }
        catch (InterruptedException e) {
            if (!"cancel".equals(e.getMessage())) {
                UpdateUI.logException(e);
            }
            this.newSearchNeeded = true;
            return;
        }
        catch (InvocationTargetException e) {
            CoreException ce;
            IStatus status;
            Throwable t = e.getTargetException();
            if (t instanceof CoreException && (status = (ce = (CoreException)t).getStatus()) != null && status.getCode() == 42) {
                ErrorDialog.openError((Shell)this.shell, (String)UpdateUI.getString("SearchRunner.connectionError"), null, (IStatus)status);
                return;
            }
            UpdateUI.logException(e);
            return;
        }
    }

    private IRunnableWithProgress getSearchOperation(final IUpdateSearchResultCollector collector) {
        final UpdateSearchRequest request = this.searchProvider.getSearchRequest();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        request.performSearch(collector, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    if (monitor.isCanceled()) {
                        SearchRunner.this.newSearchNeeded = true;
                        throw new InterruptedException("cancel");
                    }
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
                if (monitor.isCanceled()) {
                    SearchRunner.this.newSearchNeeded = true;
                    throw new InterruptedException("cancel");
                }
            }
        };
        return op;
    }
}

