/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.ScrolledFormText;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.model.DiscoveryFolder;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.model.SiteCategory;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.wizards.BannerPage;
import org.eclipse.update.internal.ui.wizards.EditSiteDialog;
import org.eclipse.update.internal.ui.wizards.ISearchProvider;
import org.eclipse.update.internal.ui.wizards.LocalSiteSelector;
import org.eclipse.update.internal.ui.wizards.NewUpdateSiteDialog;
import org.eclipse.update.internal.ui.wizards.SearchRunner;
import org.eclipse.update.internal.ui.wizards.SitesImportExport;
import org.eclipse.update.operations.IUpdateModelChangedListener;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchCategory;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;

public class SitePage
extends BannerPage
implements ISearchProvider {
    private static DiscoveryFolder discoveryFolder = new DiscoveryFolder();
    private CheckboxTreeViewer treeViewer;
    private ScrolledFormText descLabel;
    private Button addSiteButton;
    private Button addLocalButton;
    private Button addLocalZippedButton;
    private Button editButton;
    private Button removeButton;
    private Button exportButton;
    private Button importButton;
    private Button envFilterCheck;
    private SearchRunner searchRunner;
    private EnvironmentFilter envFilter;
    private UpdateSearchRequest searchRequest;
    private ModelListener modelListener;

    public SitePage(SearchRunner searchRunner) {
        super("SitePage");
        this.setTitle(UpdateUI.getString("SitePage.title"));
        this.setDescription(UpdateUI.getString("SitePage.desc"));
        UpdateUI.getDefault().getLabelProvider().connect(this);
        this.searchRequest = new UpdateSearchRequest((IUpdateSearchCategory)new SiteSearchCategory(), new UpdateSearchScope());
        this.searchRequest.addFilter((IUpdateSearchFilter)new BackLevelFilter());
        this.envFilter = new EnvironmentFilter();
        this.searchRunner = searchRunner;
        this.modelListener = new ModelListener();
        UpdateUI.getDefault().getUpdateModel().addUpdateModelChangedListener(this.modelListener);
    }

    private void toggleEnvFilter(boolean add) {
        if (add) {
            this.searchRequest.addFilter((IUpdateSearchFilter)this.envFilter);
        } else {
            this.searchRequest.removeFilter((IUpdateSearchFilter)this.envFilter);
        }
        this.searchRunner.setNewSearchNeeded(true);
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect(this);
        UpdateUI.getDefault().getUpdateModel().removeUpdateModelChangedListener(this.modelListener);
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        Label label = new Label(client, 0);
        label.setText(UpdateUI.getString("SitePage.label"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.createTreeViewer(client);
        Composite buttonContainer = new Composite(client, 0);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        this.addSiteButton = new Button(buttonContainer, 8);
        this.addSiteButton.setText(UpdateUI.getString("SitePage.addUpdateSite"));
        this.addSiteButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.addSiteButton);
        this.addSiteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleAddSite();
            }
        });
        this.addLocalButton = new Button(buttonContainer, 8);
        this.addLocalButton.setText(UpdateUI.getString("SitePage.addLocalSite"));
        this.addLocalButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.addLocalButton);
        this.addLocalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleAddLocal();
            }
        });
        this.addLocalZippedButton = new Button(buttonContainer, 8);
        this.addLocalZippedButton.setText(UpdateUI.getString("SitePage.addLocalZippedSite"));
        this.addLocalZippedButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.addLocalZippedButton);
        this.addLocalZippedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleAddLocalZipped();
            }
        });
        new Label(buttonContainer, 0);
        this.editButton = new Button(buttonContainer, 8);
        this.editButton.setText(UpdateUI.getString("SitePage.edit"));
        this.editButton.setEnabled(false);
        this.editButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.editButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleEdit();
            }
        });
        this.removeButton = new Button(buttonContainer, 8);
        this.removeButton.setText(UpdateUI.getString("SitePage.remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.removeButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleRemove();
            }
        });
        new Label(buttonContainer, 0);
        this.importButton = new Button(buttonContainer, 8);
        this.importButton.setText(UpdateUI.getString("SitePage.import"));
        this.importButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.importButton);
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleImport();
            }
        });
        this.exportButton = new Button(buttonContainer, 8);
        this.exportButton.setText(UpdateUI.getString("SitePage.export"));
        this.exportButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.exportButton);
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleExport();
            }
        });
        this.descLabel = new ScrolledFormText(client, true);
        this.descLabel.setText("");
        this.descLabel.setBackground(parent.getBackground());
        HyperlinkSettings settings = new HyperlinkSettings(parent.getDisplay());
        this.descLabel.getFormText().setHyperlinkSettings(settings);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 1;
        this.descLabel.setLayoutData((Object)gd);
        this.envFilterCheck = new Button(client, 32);
        this.envFilterCheck.setText(UpdateUI.getString("SitePage.ignore"));
        this.envFilterCheck.setSelection(true);
        this.toggleEnvFilter(true);
        this.envFilterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.toggleEnvFilter(SitePage.this.envFilterCheck.getSelection());
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.envFilterCheck.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)parent);
        WorkbenchHelp.setHelp((Control)client, (String)"org.eclipse.update.ui.SitePage");
        return client;
    }

    private void createTreeViewer(Composite parent) {
        this.treeViewer = new CheckboxTreeViewer(parent, 2816);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeViewer.setInput((Object)UpdateUI.getDefault().getUpdateModel());
        this.initializeItems();
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                Object element = e.getElement();
                if (element instanceof SiteBookmark) {
                    SitePage.this.handleSiteChecked((SiteBookmark)element, e.getChecked());
                } else if (element instanceof SiteCategory) {
                    SitePage.this.handleCategoryChecked((SiteCategory)((Object)element), e.getChecked());
                }
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                SitePage.this.handleSelectionChanged((IStructuredSelection)e.getSelection());
            }
        });
    }

    private void initializeItems() {
        this.checkItems();
        this.updateSearchRequest();
    }

    private void checkItems() {
        TreeItem[] items = this.treeViewer.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            SiteBookmark bookmark = (SiteBookmark)items[i].getData();
            this.treeViewer.setChecked((Object)bookmark, bookmark.isSelected());
            String[] ignoredCats = bookmark.getIgnoredCategories();
            this.treeViewer.setGrayed((Object)bookmark, ignoredCats.length > 0 && bookmark.isSelected());
            ++i;
        }
    }

    private void handleAddSite() {
        NewUpdateSiteDialog dialog = new NewUpdateSiteDialog(this.getShell());
        dialog.create();
        dialog.getShell().setText(UpdateUI.getString("SitePage.new"));
        if (dialog.open() == 0) {
            this.updateSearchRequest();
        }
    }

    private void handleAddLocal() {
        SiteBookmark siteBookmark = LocalSiteSelector.getLocaLSite(this.getShell());
        if (siteBookmark != null) {
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            model.addBookmark(siteBookmark);
            model.saveBookmarks();
            this.updateSearchRequest();
        }
    }

    private void handleAddLocalZipped() {
        SiteBookmark siteBookmark = LocalSiteSelector.getLocaLZippedSite(this.getShell());
        if (siteBookmark != null) {
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            model.addBookmark(siteBookmark);
            model.saveBookmarks();
            this.updateSearchRequest();
        }
    }

    private void handleRemove() {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                UpdateModel updateModel = UpdateUI.getDefault().getUpdateModel();
                IStructuredSelection ssel = (IStructuredSelection)SitePage.this.treeViewer.getSelection();
                SiteBookmark bookmark = (SiteBookmark)ssel.getFirstElement();
                String selName = bookmark.getLabel();
                boolean answer = MessageDialog.openQuestion((Shell)SitePage.this.getShell(), (String)UpdateUI.getString("SitePage.remove.location.conf.title"), (String)(String.valueOf(UpdateUI.getString("SitePage.remove.location.conf")) + " " + selName));
                if (answer && !bookmark.isReadOnly()) {
                    updateModel.removeBookmark(bookmark);
                    SitePage.this.updateSearchRequest();
                }
            }
        });
    }

    private void handleEdit() {
        URL newURL;
        IStructuredSelection ssel = (IStructuredSelection)this.treeViewer.getSelection();
        SiteBookmark bookmark = (SiteBookmark)ssel.getFirstElement();
        URL oldURL = bookmark.getURL();
        EditSiteDialog dialog = new EditSiteDialog(this.getShell(), bookmark);
        dialog.create();
        String title = bookmark.isLocal() ? UpdateUI.getString("SitePage.dialogEditLocal") : UpdateUI.getString("SitePage.dialogEditUpdateSite");
        dialog.getShell().setText(title);
        if (dialog.open() == 0 && !UpdateManagerUtils.sameURL((URL)oldURL, (URL)(newURL = bookmark.getURL()))) {
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            model.fireObjectChanged(bookmark, null);
            this.updateSearchRequest();
        }
    }

    private void handleImport() {
        SiteBookmark[] siteBookmarks = SitesImportExport.getImportedBookmarks(this.getShell());
        if (siteBookmarks != null && siteBookmarks.length > 0) {
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            SiteBookmark[] currentBookmarks = this.getAllSiteBookmarks();
            int i = 0;
            while (i < siteBookmarks.length) {
                boolean siteExists = false;
                int j = 0;
                while (!siteExists && j < currentBookmarks.length) {
                    if (currentBookmarks[j].getURL().equals(siteBookmarks[i].getURL())) {
                        siteExists = true;
                    }
                    ++j;
                }
                if (!siteExists) {
                    model.addBookmark(siteBookmarks[i]);
                }
                ++i;
            }
            model.saveBookmarks();
            this.updateSearchRequest();
        }
    }

    private void handleExport() {
        SitesImportExport.exportBookmarks(this.getShell(), this.getAllSiteBookmarks());
    }

    private void handleSiteChecked(SiteBookmark bookmark, boolean checked) {
        if (bookmark.isUnavailable()) {
            bookmark.setSelected(false);
            this.treeViewer.setChecked((Object)bookmark, false);
            return;
        }
        bookmark.setSelected(checked);
        if (checked) {
            bookmark.setIgnoredCategories(new String[0]);
        }
        if (checked || bookmark.isSiteConnected()) {
            this.treeViewer.setSubtreeChecked((Object)bookmark, checked);
        }
        if (bookmark.isUnavailable()) {
            this.treeViewer.setChecked((Object)bookmark, false);
            return;
        }
        this.treeViewer.setGrayed((Object)bookmark, false);
        this.updateSearchRequest();
    }

    private void handleSiteExpanded(SiteBookmark bookmark, Object[] cats) {
        if (!bookmark.isSelected()) {
            this.treeViewer.setSubtreeChecked((Object)bookmark, false);
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < cats.length) {
                if (cats[i] instanceof SiteCategory) {
                    result.add(((SiteCategory)((Object)cats[i])).getFullName());
                }
                ++i;
            }
            bookmark.setIgnoredCategories(result.toArray(new String[result.size()]));
        } else {
            String[] ignored = bookmark.getIgnoredCategories();
            HashSet<String> imap = new HashSet<String>();
            int i = 0;
            while (i < ignored.length) {
                imap.add(ignored[i]);
                ++i;
            }
            i = 0;
            while (i < cats.length) {
                if (cats[i] instanceof SiteCategory) {
                    SiteCategory category;
                    this.treeViewer.setChecked((Object)category, !imap.contains((category = (SiteCategory)((Object)cats[i])).getFullName()));
                }
                ++i;
            }
            this.treeViewer.setGrayed((Object)bookmark, ignored.length > 0 && ignored.length < cats.length);
        }
        this.searchRunner.setNewSearchNeeded(true);
    }

    private void handleCategoryChecked(SiteCategory category, boolean checked) {
        SiteBookmark bookmark = category.getBookmark();
        ArrayList<String> array = new ArrayList<String>();
        if (bookmark.isSelected()) {
            String[] ignored = bookmark.getIgnoredCategories();
            int i = 0;
            while (i < ignored.length) {
                array.add(ignored[i]);
                ++i;
            }
        } else {
            Object[] categs = this.getSiteCatalogWithIndicator(bookmark, !bookmark.isSiteConnected());
            int i = 0;
            while (i < categs.length) {
                array.add(((SiteCategory)((Object)categs[i])).getFullName());
                ++i;
            }
        }
        if (checked) {
            array.remove(category.getFullName());
        } else {
            array.add(category.getFullName());
        }
        bookmark.setIgnoredCategories(array.toArray(new String[array.size()]));
        this.searchRunner.setNewSearchNeeded(true);
        Object[] children = ((TreeContentProvider)this.treeViewer.getContentProvider()).getChildren(category.getBookmark());
        this.treeViewer.setChecked((Object)bookmark, array.size() < children.length);
        bookmark.setSelected(array.size() < children.length);
        this.treeViewer.setGrayed((Object)bookmark, array.size() > 0 && array.size() < children.length);
        this.updateSearchRequest();
    }

    private void handleSelectionChanged(IStructuredSelection ssel) {
        IURLEntry descEntry;
        boolean enable = false;
        Object item = ssel.getFirstElement();
        String description = null;
        if (item instanceof SiteBookmark) {
            enable = !((SiteBookmark)item).isReadOnly();
            description = ((SiteBookmark)item).getDescription();
        } else if (item instanceof SiteCategory && (descEntry = ((SiteCategory)((Object)item)).getCategory().getDescription()) != null) {
            description = descEntry.getAnnotation();
        }
        this.editButton.setEnabled(enable);
        this.removeButton.setEnabled(enable);
        if (description == null) {
            description = "";
        }
        this.descLabel.setText(UpdateManagerUtils.getWritableXMLString((String)description));
    }

    private void updateSearchRequest() {
        Object[] checked = this.treeViewer.getCheckedElements();
        UpdateSearchScope scope = new UpdateSearchScope();
        int nsites = 0;
        int i = 0;
        while (i < checked.length) {
            if (checked[i] instanceof SiteBookmark) {
                SiteBookmark bookmark = (SiteBookmark)checked[i];
                scope.addSearchSite(bookmark.getLabel(), bookmark.getURL(), bookmark.getIgnoredCategories());
                ++nsites;
            }
            ++i;
        }
        this.searchRequest.setScope(scope);
        this.searchRunner.setNewSearchNeeded(true);
        this.setPageComplete(nsites > 0);
    }

    public UpdateSearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            this.searchRunner.setSearchProvider(this);
            SiteBookmark[] bookmarks = this.getAllSiteBookmarks();
            int i = 0;
            while (i < bookmarks.length) {
                if (bookmarks[i].isUnavailable()) {
                    bookmarks[i].setUnavailable(false);
                }
                ++i;
            }
        }
    }

    private Object[] getSiteCatalogWithIndicator(final SiteBookmark bookmark, final boolean connect) {
        final CatalogBag bag = new CatalogBag();
        if (bookmark.isUnavailable()) {
            return new Object[0];
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask("", 3);
                        monitor.worked(1);
                        if (connect) {
                            bookmark.connect((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            monitor.worked(1);
                        }
                        bag.catalog = bookmark.getCatalog(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InvocationTargetException e) {
            UpdateUI.logException(e);
        }
        catch (InterruptedException interruptedException) {}
        return bag.catalog == null ? new Object[]{} : bag.catalog;
    }

    private SiteBookmark[] getAllSiteBookmarks() {
        UpdateModel model = UpdateUI.getDefault().getUpdateModel();
        SiteBookmark[] bookmarks = model.getBookmarkLeafs();
        Object[] sitesToVisit = discoveryFolder.getChildren(discoveryFolder);
        SiteBookmark[] all = new SiteBookmark[bookmarks.length + sitesToVisit.length];
        System.arraycopy(bookmarks, 0, all, 0, bookmarks.length);
        System.arraycopy(sitesToVisit, 0, all, bookmarks.length, sitesToVisit.length);
        return all;
    }

    static /* synthetic */ void access$3(SitePage sitePage, SiteBookmark siteBookmark, Object[] objectArray) {
        sitePage.handleSiteExpanded(siteBookmark, objectArray);
    }

    class TreeContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return SitePage.this.getAllSiteBookmarks();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof SiteBookmark) {
                SiteBookmark bookmark = (SiteBookmark)parent;
                if (bookmark.isUnavailable()) {
                    return new Object[0];
                }
                Object[] children = SitePage.this.getSiteCatalogWithIndicator(bookmark, !bookmark.isSiteConnected());
                SitePage.this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(this, children, bookmark){
                    final /* synthetic */ TreeContentProvider this$1;
                    private final /* synthetic */ Object[] val$children;
                    private final /* synthetic */ SiteBookmark val$bookmark;
                    {
                        this.this$1 = treeContentProvider;
                        this.val$children = objectArray;
                        this.val$bookmark = siteBookmark;
                    }

                    public void run() {
                        if (this.val$children.length > 0) {
                            SitePage.access$3(TreeContentProvider.access$0(this.this$1), this.val$bookmark, this.val$children);
                        }
                    }
                });
                return children;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof SiteCategory) {
                return ((SiteCategory)((Object)element)).getBookmark();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof SiteBookmark;
        }

        static /* synthetic */ SitePage access$0(TreeContentProvider treeContentProvider) {
            return treeContentProvider.SitePage.this;
        }
    }

    class TreeLabelProvider
    extends LabelProvider {
        TreeLabelProvider() {
        }

        public Image getImage(Object obj) {
            if (obj instanceof SiteBookmark) {
                return UpdateUI.getDefault().getLabelProvider().get(UpdateUIImages.DESC_SITE_OBJ);
            }
            if (obj instanceof SiteCategory) {
                return UpdateUI.getDefault().getLabelProvider().get(UpdateUIImages.DESC_CATEGORY_OBJ);
            }
            return super.getImage(obj);
        }

        public String getText(Object obj) {
            if (obj instanceof SiteBookmark) {
                return ((SiteBookmark)obj).getLabel();
            }
            return super.getText(obj);
        }
    }

    class ModelListener
    implements IUpdateModelChangedListener {
        ModelListener() {
        }

        public void objectChanged(Object object, String property) {
            SitePage.this.treeViewer.refresh();
            SitePage.this.checkItems();
        }

        public void objectsAdded(Object parent, Object[] children) {
            SitePage.this.treeViewer.refresh();
            SitePage.this.checkItems();
        }

        public void objectsRemoved(Object parent, Object[] children) {
            SitePage.this.treeViewer.refresh();
            SitePage.this.checkItems();
        }
    }

    class CatalogBag {
        Object[] catalog;

        CatalogBag() {
        }
    }
}

