/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.context;

import java.util.List;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.context.ContextsBuilder;
import org.eclipse.help.internal.context.ContextsNode;
import org.eclipse.help.internal.context.IStyledContext;
import org.xml.sax.Attributes;

public class Context
extends ContextsNode
implements IStyledContext {
    private String text;
    protected String pluginID;
    protected String shortID;

    public Context(Attributes attrs) {
        super(attrs);
        if (attrs == null) {
            return;
        }
        this.shortID = attrs.getValue("id");
    }

    private static String stripStyle(String s, String style) {
        int idx;
        int len = s.length();
        int skipLen = style.length();
        StringBuffer sb = new StringBuffer(s.length());
        int lastIdx = 0;
        while ((idx = s.indexOf(style, lastIdx)) != -1) {
            int start = idx;
            boolean hasSpace = false;
            while (start > lastIdx && Character.isWhitespace(s.charAt(start - 1))) {
                --start;
            }
            if (idx != start) {
                hasSpace = true;
            }
            sb.append(s.substring(lastIdx, start));
            int end = idx += skipLen;
            while (end < len && Character.isWhitespace(s.charAt(end))) {
                ++end;
            }
            if (end != idx) {
                hasSpace = true;
            }
            lastIdx = end;
            if (!hasSpace) continue;
            sb.append(' ');
        }
        sb.append(s.substring(lastIdx, len));
        return sb.toString();
    }

    public String getText() {
        return Context.stripStyle(Context.stripStyle(this.text, "<@#$b>"), "</@#$b>");
    }

    public String getStyledText() {
        return this.text;
    }

    public IHelpResource[] getRelatedTopics() {
        if (this.children.size() > 0) {
            IHelpResource[] related = new IHelpResource[this.children.size()];
            this.children.toArray(related);
            return related;
        }
        return null;
    }

    public void setStyledText(String s) {
        this.text = s;
    }

    public String getShortId() {
        return this.shortID;
    }

    public String getID() {
        return String.valueOf(this.pluginID) + "." + this.shortID;
    }

    public void setPluginID(String pluginID) {
        this.pluginID = pluginID;
    }

    public void build(ContextsBuilder builder) {
        builder.build(this);
    }

    public void setChildren(List children) {
        this.children = children;
    }
}

