/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFOA;
import org.eclipse.swt.internal.win32.NMTTDISPINFOW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;

public class Composite
extends Scrollable {
    Layout layout;
    int font;
    WINDOWPOS[] lpwp;
    Control[] tabList;
    int layoutCount = 0;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    /*
     * Unable to fully structure code
     */
    Control[] _getChildren() {
        count = 0;
        hwndChild = OS.GetWindow(this.handle, 5);
        if (hwndChild != 0) ** GOTO lbl7
        return new Control[0];
lbl-1000:
        // 1 sources

        {
            ++count;
            hwndChild = OS.GetWindow(hwndChild, 2);
lbl7:
            // 2 sources

            ** while (hwndChild != 0)
        }
lbl8:
        // 1 sources

        children = new Control[count];
        index = 0;
        hwndChild = OS.GetWindow(this.handle, 5);
        while (hwndChild != 0) {
            control = this.display.getControl(hwndChild);
            if (control != null && control != this) {
                children[index++] = control;
            }
            hwndChild = OS.GetWindow(hwndChild, 2);
        }
        if (count == index) {
            return children;
        }
        newChildren = new Control[index];
        System.arraycopy(children, 0, newChildren, 0, index);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    public void changed(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        i = 0;
        while (i < changed.length) {
            Control child = changed[i];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout == null || !composite.layout.flushCache(child)) {
                    composite.state |= 0x40;
                }
                child = composite;
                composite = child.parent;
            }
            ++i;
        }
    }

    protected void checkSubclass() {
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length != 0) {
                Control[] newResult = new Control[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                boolean bl = (this.state & 0x40) != 0;
                this.state &= 0xFFFFFFBF;
                size = this.layout.computeSize(this, wHint, hHint, changed |= bl);
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize(wHint, hHint, changed);
        }
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 2;
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] result = super.findMenus(control);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            Menu[] menuList = child.findMenus(control);
            if (menuList.length != 0) {
                Menu[] newResult = new Menu[result.length + menuList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(menuList, 0, newResult, result.length, menuList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
            ++i;
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (this.tabList[i] == control) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            int i2 = 0;
            while (i2 < this.tabList.length) {
                if (this.tabList[i2] != control) {
                    newList[index++] = this.tabList[i2];
                }
                ++i2;
            }
        }
        this.tabList = newList;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        int count = 0;
        int hwndChild = OS.GetWindow(this.handle, 5);
        while (hwndChild != 0) {
            ++count;
            hwndChild = OS.GetWindow(hwndChild, 2);
        }
        return count;
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0 || this.parent.isLayoutDeferred();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(changed, false);
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout == null && !all) {
            return;
        }
        this.markLayout(changed, all);
        this.updateLayout(true, all);
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        int updateCount = 0;
        Composite[] update = new Composite[16];
        int i2 = 0;
        while (i2 < changed.length) {
            Control child = changed[i2];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout != null) {
                    composite.state |= 0x20;
                    if (!composite.layout.flushCache(child)) {
                        composite.state |= 0x40;
                    }
                }
                if (updateCount == update.length) {
                    Composite[] newUpdate = new Composite[update.length + 16];
                    System.arraycopy(update, 0, newUpdate, 0, update.length);
                    update = newUpdate;
                }
                int n = updateCount++;
                Composite composite2 = composite;
                update[n] = composite2;
                child = composite2;
                composite = child.parent;
            }
            ++i2;
        }
        i2 = updateCount - 1;
        while (i2 >= 0) {
            update[i2].updateLayout(true, false);
            --i2;
        }
    }

    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.state |= 0x20;
            if (changed) {
                this.state |= 0x40;
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].markLayout(changed, all);
                ++i;
            }
        }
    }

    Point minimumSize(int wHint, int hHint, boolean changed) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    void releaseChildren() {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (!child.isDisposed()) {
                child.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        int threadId;
        int hwndChild;
        this.releaseChildren();
        super.releaseWidget();
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0 && (hwndChild = OS.GetWindow(this.handle, 5)) != 0 && (threadId = OS.GetWindowThreadProcessId(hwndChild, null)) != OS.GetCurrentThreadId()) {
            OS.SetParent(hwndChild, 0);
        }
        this.layout = null;
        this.tabList = null;
        this.lpwp = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
        this.resizeChildren();
    }

    void resizeChildren() {
        if (this.lpwp == null) {
            return;
        }
        do {
            WINDOWPOS[] currentLpwp = this.lpwp;
            this.lpwp = null;
            if (this.resizeChildren(true, currentLpwp)) continue;
            this.resizeChildren(false, currentLpwp);
        } while (this.lpwp != null);
    }

    boolean resizeChildren(boolean defer, WINDOWPOS[] pwp) {
        if (pwp == null) {
            return true;
        }
        int hdwp = 0;
        if (defer && (hdwp = OS.BeginDeferWindowPos(pwp.length)) == 0) {
            return false;
        }
        int i = 0;
        while (i < pwp.length) {
            WINDOWPOS wp = pwp[i];
            if (wp != null) {
                if (defer) {
                    if ((hdwp = this.DeferWindowPos(hdwp, wp.hwnd, 0, wp.x, wp.y, wp.cx, wp.cy, wp.flags)) == 0) {
                        return false;
                    }
                } else {
                    this.SetWindowPos(wp.hwnd, 0, wp.x, wp.y, wp.cx, wp.cy, wp.flags);
                }
            }
            ++i;
        }
        if (defer) {
            return OS.EndDeferWindowPos(hdwp);
        }
        return true;
    }

    public boolean setFocus() {
        Control child;
        this.checkWidget();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            if (child.setRadioFocus()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            child = children[i];
            if (child.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean defer) {
        if (!defer) {
            if (--this.layoutCount == 0 && !this.isLayoutDeferred()) {
                this.updateLayout(true, true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    void setResizeChildren(boolean resize) {
        if (resize) {
            this.resizeChildren();
        } else {
            int count = this.getChildrenCount();
            if (count > 1 && this.lpwp == null) {
                this.lpwp = new WINDOWPOS[count];
            }
        }
    }

    boolean setTabGroupFocus() {
        Control child;
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
            if ((this.style & 0x1000000) != 0) {
                takeFocus = true;
            }
        }
        if (takeFocus && this.setTabItemFocus()) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            if (child.isTabItem() && child.setRadioFocus()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            child = children[i];
            if (child.isTabItem() && child.setTabItemFocus()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    String toolTipText(NMTTDISPINFO hdr) {
        if ((hdr.uFlags & 1) == 0) {
            return null;
        }
        int hwnd = hdr.idFrom;
        if (hwnd == 0) {
            return null;
        }
        Control control = this.display.getControl(hwnd);
        if (control == null) {
            return null;
        }
        return control.toolTipText;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child.translateMnemonic(event, control)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    boolean translateTraversal(MSG msg) {
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            return false;
        }
        return super.translateTraversal(msg);
    }

    void updateFont(Font oldFont, Font newFont) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            if (!control.isDisposed()) {
                control.updateFont(oldFont, newFont);
            }
            ++i;
        }
        super.updateFont(oldFont, newFont);
        this.layout(true);
    }

    void updateLayout(boolean resize, boolean all) {
        if (this.isLayoutDeferred()) {
            return;
        }
        if ((this.state & 0x20) != 0) {
            boolean changed = (this.state & 0x40) != 0;
            this.state &= 0xFFFFFF9F;
            if (resize) {
                this.setResizeChildren(false);
            }
            this.layout.layout(this, changed);
            if (resize) {
                this.setResizeChildren(true);
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].updateLayout(resize, all);
                ++i;
            }
        }
    }

    int widgetStyle() {
        return super.widgetStyle() | 0x2000000;
    }

    LRESULT WM_ERASEBKGND(int wParam, int lParam) {
        LRESULT result = super.WM_ERASEBKGND(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.state & 2) != 0 && (this.style & 0x40000) != 0) {
            return LRESULT.ZERO;
        }
        return result;
    }

    LRESULT WM_GETDLGCODE(int wParam, int lParam) {
        LRESULT result = super.WM_GETDLGCODE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.state & 2) != 0) {
            int flags = 0;
            if (this.hooksKeys()) {
                flags |= 7;
            }
            if ((this.style & 0x80000) != 0) {
                flags |= 0x100;
            }
            if (OS.GetWindow(this.handle, 5) != 0) {
                flags |= 0x100;
            }
            if (flags != 0) {
                return new LRESULT(flags);
            }
        }
        return result;
    }

    LRESULT WM_GETFONT(int wParam, int lParam) {
        LRESULT result = super.WM_GETFONT(wParam, lParam);
        if (result != null) {
            return result;
        }
        int code = this.callWindowProc(this.handle, 49, wParam, lParam);
        if (code != 0) {
            return new LRESULT(code);
        }
        if (this.font == 0) {
            this.font = this.defaultFont();
        }
        return new LRESULT(this.font);
    }

    LRESULT WM_LBUTTONDOWN(int wParam, int lParam) {
        LRESULT result = super.WM_LBUTTONDOWN(wParam, lParam);
        if ((this.state & 2) != 0 && (this.style & 0x80000) == 0 && this.hooksKeys() && OS.GetWindow(this.handle, 5) == 0) {
            this.setFocus();
        }
        return result;
    }

    LRESULT WM_NOTIFY(int wParam, int lParam) {
        if (!OS.IsWinCE) {
            NMHDR hdr = new NMHDR();
            OS.MoveMemory(hdr, lParam, 12);
            switch (hdr.code) {
                case -522: 
                case -521: {
                    int bits;
                    int hwndParent = hdr.hwndFrom;
                    while ((hwndParent = OS.GetParent(hwndParent)) != 0 && ((bits = OS.GetWindowLong(hwndParent, -20)) & 8) == 0) {
                    }
                    if (hwndParent != 0) break;
                    this.display.lockActiveWindow = true;
                    int flags = 19;
                    int hwndInsertAfter = hdr.code == -521 ? -1 : -2;
                    this.SetWindowPos(hdr.hwndFrom, hwndInsertAfter, 0, 0, 0, 0, flags);
                    this.display.lockActiveWindow = false;
                    break;
                }
                case -530: 
                case -520: {
                    Control control;
                    NMTTDISPINFO lpnmtdi;
                    if (hdr.code == -520) {
                        lpnmtdi = new NMTTDISPINFOA();
                        OS.MoveMemory(lpnmtdi, lParam, 108);
                    } else {
                        lpnmtdi = new NMTTDISPINFOW();
                        OS.MoveMemory((NMTTDISPINFOW)lpnmtdi, lParam, 188);
                    }
                    String string = this.toolTipText(lpnmtdi);
                    if (string == null) break;
                    Shell shell = this.getShell();
                    string = Display.withCrLf(string);
                    int length = string.length();
                    char[] chars = new char[length + 1];
                    string.getChars(0, length, chars, 0);
                    int hwnd = hdr.idFrom;
                    if (hwnd != 0 && (lpnmtdi.uFlags & 1) != 0 && (control = this.display.getControl(hwnd)) != null) {
                        lpnmtdi.uFlags = (control.getStyle() & 0x4000000) != 0 ? (lpnmtdi.uFlags |= 4) : (lpnmtdi.uFlags &= 0xFFFFFFFB);
                    }
                    if (hdr.code == -520) {
                        byte[] bytes = new byte[chars.length * 2];
                        OS.WideCharToMultiByte(0, 0, chars, chars.length, bytes, bytes.length, null, null);
                        shell.setToolTipText(lpnmtdi, bytes);
                        OS.MoveMemory(lParam, lpnmtdi, 108);
                    } else {
                        shell.setToolTipText(lpnmtdi, chars);
                        OS.MoveMemory(lParam, (NMTTDISPINFOW)lpnmtdi, 188);
                    }
                    return LRESULT.ZERO;
                }
            }
        }
        return super.WM_NOTIFY(wParam, lParam);
    }

    LRESULT WM_PAINT(int wParam, int lParam) {
        if ((this.state & 2) == 0) {
            return super.WM_PAINT(wParam, lParam);
        }
        int oldBits = 0;
        int newBits = 0;
        if (!OS.IsWinCE && (newBits = (oldBits = OS.GetWindowLong(this.handle, -16)) | 0x4000000 | 0x2000000) != oldBits) {
            OS.SetWindowLong(this.handle, -16, newBits);
        }
        PAINTSTRUCT ps = new PAINTSTRUCT();
        if (this.hooks(9)) {
            int[] lpRgnData = null;
            boolean isComplex = false;
            boolean exposeRegion = false;
            if ((this.style & 0x200000) != 0) {
                int rgn = OS.CreateRectRgn(0, 0, 0, 0);
                boolean bl = isComplex = OS.GetUpdateRgn(this.handle, rgn, false) == 3;
                if (isComplex) {
                    int nBytes = OS.GetRegionData(rgn, 0, null);
                    exposeRegion = OS.GetRegionData(rgn, nBytes, lpRgnData = new int[nBytes / 4]) != 0;
                }
                OS.DeleteObject(rgn);
            }
            GCData data = new GCData();
            data.ps = ps;
            data.hwnd = this.handle;
            GC gc = GC.win32_new(this, data);
            int width = ps.right - ps.left;
            int height = ps.bottom - ps.top;
            if (width != 0 && height != 0) {
                Event event = new Event();
                event.gc = gc;
                if (isComplex && exposeRegion) {
                    RECT rect = new RECT();
                    int count = lpRgnData[2];
                    int i = 0;
                    while (i < count) {
                        OS.SetRect(rect, lpRgnData[8 + (i << 2)], lpRgnData[8 + (i << 2) + 1], lpRgnData[8 + (i << 2) + 2], lpRgnData[8 + (i << 2) + 3]);
                        if ((this.style & 0x40000) == 0) {
                            this.drawBackground(gc.handle, rect);
                        }
                        event.x = rect.left;
                        event.y = rect.top;
                        event.width = rect.right - rect.left;
                        event.height = rect.bottom - rect.top;
                        event.count = count - 1 - i;
                        this.sendEvent(9, event);
                        if (!this.isDisposed()) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else {
                    if ((this.style & 0x40000) == 0) {
                        RECT rect = new RECT();
                        OS.SetRect(rect, ps.left, ps.top, ps.right, ps.bottom);
                        this.drawBackground(gc.handle, rect);
                    }
                    event.x = ps.left;
                    event.y = ps.top;
                    event.width = width;
                    event.height = height;
                    this.sendEvent(9, event);
                }
                event.gc = null;
            }
            gc.dispose();
        } else {
            int hDC = OS.BeginPaint(this.handle, ps);
            if ((this.style & 0x40000) == 0) {
                RECT rect = new RECT();
                OS.SetRect(rect, ps.left, ps.top, ps.right, ps.bottom);
                this.drawBackground(hDC, rect);
            }
            OS.EndPaint(this.handle, ps);
        }
        if (!OS.IsWinCE && newBits != oldBits && !this.isDisposed()) {
            OS.SetWindowLong(this.handle, -16, oldBits);
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(int wParam, int lParam) {
        LRESULT result = super.WM_PRINTCLIENT(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.state & 2) != 0) {
            this.forceResize();
            int nSavedDC = OS.SaveDC(wParam);
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            if ((this.style & 0x40000) == 0) {
                this.drawBackground(wParam, rect);
            }
            if (this.hooks(9) || this.filters(9)) {
                GCData data = new GCData();
                data.device = this.display;
                GC gc = GC.win32_new(wParam, data);
                Event event = new Event();
                event.gc = gc;
                event.x = rect.left;
                event.y = rect.top;
                event.width = rect.right - rect.left;
                event.height = rect.bottom - rect.top;
                this.sendEvent(9, event);
                event.gc = null;
                gc.dispose();
            }
            OS.RestoreDC(wParam, nSavedDC);
        }
        return result;
    }

    LRESULT WM_SETFONT(int wParam, int lParam) {
        this.font = wParam;
        return super.WM_SETFONT(this.font, lParam);
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        int threadId;
        int hwndChild;
        this.setResizeChildren(false);
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (this.isDisposed()) {
            return result;
        }
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false, false);
        }
        this.setResizeChildren(true);
        if (OS.IsWindowVisible(this.handle)) {
            if ((this.state & 2) != 0 && (this.style & 0x100000) == 0 && this.hooks(9)) {
                OS.InvalidateRect(this.handle, null, true);
            }
            if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.findThemeControl() != null) {
                hwndChild = OS.GetWindow(this.handle, 5);
                while (hwndChild != 0) {
                    int flags = 133;
                    OS.RedrawWindow(hwndChild, null, 0, flags);
                    hwndChild = OS.GetWindow(hwndChild, 2);
                }
            }
        }
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0 && (hwndChild = OS.GetWindow(this.handle, 5)) != 0 && (threadId = OS.GetWindowThreadProcessId(hwndChild, null)) != OS.GetCurrentThreadId()) {
            if (this.display.msgHook == 0 && !OS.IsWinCE) {
                this.display.getMsgCallback = new Callback(this.display, "getMsgProc", 3);
                this.display.getMsgProc = this.display.getMsgCallback.getAddress();
                if (this.display.getMsgProc == 0) {
                    this.error(3);
                }
                this.display.msgHook = OS.SetWindowsHookEx(3, this.display.getMsgProc, OS.GetLibraryHandle(), threadId);
            }
            OS.PostThreadMessage(threadId, 32772, hwndChild, lParam);
        }
        return result;
    }

    LRESULT WM_SYSCOLORCHANGE(int wParam, int lParam) {
        int hwndChild = OS.GetWindow(this.handle, 5);
        while (hwndChild != 0) {
            OS.SendMessage(hwndChild, 21, 0, 0);
            hwndChild = OS.GetWindow(hwndChild, 2);
        }
        return null;
    }

    LRESULT WM_SYSCOMMAND(int wParam, int lParam) {
        LRESULT result = super.WM_SYSCOMMAND(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((wParam & 0xF000) == 0) {
            return result;
        }
        if (!OS.IsWinCE) {
            int cmd = wParam & 0xFFF0;
            switch (cmd) {
                case 61552: 
                case 61568: {
                    boolean showHBar = this.horizontalBar != null && this.horizontalBar.getVisible();
                    boolean showVBar = this.verticalBar != null && this.verticalBar.getVisible();
                    int code = this.callWindowProc(this.handle, 274, wParam, lParam);
                    if (showHBar != (this.horizontalBar != null && this.horizontalBar.getVisible()) || showVBar != (this.verticalBar != null && this.verticalBar.getVisible())) {
                        int flags = 1281;
                        OS.RedrawWindow(this.handle, null, 0, flags);
                    }
                    if (code == 0) {
                        return LRESULT.ZERO;
                    }
                    return new LRESULT(code);
                }
            }
        }
        return result;
    }
}

