/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.internal.forms.widgets.FormTextModel;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.internal.forms.widgets.HyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.Paragraph;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.TextSegment;

public final class FormText
extends Canvas {
    public static final String URL_HANDLER_ID = "urlHandler";
    public int marginWidth = 0;
    public int marginHeight = 1;
    private boolean hasFocus;
    private boolean paragraphsSeparated = true;
    private FormTextModel model;
    private Vector listeners;
    private Hashtable resourceTable = new Hashtable();
    private HyperlinkSegment entered;
    private boolean mouseDown = false;
    private Action openAction;
    private Action copyShortcutAction;
    private boolean loading = true;
    private String loadingText = "Loading...";

    public FormText(Composite parent, int style) {
        super(parent, 0x40040 | style);
        this.setLayout(new FormTextLayout());
        this.model = new FormTextModel();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FormText.this.model.dispose();
                Font boldFont = (Font)FormText.this.resourceTable.get("f.____bold");
                if (boldFont != null) {
                    boldFont.dispose();
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                FormText.this.paint(e);
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    FormText.this.activateSelectedLink();
                    return;
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        e.doit = false;
                        return;
                    }
                }
                if (!FormText.this.model.hasFocusSegments()) {
                    e.doit = true;
                    return;
                }
                if (e.detail == 16) {
                    e.doit = FormText.this.advance(true);
                } else if (e.detail == 8) {
                    e.doit = FormText.this.advance(false);
                } else if (e.detail != 4) {
                    e.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!FormText.this.hasFocus) {
                    FormText.this.hasFocus = true;
                    FormText.this.handleFocusChange();
                }
            }

            public void focusLost(FocusEvent e) {
                if (FormText.this.hasFocus) {
                    FormText.this.hasFocus = false;
                    FormText.this.handleFocusChange();
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FormText.this.handleMouseClick(e, true);
            }

            public void mouseUp(MouseEvent e) {
                FormText.this.handleMouseClick(e, false);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                FormText.this.handleMouseMove(e);
            }

            public void mouseExit(MouseEvent e) {
                if (FormText.this.entered != null) {
                    FormText.this.exitLink(FormText.this.entered, e.stateMask);
                    FormText.this.paintLinkHover(FormText.this.entered, false);
                    FormText.this.entered = null;
                    FormText.this.setCursor(null);
                }
            }

            public void mouseHover(MouseEvent e) {
                FormText.this.handleMouseHover(e);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                FormText.this.handleMouseMove(e);
            }
        });
        this.initAccessible();
        this.makeActions();
        this.ensureBoldFontPresent(this.getFont());
    }

    public boolean getFocus() {
        return this.hasFocus;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public String getLoadingText() {
        return this.loadingText;
    }

    public void setLoadingText(String loadingText) {
        this.loadingText = loadingText;
    }

    public void setParagraphsSeparated(boolean value) {
        this.paragraphsSeparated = value;
    }

    public boolean getParagraphsSeparated() {
        return this.paragraphsSeparated;
    }

    public void setImage(String key, Image image) {
        this.resourceTable.put("i." + key, image);
    }

    public void setColor(String key, Color color) {
        this.resourceTable.put("c." + key, color);
    }

    public void setFont(String key, Font font) {
        this.resourceTable.put("f." + key, font);
    }

    public void setFont(Font font) {
        super.setFont(font);
        Font boldFont = (Font)this.resourceTable.get("f.____bold");
        if (boldFont != null) {
            boldFont.dispose();
            this.resourceTable.remove("f.____bold");
        }
        this.ensureBoldFontPresent(this.getFont());
    }

    public void setText(String text, boolean parseTags, boolean expandURLs) {
        if (parseTags) {
            this.model.parseTaggedText(text, expandURLs);
        } else {
            this.model.parseRegularText(text, expandURLs);
        }
        this.loading = false;
        this.layout();
        this.redraw();
    }

    public void setContents(InputStream is, boolean expandURLs) {
        this.model.parseInputStream(is, expandURLs);
        this.loading = false;
        this.layout();
        this.redraw();
    }

    public void setWhitespaceNormalized(boolean value) {
        this.model.setWhitespaceNormalized(value);
    }

    public boolean isWhitespaceNormalized() {
        return this.model.isWhitespaceNormalized();
    }

    public boolean setFocus() {
        return super.setFocus();
    }

    public HyperlinkSettings getHyperlinkSettings() {
        return this.model.getHyperlinkSettings();
    }

    public void setHyperlinkSettings(HyperlinkSettings settings) {
        this.model.setHyperlinkSettings(settings);
    }

    public void addHyperlinkListener(IHyperlinkListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeHyperlinkListener(IHyperlinkListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public Object getSelectedLinkHref() {
        HyperlinkSegment link = this.model.getSelectedLink();
        if (link != null) {
            return link.getHref();
        }
        return null;
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        HyperlinkSegment link = this.model.getSelectedLink();
        if (link != null) {
            this.contributeLinkActions(manager, link);
        }
    }

    private void makeActions() {
    }

    private String getAcessibleText() {
        return this.model.getAccessibleText();
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = FormText.this.getAcessibleText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = FormText.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = FormText.this.toControl(new Point(e.x, e.y));
                e.childID = FormText.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = FormText.this.getBounds();
                Point pt = FormText.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 42;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
    }

    private void handleMouseClick(MouseEvent e, boolean down) {
        if (down) {
            HyperlinkSegment segmentUnder = this.model.findHyperlinkAt(e.x, e.y);
            if (segmentUnder != null) {
                HyperlinkSegment oldLink = this.model.getSelectedLink();
                this.model.selectLink(segmentUnder);
                this.enterLink(segmentUnder, e.stateMask);
                this.paintFocusTransfer(oldLink, segmentUnder);
            }
            this.mouseDown = true;
        } else {
            HyperlinkSegment segmentUnder;
            if (e.button == 1 && (segmentUnder = this.model.findHyperlinkAt(e.x, e.y)) != null) {
                this.activateLink(segmentUnder, e.stateMask);
            }
            this.mouseDown = false;
        }
    }

    private void handleMouseHover(MouseEvent e) {
    }

    private void handleMouseMove(MouseEvent e) {
        if (this.mouseDown) {
            this.handleDrag(e);
            return;
        }
        TextSegment segmentUnder = this.model.findSegmentAt(e.x, e.y);
        if (segmentUnder == null) {
            if (this.entered != null) {
                this.exitLink(this.entered, e.stateMask);
                this.paintLinkHover(this.entered, false);
                this.entered = null;
            }
            this.setCursor(null);
        } else if (segmentUnder instanceof HyperlinkSegment) {
            HyperlinkSegment linkUnder = (HyperlinkSegment)segmentUnder;
            if (this.entered == null) {
                this.entered = linkUnder;
                this.enterLink(linkUnder, e.stateMask);
                this.paintLinkHover(this.entered, true);
                this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
            }
        } else {
            if (this.entered != null) {
                this.exitLink(this.entered, e.stateMask);
                this.paintLinkHover(this.entered, false);
                this.entered = null;
            }
            this.setCursor(this.model.getHyperlinkSettings().getTextCursor());
        }
    }

    private boolean advance(boolean next) {
        HyperlinkSegment current = this.model.getSelectedLink();
        if (current != null) {
            this.exitLink(current, 0);
        }
        boolean valid = this.model.traverseLinks(next);
        HyperlinkSegment newLink = this.model.getSelectedLink();
        if (valid) {
            this.enterLink(newLink, 0);
        }
        this.paintFocusTransfer(current, newLink);
        if (newLink != null) {
            this.ensureVisible(newLink);
        }
        return !valid;
    }

    private void handleFocusChange() {
        if (this.hasFocus) {
            this.model.traverseLinks(true);
            this.enterLink(this.model.getSelectedLink(), 0);
            this.paintFocusTransfer(null, this.model.getSelectedLink());
            this.ensureVisible(this.model.getSelectedLink());
        } else {
            this.paintFocusTransfer(this.model.getSelectedLink(), null);
            this.model.selectLink(null);
        }
    }

    private void enterLink(HyperlinkSegment link, int stateMask) {
        if (link == null || this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        HyperlinkEvent he = new HyperlinkEvent((Widget)this, link.getHref(), link.getText(), stateMask);
        int i = 0;
        while (i < size) {
            IHyperlinkListener listener = (IHyperlinkListener)this.listeners.get(i);
            listener.linkEntered(he);
            ++i;
        }
    }

    private void exitLink(HyperlinkSegment link, int stateMask) {
        if (link == null || this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        HyperlinkEvent he = new HyperlinkEvent((Widget)this, link.getHref(), link.getText(), stateMask);
        int i = 0;
        while (i < size) {
            IHyperlinkListener listener = (IHyperlinkListener)this.listeners.get(i);
            listener.linkExited(he);
            ++i;
        }
    }

    private void paintLinkHover(HyperlinkSegment link, boolean hover) {
        GC gc = new GC((Drawable)this);
        HyperlinkSettings settings = this.getHyperlinkSettings();
        gc.setForeground(hover ? settings.getActiveForeground() : settings.getForeground());
        gc.setBackground(this.getBackground());
        gc.setFont(this.getFont());
        boolean selected = link == this.model.getSelectedLink();
        link.repaint(gc, hover);
        if (selected) {
            link.paintFocus(gc, this.getBackground(), this.getForeground(), false);
            link.paintFocus(gc, this.getBackground(), this.getForeground(), true);
        }
        gc.dispose();
    }

    private void activateSelectedLink() {
        HyperlinkSegment link = this.model.getSelectedLink();
        if (link != null) {
            this.activateLink(link, 0);
        }
    }

    private void activateLink(HyperlinkSegment link, int stateMask) {
        this.setCursor(this.model.getHyperlinkSettings().getBusyCursor());
        if (this.listeners != null) {
            int size = this.listeners.size();
            HyperlinkEvent e = new HyperlinkEvent((Widget)this, link.getHref(), link.getText(), stateMask);
            int i = 0;
            while (i < size) {
                IHyperlinkListener listener = (IHyperlinkListener)this.listeners.get(i);
                listener.linkActivated(e);
                ++i;
            }
        }
        if (!this.isDisposed()) {
            this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
        }
    }

    private void ensureBoldFontPresent(Font regularFont) {
        Font boldFont = (Font)this.resourceTable.get("f.____bold");
        if (boldFont != null) {
            return;
        }
        FontData[] fontDatas = regularFont.getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setStyle(fontDatas[i].getStyle() | 1);
            ++i;
        }
        boldFont = new Font((Device)this.getDisplay(), fontDatas);
        this.resourceTable.put("f.____bold", boldFont);
    }

    private void paint(PaintEvent e) {
        Rectangle carea = this.getClientArea();
        GC gc = e.gc;
        gc.setFont(this.getFont());
        this.ensureBoldFontPresent(this.getFont());
        gc.setForeground(this.getForeground());
        gc.setBackground(this.getBackground());
        Locator loc = new Locator();
        loc.marginWidth = this.marginWidth;
        loc.marginHeight = this.marginHeight;
        loc.x = this.marginWidth;
        loc.y = this.marginHeight;
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        Image textBuffer = new Image((Device)this.getDisplay(), carea.width, carea.height);
        textBuffer.setBackground(this.getBackground());
        GC textGC = new GC((Drawable)textBuffer, gc.getStyle());
        textGC.setForeground(this.getForeground());
        textGC.setBackground(this.getBackground());
        textGC.setFont(this.getFont());
        textGC.fillRectangle(0, 0, carea.width, carea.height);
        if (this.loading) {
            int textWidth = gc.textExtent((String)this.loadingText).x;
            textGC.drawText(this.loadingText, carea.width / 2 - textWidth / 2, this.getClientArea().height / 2 - lineHeight / 2);
        } else {
            Paragraph[] paragraphs = this.model.getParagraphs();
            HyperlinkSegment selectedLink = this.model.getSelectedLink();
            int i = 0;
            while (i < paragraphs.length) {
                Paragraph p = paragraphs[i];
                if (i > 0 && this.paragraphsSeparated && p.getAddVerticalSpace()) {
                    loc.y += this.getParagraphSpacing(lineHeight);
                }
                loc.indent = p.getIndent();
                loc.resetCaret();
                loc.rowHeight = 0;
                p.paint(textGC, carea.width, loc, lineHeight, this.resourceTable, selectedLink);
                ++i;
            }
        }
        gc.drawImage(textBuffer, 0, 0);
        textGC.dispose();
        textBuffer.dispose();
    }

    private int getParagraphSpacing(int lineHeight) {
        return lineHeight / 2;
    }

    private void paintFocusTransfer(HyperlinkSegment oldLink, HyperlinkSegment newLink) {
        GC gc = new GC((Drawable)this);
        Color bg = this.getBackground();
        Color fg = this.getForeground();
        gc.setFont(this.getFont());
        if (oldLink != null) {
            gc.setBackground(bg);
            gc.setForeground(fg);
            oldLink.paintFocus(gc, bg, fg, false);
        }
        if (newLink != null) {
            gc.setBackground(bg);
            gc.setForeground(fg);
            newLink.paintFocus(gc, bg, fg, true);
        }
        gc.dispose();
    }

    private void contributeLinkActions(IMenuManager manager, HyperlinkSegment link) {
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.copyShortcutAction);
        manager.add((IContributionItem)new Separator());
    }

    private void ensureVisible(HyperlinkSegment segment) {
        if (segment == null) {
            return;
        }
        Rectangle bounds = segment.getBounds();
        ScrolledComposite scomp = FormUtil.getScrolledComposite((Control)this);
        if (scomp == null) {
            return;
        }
        Point origin = FormUtil.getControlLocation(scomp, (Control)this);
        origin.x += bounds.x;
        origin.y += bounds.y;
        FormUtil.ensureVisible(scomp, origin, new Point(bounds.width, bounds.height));
    }

    private void handleDrag(MouseEvent e) {
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        FormTextLayout layout = (FormTextLayout)this.getLayout();
        Point size = wHint == -1 || hHint == -1 ? layout.computeSize((Composite)this, wHint, hHint, changed) : new Point(wHint, hHint);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    private class FormTextLayout
    extends Layout
    implements ILayoutExtension {
        public int computeMaximumWidth(Composite parent, boolean changed) {
            return this.computeSize((Composite)parent, (int)-1, (int)-1, (boolean)changed).x;
        }

        public int computeMinimumWidth(Composite parent, boolean changed) {
            return this.computeSize((Composite)parent, (int)5, (int)-1, (boolean)true).x;
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean changed) {
            int innerWidth = wHint;
            if (FormText.this.isLoading()) {
                return this.computeLoading();
            }
            if (innerWidth != -1) {
                innerWidth -= FormText.this.marginWidth * 2;
            }
            Point textSize = this.computeTextSize(innerWidth);
            int textWidth = textSize.x + 2 * FormText.this.marginWidth;
            int textHeight = textSize.y + 2 * FormText.this.marginHeight;
            Point result = new Point(textWidth, textHeight);
            return result;
        }

        private Point computeLoading() {
            GC gc = new GC((Drawable)FormText.this);
            gc.setFont(FormText.this.getFont());
            String loadingText = FormText.this.getLoadingText();
            Point size = gc.textExtent(loadingText);
            gc.dispose();
            size.x += 2 * FormText.this.marginWidth;
            size.y += 2 * FormText.this.marginHeight;
            return size;
        }

        private Point computeTextSize(int wHint) {
            Paragraph[] paragraphs = FormText.this.model.getParagraphs();
            GC gc = new GC((Drawable)FormText.this);
            gc.setFont(FormText.this.getFont());
            Locator loc = new Locator();
            int width = wHint != -1 ? wHint : 0;
            FontMetrics fm = gc.getFontMetrics();
            int lineHeight = fm.getHeight();
            int i = 0;
            while (i < paragraphs.length) {
                Paragraph p = paragraphs[i];
                if (i > 0 && FormText.this.getParagraphsSeparated() && p.getAddVerticalSpace()) {
                    loc.y += FormText.this.getParagraphSpacing(lineHeight);
                }
                loc.rowHeight = 0;
                loc.indent = p.getIndent();
                loc.x = p.getIndent();
                ParagraphSegment[] segments = p.getSegments();
                if (segments.length > 0) {
                    int j = 0;
                    while (j < segments.length) {
                        ParagraphSegment segment = segments[j];
                        segment.advanceLocator(gc, wHint, loc, FormText.this.resourceTable, false);
                        width = Math.max(width, loc.width);
                        ++j;
                    }
                    loc.y += loc.rowHeight;
                } else {
                    loc.y += lineHeight;
                }
                ++i;
            }
            gc.dispose();
            return new Point(width, loc.y);
        }

        protected void layout(Composite composite, boolean flushCache) {
        }
    }
}

