/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.forms.IFormToolkitProvider;
import org.eclipse.ui.internal.forms.IWizardEditorInput;
import org.eclipse.ui.internal.forms.widgets.SWTUtil;
import org.eclipse.ui.internal.forms.widgets.WrappedPageBook;
import org.eclipse.ui.part.EditorPart;

public class WizardFormEditor
extends EditorPart
implements IWizardContainer2,
IFormToolkitProvider {
    public static final String WIZ_IMG_ERROR = "dialog_title_error_image";
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private IWizard wizard;
    private ArrayList createdWizards = new ArrayList();
    private ArrayList nestedWizards = new ArrayList();
    private Cursor arrowCursor;
    private IWizardPage currentPage = null;
    private long activeRunningOperations = 0L;
    private String pageDescription;
    private MessageDialog windowClosingDialog;
    private Button backButton;
    private Button nextButton;
    private Button finishButton;
    private Button cancelButton;
    private Button helpButton;
    private Hashtable buttons;
    private SelectionAdapter cancelListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            WizardFormEditor.this.cancelPressed();
        }
    };
    private boolean isMovingToPreviousPage = false;
    private ScrolledForm form;
    private Label descriptionLabel;
    private Label separator;
    private WrappedPageBook pageContainer;
    private Composite buttonContainer;
    private static final String FOCUS_CONTROL = "focusControl";
    private int returnCode = 0;
    private FormToolkit toolkit;
    static /* synthetic */ Class class$0;

    private Object aboutToStart(boolean enableCancelButton) {
        Map savedState = null;
        if (this.getShell() != null) {
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            this.cancelButton.removeSelectionListener((SelectionListener)this.cancelListener);
            Display d = this.getShell().getDisplay();
            this.arrowCursor = new Cursor((Device)d, 0);
            this.cancelButton.setCursor(this.arrowCursor);
            savedState = this.saveUIState(enableCancelButton);
            if (focusControl != null) {
                savedState.put(FOCUS_CONTROL, focusControl);
            }
        }
        return savedState;
    }

    private void stopped(Object savedState) {
        if (this.getShell() != null) {
            Map state = (Map)savedState;
            this.restoreUIState(state);
            this.cancelButton.addSelectionListener((SelectionListener)this.cancelListener);
            this.setDisplayCursor(null);
            this.cancelButton.setCursor(null);
            this.arrowCursor.dispose();
            this.arrowCursor = null;
            Control focusControl = (Control)state.get(FOCUS_CONTROL);
            if (focusControl != null) {
                focusControl.setFocus();
            }
        }
    }

    protected void backPressed() {
        IWizardPage page = this.currentPage.getPreviousPage();
        if (page == null) {
            return;
        }
        this.isMovingToPreviousPage = true;
        this.showPage(page);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 17: {
                this.helpPressed();
                break;
            }
            case 14: {
                this.backPressed();
                break;
            }
            case 15: {
                this.nextPressed();
                break;
            }
            case 16: {
                this.finishPressed();
            }
        }
    }

    protected void cancelPressed() {
        if (this.activeRunningOperations <= 0L) {
            this.close();
        } else {
            this.cancelButton.setEnabled(false);
        }
    }

    public boolean close() {
        if (this.okToClose()) {
            this.hardClose();
            return true;
        }
        return false;
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.wizard.isHelpAvailable()) {
            this.helpButton = this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
        }
        if (this.wizard.needsPreviousAndNextButtons()) {
            this.createPreviousAndNextButtons(parent);
        }
        this.finishButton = this.createButton(parent, 16, IDialogConstants.FINISH_LABEL, true);
        this.cancelButton = this.createCancelButton(parent);
    }

    private Button createCancelButton(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = this.toolkit.createButton(parent, IDialogConstants.CANCEL_LABEL, 8);
        this.setButtonLayoutData(button);
        button.setFont(parent.getFont());
        button.setData((Object)new Integer(1));
        button.addSelectionListener((SelectionListener)this.cancelListener);
        return button;
    }

    protected void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        button.setLayoutData((Object)data);
        SWTUtil.setButtonDimensionHint(button);
    }

    protected Button getButton(int id) {
        if (this.buttons != null) {
            return (Button)this.buttons.get(new Integer(id));
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.wizard.addPages();
        this.createForm(parent);
        this.createPageControls();
        this.showStartingPage();
    }

    private void createForm(Composite parent) {
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.getBody().setLayout((Layout)new WizardFormLayout());
        this.descriptionLabel = this.toolkit.createLabel(this.form.getBody(), "", 64);
        this.pageContainer = new WrappedPageBook(this.form.getBody(), 0);
        this.separator = this.toolkit.createLabel(this.form.getBody(), null, 258);
        this.buttonContainer = this.toolkit.createComposite(this.form.getBody());
        this.buttonContainer.setLayout((Layout)new GridLayout());
        this.createButtonsForButtonBar(this.buttonContainer);
    }

    private void createPageControls() {
        this.wizard.createPageControls((Composite)this.pageContainer);
        if (!this.isFormWizard()) {
            this.adaptPages(this.wizard);
        }
        IWizardPage[] pages = this.wizard.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (page.getControl() != null) {
                page.getControl().setVisible(false);
            }
            ++i;
        }
    }

    private Composite createPreviousAndNextButtons(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(68);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.backButton = this.createButton(composite, 14, IDialogConstants.BACK_LABEL, false);
        this.nextButton = this.createButton(composite, 15, IDialogConstants.NEXT_LABEL, false);
        return composite;
    }

    private MessageDialog createWizardClosingDialog() {
        MessageDialog result = new MessageDialog(this.getShell(), JFaceResources.getString((String)"WizardClosingDialog.title"), null, JFaceResources.getString((String)"WizardClosingDialog.message"), 3, new String[]{IDialogConstants.OK_LABEL}, 0);
        return result;
    }

    protected void finishPressed() {
        if (this.wizard.performFinish()) {
            int i = 0;
            while (i < this.nestedWizards.size() - 1) {
                ((IWizard)this.nestedWizards.get(i)).performFinish();
                ++i;
            }
            this.setReturnCode(0);
            this.hardClose();
        }
    }

    public IWizardPage getCurrentPage() {
        return this.currentPage;
    }

    protected IWizard getWizard() {
        return this.wizard;
    }

    private void hardClose() {
        int i = 0;
        while (i < this.createdWizards.size()) {
            IWizard createdWizard = (IWizard)this.createdWizards.get(i);
            createdWizard.dispose();
            createdWizard.setContainer(null);
            ++i;
        }
        this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
    }

    protected void helpPressed() {
        if (this.currentPage != null) {
            this.currentPage.performHelp();
        }
    }

    protected void nextPressed() {
        IWizardPage page = this.currentPage.getNextPage();
        if (page == null) {
            return;
        }
        this.showPage(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean okToClose() {
        if (this.activeRunningOperations > 0L) {
            WizardFormEditor wizardFormEditor = this;
            synchronized (wizardFormEditor) {
                this.windowClosingDialog = this.createWizardClosingDialog();
            }
            this.windowClosingDialog.open();
            wizardFormEditor = this;
            synchronized (wizardFormEditor) {
                this.windowClosingDialog = null;
            }
            return false;
        }
        return this.wizard.performCancel();
    }

    private void restoreEnableState(Control w, Map h, String key) {
        Boolean b;
        if (w != null && (b = (Boolean)h.get(key)) != null) {
            w.setEnabled(b.booleanValue());
        }
    }

    private void restoreUIState(Map state) {
        this.restoreEnableState((Control)this.backButton, state, "back");
        this.restoreEnableState((Control)this.nextButton, state, "next");
        this.restoreEnableState((Control)this.finishButton, state, "finish");
        this.restoreEnableState((Control)this.cancelButton, state, "cancel");
        this.restoreEnableState((Control)this.helpButton, state, "help");
        Object pageValue = state.get("page");
        if (pageValue != null) {
            ((ControlEnableState)pageValue).restore();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        Object state = null;
        if (this.activeRunningOperations == 0L) {
            state = this.aboutToStart(fork && cancelable);
        }
        ++this.activeRunningOperations;
        try {
            this.getSite().getWorkbenchWindow().run(fork, cancelable, runnable);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            --this.activeRunningOperations;
            if (state == null) throw throwable;
            this.stopped(state);
            throw throwable;
        }
        {
            Object var5_7 = null;
            --this.activeRunningOperations;
            if (state == null) return;
            this.stopped(state);
            return;
        }
    }

    private void saveEnableStateAndSet(Control w, Map h, String key, boolean enabled) {
        if (w != null) {
            h.put(key, new Boolean(w.getEnabled()));
            w.setEnabled(enabled);
        }
    }

    private Map saveUIState(boolean keepCancelEnabled) {
        HashMap<String, ControlEnableState> savedState = new HashMap<String, ControlEnableState>(10);
        this.saveEnableStateAndSet((Control)this.backButton, savedState, "back", false);
        this.saveEnableStateAndSet((Control)this.nextButton, savedState, "next", false);
        this.saveEnableStateAndSet((Control)this.finishButton, savedState, "finish", false);
        this.saveEnableStateAndSet((Control)this.cancelButton, savedState, "cancel", keepCancelEnabled);
        this.saveEnableStateAndSet((Control)this.helpButton, savedState, "help", false);
        if (this.currentPage != null) {
            savedState.put("page", ControlEnableState.disable((Control)this.currentPage.getControl()));
        }
        return savedState;
    }

    private void setDisplayCursor(Cursor c) {
        Shell[] shells = this.getShell().getDisplay().getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(c);
            ++i;
        }
    }

    protected void setWizard(IWizard newWizard) {
        this.wizard = newWizard;
        this.wizard.setContainer((IWizardContainer)this);
        if (!this.createdWizards.contains(this.wizard)) {
            this.createdWizards.add(this.wizard);
            this.nestedWizards.add(this.wizard);
            if (this.form != null) {
                this.createPageControls();
                this.form.reflow(true);
            }
        } else {
            int size = this.nestedWizards.size();
            if (size >= 2 && this.nestedWizards.get(size - 2) == this.wizard) {
                this.nestedWizards.remove(size - 1);
            } else {
                this.nestedWizards.add(this.wizard);
            }
        }
    }

    public void showPage(IWizardPage page) {
        if (page == null || page == this.currentPage) {
            return;
        }
        if (!this.isMovingToPreviousPage) {
            page.setPreviousPage(this.currentPage);
        } else {
            this.isMovingToPreviousPage = false;
        }
        if (this.form == null) {
            this.updateForPage(page);
        } else {
            final IWizardPage finalPage = page;
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    WizardFormEditor.this.updateForPage(finalPage);
                }
            });
        }
    }

    private void updateForPage(IWizardPage page) {
        if (this.wizard != page.getWizard()) {
            this.setWizard(page.getWizard());
        }
        if (page.getControl() == null) {
            this.createPageControl(page);
            Assert.isNotNull((Object)page.getControl());
        }
        IWizardPage oldPage = this.currentPage;
        this.currentPage = page;
        this.currentPage.setVisible(true);
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.putPageOnTop(this.currentPage);
        this.update();
    }

    private void createPageControl(IWizardPage page) {
        page.createControl((Composite)this.pageContainer);
        if (!this.isFormWizard()) {
            this.adaptPage(page);
        }
    }

    private void adaptPages(IWizard wizard) {
        IWizardPage[] pages = wizard.getPages();
        int i = 0;
        while (i < pages.length) {
            this.adaptPage(pages[i]);
            ++i;
        }
    }

    private void adaptPage(IWizardPage page) {
        Control control = page.getControl();
        if (control == null || !(control instanceof Composite)) {
            return;
        }
        this.adaptControl(control);
    }

    private void adaptControl(Control c) {
        if (c instanceof Composite) {
            Composite parent = (Composite)c;
            Control[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                this.adaptControl(child);
                ++i;
            }
            this.toolkit.adapt((Composite)c);
        } else {
            this.toolkit.adapt(c, true, true);
        }
    }

    private void putPageOnTop(IWizardPage page) {
        this.pageContainer.showPage(page.getControl());
    }

    private void showStartingPage() {
        this.currentPage = this.wizard.getStartingPage();
        if (this.currentPage == null) {
            return;
        }
        if (this.currentPage.getControl() == null) {
            this.createPageControl(this.currentPage);
            Assert.isNotNull((Object)this.currentPage.getControl());
        }
        this.currentPage.setVisible(true);
        this.putPageOnTop(this.currentPage);
        this.update();
    }

    protected void update() {
        this.updateWindowTitle();
        this.updateTitleBar();
        this.updateButtons();
        this.form.reflow(true);
    }

    public void updateButtons() {
        boolean canFlipToNextPage = false;
        boolean canFinish = this.wizard.canFinish();
        if (this.backButton != null) {
            this.backButton.setEnabled(this.currentPage.getPreviousPage() != null);
        }
        if (this.nextButton != null) {
            canFlipToNextPage = this.currentPage.canFlipToNextPage();
            this.nextButton.setEnabled(canFlipToNextPage);
        }
        this.finishButton.setEnabled(canFinish);
        if (canFlipToNextPage && !canFinish) {
            this.getShell().setDefaultButton(this.nextButton);
        } else {
            this.getShell().setDefaultButton(this.finishButton);
        }
    }

    private void updateDescriptionMessage() {
        this.pageDescription = this.currentPage.getDescription();
        String text = this.pageDescription != null ? this.pageDescription : "";
        this.descriptionLabel.setText(text);
    }

    public void updateMessage() {
        if (this.currentPage == null) {
            return;
        }
        String pageMessage = this.currentPage.getMessage();
        int pageMessageType = 0;
        pageMessageType = pageMessage != null && this.currentPage instanceof IMessageProvider ? ((IMessageProvider)this.currentPage).getMessageType() : 0;
        if (pageMessage == null) {
            this.setMessage(this.pageDescription);
        } else {
            this.setMessage(pageMessage, pageMessageType);
        }
        this.setErrorMessage(this.currentPage.getErrorMessage());
    }

    private void setMessage(String newMessage) {
        this.setMessage(newMessage, 0);
    }

    private void setMessage(String newMessage, int newType) {
        Image newImage = null;
        if (newMessage != null) {
            switch (newType) {
                case 0: {
                    break;
                }
                case 1: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    newImage = JFaceResources.getImage((String)"dialog_message_error_image");
                }
            }
        }
        this.showMessage(newMessage, newImage);
    }

    private void setErrorMessage(String errorMessage) {
        this.setMessage(errorMessage, 3);
    }

    private void showMessage(String newMessage, Image newImage) {
        IStatusLineManager mng = this.getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(newImage, newMessage);
    }

    public void updateSize() {
    }

    public void updateTitleBar() {
        String s = null;
        if (this.currentPage != null) {
            s = this.currentPage.getTitle();
        }
        if (s == null) {
            s = "";
        }
        this.form.setText(s);
        this.updateDescriptionMessage();
        this.updateMessage();
    }

    public void updateWindowTitle() {
        if (this.getShell() == null) {
            return;
        }
        String title = this.wizard.getWindowTitle();
        if (title == null) {
            title = "";
        }
        this.setPartName(title);
        this.firePropertyChange(1);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = this.toolkit.createButton(parent, label, 8);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardFormEditor.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        if (this.buttons == null) {
            this.buttons = new Hashtable();
        }
        this.buttons.put(new Integer(id), button);
        return button;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IWizard wizard;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.wizard.IWizard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((wizard = (IWizard)input.getAdapter((Class)clazz)) != null) {
            this.setWizard(wizard);
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public Shell getShell() {
        IEditorSite site = this.getEditorSite();
        if (site == null) {
            return null;
        }
        return site.getShell();
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    public boolean isFormWizard() {
        IWizardEditorInput input = (IWizardEditorInput)this.getEditorInput();
        return input.isFormWizard();
    }

    private class WizardFormLayout
    extends Layout
    implements ILayoutExtension {
        private int wMargin = 5;
        private int hMargin = 5;
        private int spacing = 5;

        WizardFormLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int innerWHint = wHint;
            if (wHint != -1) {
                innerWHint -= this.wMargin + this.wMargin;
            }
            int dWHint = innerWHint;
            Point dsize = WizardFormEditor.this.descriptionLabel.computeSize(dWHint, -1, flushCache);
            Point psize = WizardFormEditor.this.pageContainer.computeSize(innerWHint, hHint, flushCache);
            Point bsize = WizardFormEditor.this.buttonContainer.computeSize(innerWHint, hHint, flushCache);
            Point size = new Point(0, 0);
            size.x = dsize.x;
            size.x = Math.max(size.x, psize.x);
            size.x = Math.max(size.x, bsize.x);
            size.x += this.wMargin + this.wMargin;
            int dheight = dsize.y;
            Point ssize = WizardFormEditor.this.separator.computeSize(-1, -1, flushCache);
            size.y = dheight + this.spacing + psize.y + this.spacing + ssize.y + bsize.y;
            size.y += this.hMargin + this.hMargin;
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            int innerWidth;
            Rectangle clientArea = composite.getClientArea();
            int x = this.wMargin;
            int y = this.hMargin;
            int dWidth = innerWidth = clientArea.width - this.wMargin - this.wMargin;
            Point dsize = WizardFormEditor.this.descriptionLabel.computeSize(dWidth, -1, flushCache);
            WizardFormEditor.this.descriptionLabel.setBounds(x, y, dsize.x, dsize.y);
            Point psize = WizardFormEditor.this.pageContainer.computeSize(innerWidth, -1, flushCache);
            WizardFormEditor.this.pageContainer.setBounds(x, y += dsize.y + this.spacing, psize.x, psize.y);
            Point ssize = WizardFormEditor.this.separator.computeSize(-1, -1, flushCache);
            WizardFormEditor.this.separator.setBounds(x, y += psize.y + this.spacing, innerWidth, ssize.y);
            WizardFormEditor.this.buttonContainer.setBounds(x, y += ssize.y, innerWidth, clientArea.height - this.hMargin - this.hMargin - y);
        }

        public int computeMaximumWidth(Composite parent, boolean changed) {
            int dwidth = ((WizardFormEditor)WizardFormEditor.this).descriptionLabel.computeSize((int)-1, (int)-1).x;
            int pwidth = ((ILayoutExtension)WizardFormEditor.this.pageContainer.getLayout()).computeMaximumWidth(WizardFormEditor.this.pageContainer, changed);
            int width = Math.max(dwidth, pwidth);
            int bwidth = ((WizardFormEditor)WizardFormEditor.this).buttonContainer.computeSize((int)-1, (int)-1).x;
            return Math.max(bwidth, width);
        }

        public int computeMinimumWidth(Composite parent, boolean changed) {
            int dwidth = ((WizardFormEditor)WizardFormEditor.this).descriptionLabel.computeSize((int)10, (int)-1).x;
            int pwidth = ((ILayoutExtension)WizardFormEditor.this.pageContainer.getLayout()).computeMinimumWidth(WizardFormEditor.this.pageContainer, changed);
            int width = Math.max(dwidth, pwidth);
            int bwidth = ((WizardFormEditor)WizardFormEditor.this).buttonContainer.computeSize((int)-1, (int)-1).x;
            return Math.max(bwidth, width);
        }
    }
}

