/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Dictionary;
import java.util.HashMap;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.PackageSpecificationImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

class StateBuilder {
    StateBuilder() {
    }

    static BundleDescription createBundleDescription(Dictionary manifest, String location) throws BundleException {
        String version;
        ManifestElement[] symbolicNameElements;
        BundleDescriptionImpl result = new BundleDescriptionImpl();
        String symbolicNameHeader = (String)manifest.get("Bundle-SymbolicName");
        if (symbolicNameHeader != null && (symbolicNameElements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameHeader)).length > 0) {
            result.setSymbolicName(symbolicNameElements[0].getValue());
            result.setSingleton("true".equals(symbolicNameElements[0].getAttribute("singleton")));
        }
        result.setVersion((version = (String)manifest.get("Bundle-Version")) != null ? new Version(version) : Version.emptyVersion);
        result.setLocation(location);
        ManifestElement[] host = ManifestElement.parseHeader((String)"Fragment-Host", (String)((String)manifest.get("Fragment-Host")));
        if (host != null) {
            result.setHost(StateBuilder.createHostSpecification(host[0]));
        }
        ManifestElement[] imports = ManifestElement.parseHeader((String)"Import-Package", (String)((String)manifest.get("Import-Package")));
        ManifestElement[] exports = ManifestElement.parseHeader((String)"Export-Package", (String)((String)manifest.get("Export-Package")));
        result.setPackages(StateBuilder.createPackages(exports, imports));
        ManifestElement[] provides = ManifestElement.parseHeader((String)"Provide-Package", (String)((String)manifest.get("Provide-Package")));
        result.setProvidedPackages(StateBuilder.createProvidedPackages(provides));
        ManifestElement[] requires = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)manifest.get("Require-Bundle")));
        result.setRequiredBundles(StateBuilder.createRequiredBundles(requires));
        return result;
    }

    private static BundleSpecification[] createRequiredBundles(ManifestElement[] specs) {
        if (specs == null) {
            return null;
        }
        BundleSpecification[] result = new BundleSpecification[specs.length];
        int i = 0;
        while (i < specs.length) {
            result[i] = StateBuilder.createRequiredBundle(specs[i]);
            ++i;
        }
        return result;
    }

    private static BundleSpecification createRequiredBundle(ManifestElement spec) {
        BundleSpecificationImpl result = new BundleSpecificationImpl();
        result.setName(spec.getValue());
        result.setVersionRange(new VersionRange(spec.getAttribute("bundle-version")));
        result.setExported(spec.getAttribute("reprovide") != null);
        result.setOptional(spec.getAttribute("optional") != null);
        return result;
    }

    private static String[] createProvidedPackages(ManifestElement[] specs) {
        if (specs == null || specs.length == 0) {
            return null;
        }
        String[] result = new String[specs.length];
        int i = 0;
        while (i < specs.length) {
            result[i] = specs[i].getValue();
            ++i;
        }
        return result;
    }

    private static PackageSpecification[] createPackages(ManifestElement[] exported, ManifestElement[] imported) {
        int i;
        int capacity = (exported == null ? 0 : exported.length) + (imported == null ? 0 : imported.length);
        if (capacity == 0) {
            return null;
        }
        HashMap<String, PackageSpecification> packages = new HashMap<String, PackageSpecification>(capacity);
        if (imported != null) {
            i = 0;
            while (i < imported.length) {
                packages.put(imported[i].getValue(), StateBuilder.createPackage(imported[i], false));
                ++i;
            }
        }
        if (exported != null) {
            i = 0;
            while (i < exported.length) {
                packages.put(exported[i].getValue(), StateBuilder.createPackage(exported[i], true));
                ++i;
            }
        }
        return packages.values().toArray(new PackageSpecification[packages.size()]);
    }

    private static PackageSpecification createPackage(ManifestElement spec, boolean export) {
        PackageSpecificationImpl result = new PackageSpecificationImpl();
        result.setName(spec.getValue());
        result.setVersionRange(new VersionRange(spec.getAttribute("specification-version")));
        result.setExport(export);
        return result;
    }

    private static HostSpecification createHostSpecification(ManifestElement spec) {
        if (spec == null) {
            return null;
        }
        HostSpecificationImpl result = new HostSpecificationImpl();
        result.setName(spec.getValue());
        result.setVersionRange(new VersionRange(spec.getAttribute("bundle-version")));
        result.setReloadHost(false);
        return result;
    }
}

