/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.internal.resolver.ComputeNodeOrder;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class StateHelperImpl
implements StateHelper {
    private static StateHelper instance = new StateHelperImpl();

    public BundleDescription[] getDependentBundles(BundleDescription[] roots) {
        boolean changed;
        if (roots == null || roots.length == 0) {
            return new BundleDescription[0];
        }
        HashSet<BundleDescription> remaining = new HashSet<BundleDescription>(Arrays.asList(roots[0].getContainingState().getResolvedBundles()));
        HashSet<BundleDescription> reachable = new HashSet<BundleDescription>(roots.length);
        int i = 0;
        while (i < roots.length) {
            if (roots[i].isResolved()) {
                reachable.add(roots[i]);
                remaining.remove(roots[i]);
            }
            ++i;
        }
        do {
            changed = false;
            Iterator remainingIter = remaining.iterator();
            while (remainingIter.hasNext()) {
                BundleDescription candidate = (BundleDescription)remainingIter.next();
                if (!this.isDependent(candidate, reachable)) continue;
                reachable.add(candidate);
                remainingIter.remove();
                changed = true;
            }
        } while (changed);
        return reachable.toArray(new BundleDescription[reachable.size()]);
    }

    private boolean isDependent(BundleDescription candidate, Set bundles) {
        HostSpecification candidateHost = candidate.getHost();
        if (candidateHost != null && candidateHost.isResolved() && bundles.contains(candidateHost.getSupplier())) {
            return true;
        }
        BundleSpecification[] candidateRequired = candidate.getRequiredBundles();
        int i = 0;
        while (i < candidateRequired.length) {
            if (candidateRequired[i].isResolved() && bundles.contains(candidateRequired[i].getSupplier())) {
                return true;
            }
            ++i;
        }
        PackageSpecification[] candidatePackages = candidate.getPackages();
        int i2 = 0;
        while (i2 < candidatePackages.length) {
            if (candidatePackages[i2].isResolved() && candidatePackages[i2].getSupplier() != candidate && bundles.contains(candidatePackages[i2].getSupplier())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public VersionConstraint[] getUnsatisfiedConstraints(BundleDescription bundle) {
        State containingState = bundle.getContainingState();
        if (containingState == null) {
            throw new IllegalStateException("Does not belong to a state");
        }
        ArrayList<Object> unsatisfied = new ArrayList<Object>();
        HostSpecification host = bundle.getHost();
        if (host != null && !host.isResolved() && !this.isResolvable(host)) {
            unsatisfied.add(host);
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        int i = 0;
        while (i < requiredBundles.length) {
            if (!requiredBundles[i].isResolved() && !this.isResolvable(requiredBundles[i])) {
                unsatisfied.add(requiredBundles[i]);
            }
            ++i;
        }
        PackageSpecification[] packages = bundle.getPackages();
        int i2 = 0;
        while (i2 < packages.length) {
            if (!packages[i2].isResolved() && !this.isResolvable(packages[i2])) {
                unsatisfied.add(packages[i2]);
            }
            ++i2;
        }
        return unsatisfied.toArray(new VersionConstraint[unsatisfied.size()]);
    }

    public boolean isResolvable(PackageSpecification specification) {
        if (specification.isExported()) {
            return true;
        }
        PackageSpecification exported = this.getExportedPackage(specification.getBundle().getContainingState(), specification.getName(), null);
        if (exported == null) {
            return false;
        }
        return specification.isSatisfiedBy(exported.getVersionRange().getMinimum());
    }

    public boolean isResolvable(BundleSpecification specification) {
        return this.isBundleConstraintResolvable((VersionConstraint)specification);
    }

    public boolean isResolvable(HostSpecification specification) {
        return this.isBundleConstraintResolvable((VersionConstraint)specification);
    }

    private boolean isBundleConstraintResolvable(VersionConstraint constraint) {
        BundleDescription[] availableBundles = constraint.getBundle().getContainingState().getBundles(constraint.getName());
        int i = 0;
        while (i < availableBundles.length) {
            if (availableBundles[i].isResolved() && constraint.isSatisfiedBy(availableBundles[i].getVersion())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public PackageSpecification[] getExportedPackages(BundleDescription bundle) {
        if (!bundle.isResolved()) {
            return new PackageSpecification[0];
        }
        PackageSpecification[] allPackages = bundle.getPackages();
        PackageSpecification[] exported = new PackageSpecification[allPackages.length];
        int exportedCount = 0;
        int i = 0;
        while (i < allPackages.length) {
            if (allPackages[i].isExported() && allPackages[i].getSupplier() == bundle) {
                exported[exportedCount++] = allPackages[i];
            }
            ++i;
        }
        if (exportedCount < exported.length) {
            PackageSpecification[] tmpExported = new PackageSpecification[exportedCount];
            System.arraycopy(exported, 0, tmpExported, 0, exportedCount);
            exported = tmpExported;
        }
        return exported;
    }

    public PackageSpecification getExportedPackage(State state, String packageName, Version version) {
        BundleDescription[] resolvedBundles = state.getResolvedBundles();
        boolean ignoreVersion = version == null;
        int i = 0;
        while (i < resolvedBundles.length) {
            PackageSpecification[] packages = resolvedBundles[i].getPackages();
            int j = 0;
            while (j < packages.length) {
                if (packages[j].getName().equals(packageName) && (ignoreVersion || packages[j].getVersionRange().getMinimum().equals((Object)version)) && packages[j].getSupplier() != null) {
                    return packages[j].getSupplier().getPackage(packageName);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public Object[][] sortBundles(BundleDescription[] toSort) {
        ArrayList references = new ArrayList(toSort.length);
        int i = 0;
        while (i < toSort.length) {
            if (toSort[i].isResolved()) {
                this.buildReferences(toSort[i], references);
            }
            ++i;
        }
        return ComputeNodeOrder.computeNodeOrder(toSort, (Object[][])references.toArray((T[])new Object[references.size()][]));
    }

    private void buildReferences(BundleDescription description, List references) {
        HostSpecification host = description.getHost();
        if (host != null) {
            if (host.getSupplier() != null && host.getSupplier() != description) {
                references.add(new Object[]{description, host.getSupplier()});
            }
        } else {
            this.buildReferences(description, (VersionConstraint[])description.getRequiredBundles(), references);
            this.buildReferences(description, (VersionConstraint[])description.getPackages(), references);
            BundleDescription[] fragments = description.getFragments();
            int i = 0;
            while (i < fragments.length) {
                this.buildReferences(description, (VersionConstraint[])fragments[i].getRequiredBundles(), references);
                this.buildReferences(description, (VersionConstraint[])fragments[i].getPackages(), references);
                ++i;
            }
        }
    }

    private void buildReferences(BundleDescription actual, VersionConstraint[] constraints, List references) {
        int i = 0;
        while (i < constraints.length) {
            VersionConstraint constraint = constraints[i];
            if (constraint.getSupplier() != null && constraint.getSupplier() != actual) {
                references.add(new Object[]{actual, constraint.getSupplier()});
            }
            ++i;
        }
    }

    public static StateHelper getInstance() {
        return instance;
    }
}

