/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.osgi.internal.resolver.BundleInstaller;
import org.eclipse.osgi.internal.resolver.ReadOnlyState;
import org.eclipse.osgi.internal.resolver.ResolverImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateMsg;
import org.eclipse.osgi.internal.resolver.StateObjectFactoryImpl;
import org.eclipse.osgi.internal.resolver.UserState;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.BundleException;

public class StateManager
implements PlatformAdmin {
    public static boolean DEBUG = false;
    public static boolean DEBUG_READER = false;
    public static boolean DEBUG_PLATFORM_ADMIN = false;
    public static boolean DEBUG_PLATFORM_ADMIN_RESOLVER = false;
    public static boolean MONITOR_PLATFORM_ADMIN = false;
    private long readStartupTime;
    private StateImpl systemState;
    private StateObjectFactoryImpl factory = new StateObjectFactoryImpl();
    private long lastTimeStamp;
    private BundleInstaller installer;
    private boolean cachedState = false;

    public StateManager(File stateLocation) {
        this(stateLocation, -1L);
    }

    public StateManager(File stateLocation, long expectedTimeStamp) {
        this.readState(stateLocation, expectedTimeStamp);
    }

    public void shutdown(File stateLocation) throws IOException {
        this.writeState(stateLocation);
    }

    /*
     * Exception decompiling
     */
    private void readState(File stateLocation, long expectedTimeStamp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 149->153)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeState(File stateLocation) throws IOException {
        if (this.systemState == null) {
            return;
        }
        if (this.cachedState && this.lastTimeStamp == this.systemState.getTimeStamp()) {
            return;
        }
        this.factory.writeState((State)this.systemState, new BufferedOutputStream(new FileOutputStream(stateLocation)));
    }

    public StateImpl createSystemState() {
        this.systemState = this.factory.createSystemState();
        this.initializeSystemState();
        return this.systemState;
    }

    private void initializeSystemState() {
        this.systemState.setResolver(new ResolverImpl());
        this.lastTimeStamp = this.systemState.getTimeStamp();
    }

    public StateImpl getSystemState() {
        return this.systemState;
    }

    public State getState(boolean mutable) {
        return mutable ? this.factory.createState(this.systemState) : new ReadOnlyState(this.systemState);
    }

    public State getState() {
        return this.getState(true);
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    public synchronized void commit(State state) throws BundleException {
        if (this.installer == null) {
            throw new IllegalArgumentException("PlatformAdmin.commit() not supported");
        }
        if (!(state instanceof UserState)) {
            throw new IllegalArgumentException("Wrong state implementation");
        }
        if (state.getTimeStamp() != this.systemState.getTimeStamp()) {
            throw new BundleException(StateMsg.formatter.getString("COMMIT_INVALID_TIMESTAMP"));
        }
        StateDelta delta = state.compare((State)this.systemState);
        BundleDelta[] changes = delta.getChanges();
        int i = 0;
        while (i < changes.length) {
            if ((changes[i].getType() & 1) > 0) {
                this.installer.installBundle(changes[i].getBundle());
            } else if ((changes[i].getType() & 2) > 0) {
                this.installer.uninstallBundle(changes[i].getBundle());
            } else if ((changes[i].getType() & 4) > 0) {
                this.installer.updateBundle(changes[i].getBundle());
            }
            ++i;
        }
    }

    public Resolver getResolver() {
        return new ResolverImpl();
    }

    public StateHelper getStateHelper() {
        return StateHelperImpl.getInstance();
    }

    public BundleInstaller getInstaller() {
        return this.installer;
    }

    public void setInstaller(BundleInstaller installer) {
        this.installer = installer;
    }
}

