/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.PackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateBuilder;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateReader;
import org.eclipse.osgi.internal.resolver.StateWriter;
import org.eclipse.osgi.internal.resolver.SystemState;
import org.eclipse.osgi.internal.resolver.UserState;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.BundleException;

public class StateObjectFactoryImpl
implements StateObjectFactory {
    public static final byte NO_MATCH = 0;
    public static final byte QUALIFIER_MATCH = 1;
    public static final byte MICRO_MATCH = 5;
    public static final byte MINOR_MATCH = 2;
    public static final byte MAJOR_MATCH = 3;
    public static final byte GREATER_EQUAL_MATCH = 4;
    public static final byte OTHER_MATCH = 5;

    public BundleDescription createBundleDescription(Dictionary manifest, String location, long id) throws BundleException {
        BundleDescriptionImpl result = (BundleDescriptionImpl)StateBuilder.createBundleDescription(manifest, location);
        result.setBundleId(id);
        return result;
    }

    public BundleDescription createBundleDescription(long id, String symbolicName, Version version, String location, BundleSpecification[] required, HostSpecification host, PackageSpecification[] packages, String[] providedPackages, boolean singleton) {
        BundleDescriptionImpl bundle = new BundleDescriptionImpl();
        bundle.setBundleId(id);
        bundle.setSymbolicName(symbolicName);
        bundle.setVersion(version);
        bundle.setLocation(location);
        bundle.setRequiredBundles(required);
        bundle.setPackages(packages);
        bundle.setHost(host);
        bundle.setProvidedPackages(providedPackages);
        bundle.setSingleton(singleton);
        return bundle;
    }

    public BundleDescription createBundleDescription(long id, String symbolicName, Version version, String location, BundleSpecification[] required, HostSpecification[] hosts, PackageSpecification[] packages, String[] providedPackages, boolean singleton) {
        HostSpecification host = hosts == null || hosts.length == 0 ? null : hosts[1];
        return this.createBundleDescription(id, symbolicName, version, location, required, host, packages, providedPackages, singleton);
    }

    public BundleDescription createBundleDescription(BundleDescription original) {
        BundleDescriptionImpl bundle = new BundleDescriptionImpl();
        bundle.setBundleId(original.getBundleId());
        bundle.setSymbolicName(original.getSymbolicName());
        bundle.setVersion(original.getVersion());
        bundle.setLocation(original.getLocation());
        BundleSpecification[] originalRequired = original.getRequiredBundles();
        BundleSpecification[] newRequired = new BundleSpecification[originalRequired.length];
        int i = 0;
        while (i < newRequired.length) {
            newRequired[i] = this.createBundleSpecification(originalRequired[i]);
            ++i;
        }
        bundle.setRequiredBundles(newRequired);
        PackageSpecification[] originalPackages = original.getPackages();
        PackageSpecification[] newPackages = new PackageSpecification[originalPackages.length];
        int i2 = 0;
        while (i2 < newPackages.length) {
            newPackages[i2] = this.createPackageSpecification(originalPackages[i2]);
            ++i2;
        }
        bundle.setPackages(newPackages);
        if (original.getHost() != null) {
            bundle.setHost(this.createHostSpecification(original.getHost()));
        }
        String[] originalProvidedPackages = original.getProvidedPackages();
        String[] newProvidedPackages = new String[originalProvidedPackages.length];
        System.arraycopy(originalProvidedPackages, 0, newProvidedPackages, 0, originalProvidedPackages.length);
        bundle.setProvidedPackages(newProvidedPackages);
        bundle.setSingleton(original.isSingleton());
        return bundle;
    }

    public BundleSpecification createBundleSpecification(String requiredSymbolicName, Version requiredVersion, byte matchingRule, boolean export, boolean optional) {
        BundleSpecificationImpl bundleSpec = new BundleSpecificationImpl();
        bundleSpec.setName(requiredSymbolicName);
        this.setVersionRange(bundleSpec, matchingRule, requiredVersion);
        bundleSpec.setExported(export);
        bundleSpec.setOptional(optional);
        return bundleSpec;
    }

    public BundleSpecification createBundleSpecification(BundleSpecification original) {
        BundleSpecificationImpl bundleSpec = new BundleSpecificationImpl();
        bundleSpec.setName(original.getName());
        bundleSpec.setVersionRange(original.getVersionRange());
        bundleSpec.setExported(original.isExported());
        bundleSpec.setOptional(original.isOptional());
        return bundleSpec;
    }

    public HostSpecification createHostSpecification(String hostSymbolicName, Version hostVersion, byte matchingRule, boolean reloadHost) {
        HostSpecificationImpl hostSpec = new HostSpecificationImpl();
        hostSpec.setName(hostSymbolicName);
        this.setVersionRange(hostSpec, matchingRule, hostVersion);
        hostSpec.setReloadHost(reloadHost);
        return hostSpec;
    }

    public HostSpecification createHostSpecification(HostSpecification original) {
        HostSpecificationImpl hostSpec = new HostSpecificationImpl();
        hostSpec.setName(original.getName());
        hostSpec.setVersionRange(original.getVersionRange());
        hostSpec.setReloadHost(original.reloadHost());
        return hostSpec;
    }

    public PackageSpecification createPackageSpecification(String packageName, Version packageVersion, boolean exported) {
        PackageSpecificationImpl packageSpec = new PackageSpecificationImpl();
        packageSpec.setName(packageName);
        packageSpec.setVersionRange(new VersionRange(packageVersion, Version.maxVersion));
        packageSpec.setExport(exported);
        return packageSpec;
    }

    public PackageSpecification createPackageSpecification(PackageSpecification original) {
        PackageSpecificationImpl packageSpec = new PackageSpecificationImpl();
        packageSpec.setName(original.getName());
        packageSpec.setVersionRange(original.getVersionRange());
        packageSpec.setExport(original.isExported());
        return packageSpec;
    }

    public SystemState createSystemState() {
        SystemState state = new SystemState();
        state.setFactory(this);
        return state;
    }

    public State createState() {
        return this.internalCreateState();
    }

    public State createState(State original) {
        StateImpl newState = this.internalCreateState();
        newState.setTimeStamp(original.getTimeStamp());
        BundleDescription[] bundles = original.getBundles();
        int i = 0;
        while (i < bundles.length) {
            newState.basicAddBundle(this.createBundleDescription(bundles[i]));
            ++i;
        }
        newState.setResolved(false);
        return newState;
    }

    private StateImpl internalCreateState() {
        UserState state = new UserState();
        state.setFactory(this);
        return state;
    }

    SystemState readSystemState(InputStream stream, long expectedTimeStamp) throws IOException {
        return (SystemState)this.internalReadState(this.createSystemState(), new DataInputStream(stream), expectedTimeStamp);
    }

    public State readState(InputStream stream) throws IOException {
        return this.internalReadState(this.internalCreateState(), new DataInputStream(stream), -1L);
    }

    public State readState(DataInputStream stream) throws IOException {
        return this.internalReadState(this.internalCreateState(), stream, -1L);
    }

    private State internalReadState(StateImpl toRestore, DataInputStream stream, long expectedTimestamp) throws IOException {
        StateReader reader = new StateReader();
        if (!reader.loadState(toRestore, stream, expectedTimestamp)) {
            return null;
        }
        return toRestore;
    }

    public void writeState(State state, DataOutputStream stream) throws IOException {
        this.internalWriteState(state, stream);
    }

    public void writeState(State state, OutputStream stream) throws IOException {
        this.internalWriteState(state, new DataOutputStream(stream));
    }

    public void internalWriteState(State state, DataOutputStream stream) throws IOException {
        if (state.getFactory() != this) {
            throw new IllegalArgumentException();
        }
        StateWriter writer = new StateWriter();
        writer.saveState((StateImpl)state, stream);
    }

    private void setVersionRange(VersionConstraintImpl constraint, int matchingRule, Version minVersion) {
        if (matchingRule == 0 || matchingRule == 5) {
            return;
        }
        if (minVersion == null) {
            return;
        }
        switch (matchingRule) {
            case 1: {
                constraint.setVersionRange(new VersionRange(minVersion, minVersion));
                break;
            }
            case 5: {
                Version maxVersion = new Version(minVersion.getMajorComponent(), minVersion.getMinorComponent(), minVersion.getMicroComponent() + 1, "", false);
                constraint.setVersionRange(new VersionRange(minVersion, maxVersion));
                break;
            }
            case 2: {
                Version maxVersion = new Version(minVersion.getMajorComponent(), minVersion.getMinorComponent() + 1, 0, "", false);
                constraint.setVersionRange(new VersionRange(minVersion, maxVersion));
                break;
            }
            case 3: {
                Version maxVersion = new Version(minVersion.getMajorComponent() + 1, 0, 0, "", false);
                constraint.setVersionRange(new VersionRange(minVersion, maxVersion));
                break;
            }
            case 4: {
                constraint.setVersionRange(new VersionRange(minVersion, Version.maxVersion));
            }
        }
    }
}

