/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchEngine;
import org.eclipse.search.internal.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FileSearchQuery
implements ISearchQuery {
    private String fSearchString;
    private String fSearchOptions;
    private TextSearchScope fScope;
    private FileSearchResult fResult;
    private boolean fVisitDerived;

    public FileSearchQuery(TextSearchScope scope, String options, String searchString, boolean visitDerived) {
        this.fVisitDerived = visitDerived;
        this.fScope = scope;
        this.fSearchOptions = options;
        this.fSearchString = searchString;
    }

    public FileSearchQuery(TextSearchScope scope, String options, String searchString) {
        this(scope, options, searchString, false);
    }

    public boolean canRunInBackground() {
        return true;
    }

    public IStatus run(IProgressMonitor pm) {
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        TextSearchResultCollector collector = new TextSearchResultCollector(textResult, pm);
        return new TextSearchEngine().search(this.fScope, this.fVisitDerived, collector, new MatchLocator(this.fSearchString, this.isCaseSensitive(), this.isRegexSearch()), true);
    }

    public String getLabel() {
        return SearchMessages.getString("FileSearchQuery.label");
    }

    public String getSearchString() {
        return this.fSearchString;
    }

    private String getSearchOptions() {
        return this.fSearchOptions;
    }

    String getSingularLabel() {
        Object[] args = new String[]{this.fSearchString, this.fScope.getDescription()};
        return SearchMessages.getFormattedString("FileSearchQuery.singularLabel", args);
    }

    String getPluralPattern() {
        Object[] args = new String[]{FileSearchQuery.quote(this.fSearchString), "{0}", this.fScope.getDescription()};
        return SearchMessages.getFormattedString("FileSearchQuery.pluralPattern", args);
    }

    public static String quote(String searchString) {
        searchString = searchString.replaceAll("\\'", "''");
        return searchString.replaceAll("\\{", "'{'");
    }

    public IStatus searchInFile(AbstractTextSearchResult result, IProgressMonitor monitor, IFile file) {
        TextSearchResultCollector collector = new TextSearchResultCollector(result, monitor);
        SearchScope scope = new SearchScope("", new IResource[]{file});
        return new TextSearchEngine().search(scope, this.fVisitDerived, collector, new MatchLocator(this.fSearchString, this.isCaseSensitive(), this.isRegexSearch()), true);
    }

    public boolean isRegexSearch() {
        return FileSearchQuery.isRegexSearch(this.getSearchOptions());
    }

    public static boolean isRegexSearch(String options) {
        return options.indexOf(114) != -1;
    }

    public boolean isCaseSensitive() {
        return FileSearchQuery.isCaseSensitive(this.getSearchOptions());
    }

    public static boolean isCaseSensitive(String options) {
        return options.indexOf(105) == -1;
    }

    public boolean canRerun() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new FileSearchResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    private static final class TextSearchResultCollector
    implements ITextSearchResultCollector {
        private final AbstractTextSearchResult fResult;
        private final IProgressMonitor fProgressMonitor;

        TextSearchResultCollector(AbstractTextSearchResult result, IProgressMonitor monitor) {
            this.fResult = result;
            this.fProgressMonitor = monitor;
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }

        public void aboutToStart() {
        }

        public void accept(IResourceProxy proxy, int start, int length) {
            IFile file = (IFile)proxy.requestResource();
            if (start < 0) {
                start = 0;
            }
            if (length < 0) {
                length = 0;
            }
            this.fResult.addMatch(new FileMatch(file, start, length));
        }

        public void done() {
        }
    }
}

