/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.ExtensionsErrorReporter;
import org.eclipse.pde.internal.builders.FragmentErrorReporter;
import org.eclipse.pde.internal.builders.PluginErrorReporter;
import org.eclipse.pde.internal.builders.ValidatingSAXParser;
import org.eclipse.pde.internal.builders.XMLErrorReporter;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;

public class ManifestConsistencyChecker
extends IncrementalProjectBuilder {
    public static final String BUILDERS_VERIFYING = "Builders.verifying";
    public static final String BUILDERS_UPDATING = "Builders.updating";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (PDECore.getDefault().getBundle().getState() != 32 || monitor.isCanceled()) {
            return new IProject[0];
        }
        IProject project = this.getProject();
        if (!WorkspaceModelManager.isBinaryPluginProject((IProject)project)) {
            this.checkThisProject(monitor);
        }
        return new IProject[0];
    }

    private void checkThisProject(IProgressMonitor monitor) {
        IProject project = this.getProject();
        IFile file = project.getFile("plugin.xml");
        if (!file.exists()) {
            file = project.getFile("fragment.xml");
        }
        if (file.exists()) {
            this.checkFile(file, monitor);
        }
    }

    private void checkFile(IFile file, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String message = PDE.getFormattedMessage(BUILDERS_VERIFYING, file.getFullPath().toString());
        monitor.subTask(message);
        IFile bundleManifest = file.getProject().getFile("META-INF/MANIFEST.MF");
        ExtensionsErrorReporter reporter = null;
        if (bundleManifest.exists()) {
            reporter = new ExtensionsErrorReporter(file);
        } else if (file.getName().equals("plugin.xml")) {
            reporter = new PluginErrorReporter(file);
        } else if (file.getName().equals("fragment.xml")) {
            reporter = new FragmentErrorReporter(file);
        }
        if (reporter != null) {
            ValidatingSAXParser.parse(file, (XMLErrorReporter)reporter);
            ((XMLErrorReporter)reporter).validateContent(monitor);
            monitor.subTask(PDE.getResourceString(BUILDERS_UPDATING));
        }
        monitor.done();
    }
}

