/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.builders.XMLErrorReporter;
import org.eclipse.pde.internal.core.PDECore;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ManifestErrorReporter
extends XMLErrorReporter {
    public ManifestErrorReporter(IFile file) {
        super(file);
    }

    protected void reportIllegalElement(Element element, int severity) {
        Node parent = element.getParentNode();
        if (parent == null || parent instanceof Document) {
            this.report(PDE.getResourceString("Builders.Manifest.illegalRoot"), this.getLine(element), severity);
        } else {
            this.report(PDE.getFormattedMessage("Builders.Manifest.child", new String[]{element.getNodeName(), parent.getNodeName()}), this.getLine(element), severity);
        }
    }

    protected void reportMissingRequiredAttribute(Element element, String attName, int severity) {
        String message = PDE.getFormattedMessage("Builders.Manifest.missingRequired", new String[]{attName, element.getNodeName()});
        this.report(message, this.getLine(element), severity);
    }

    protected boolean assertAttributeDefined(Element element, String attrName, int severity) {
        Attr attr = element.getAttributeNode(attrName);
        if (attr == null) {
            this.reportMissingRequiredAttribute(element, attrName, severity);
            return false;
        }
        return true;
    }

    protected void reportUnknownAttribute(Element element, String attName, int severity) {
        String message = PDE.getFormattedMessage("Builders.Manifest.attribute", attName);
        this.report(message, this.getLine(element, attName), severity);
    }

    protected void reportIllegalAttributeValue(Element element, Attr attr) {
        String message = PDE.getFormattedMessage("Builders.Manifest.att-value", new String[]{attr.getValue(), attr.getName()});
        this.report(message, this.getLine(element, attr.getName()), 0);
    }

    protected void validateVersionAttribute(Element element, Attr attr) {
        IStatus status = PluginVersionIdentifier.validateVersion((String)attr.getValue());
        if (status.getSeverity() != 0) {
            this.report(status.getMessage(), this.getLine(element, attr.getName()), 0);
        }
    }

    protected void validateMatch(Element element, Attr attr) {
        String value = attr.getValue();
        if (!("perfect".equals(value) || "equivalent".equals(value) || "greaterOrEqual".equals(value) || "compatible".equals(value))) {
            this.reportIllegalAttributeValue(element, attr);
        }
    }

    protected void validateElementWithContent(Element element, boolean hasContent) {
        NodeList children = element.getChildNodes();
        boolean textFound = false;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Text) {
                textFound = ((Text)child).getNodeValue().trim().length() > 0;
            } else if (child instanceof Element) {
                this.reportIllegalElement((Element)child, 0);
            }
            ++i;
        }
        if (!textFound) {
            this.reportMissingElementContent(element);
        }
    }

    private void reportMissingElementContent(Element element) {
        this.report(PDE.getFormattedMessage("Builders.Feature.empty", element.getNodeName()), this.getLine(element), 0);
    }

    protected void reportExtraneousElements(NodeList elements, int maximum) {
        if (elements.getLength() > maximum) {
            int i = maximum;
            while (i < elements.getLength()) {
                Element element = (Element)elements.item(i);
                this.report(PDE.getFormattedMessage("Builders.Feature.multiplicity", element.getNodeName()), this.getLine(element), 0);
                ++i;
            }
        }
    }

    protected void validateURL(Element element, String attName) {
        String value = element.getAttribute(attName);
        try {
            if (!value.startsWith("http:") && !value.startsWith("file:")) {
                value = "file:" + value;
            }
            new URL(value);
        }
        catch (MalformedURLException malformedURLException) {
            this.report(PDE.getFormattedMessage("Builders.Feature.badURL", attName), this.getLine(element, attName), 0);
        }
    }

    protected void validatePluginID(Element element, Attr attr) {
        IPluginModelBase model;
        int severity = CompilerFlags.getFlag(this.project, "compilers.p.unresolved-import");
        if ("true".equals(element.getAttribute("optional")) && severity == 0) {
            severity = 1;
        }
        if (!(severity == 2 || (model = PDECore.getDefault().getModelManager().findModel(attr.getValue())) != null && model.isEnabled())) {
            this.report(PDE.getFormattedMessage("Builders.Manifest.dependency", attr.getValue()), this.getLine(element, attr.getName()), severity);
        }
    }

    protected void validateBoolean(Element element, Attr attr) {
        String value = attr.getValue();
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            this.reportIllegalAttributeValue(element, attr);
        }
    }
}

