/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.FeatureContentProvider;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.security.JarVerifier;

public class FeaturePackagedContentProvider
extends FeatureContentProvider {
    private ContentReference localManifest = null;
    private ContentReference[] localFeatureFiles = new ContentReference[0];
    private IVerifier jarVerifier = null;
    public static final FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };

    public FeaturePackagedContentProvider(URL url) {
        super(url);
    }

    public IVerifier getVerifier() throws CoreException {
        if (this.jarVerifier == null || this.jarVerifier.getParent() == null) {
            this.jarVerifier = new JarVerifier();
            return this.jarVerifier;
        }
        return this.jarVerifier;
    }

    public ContentReference getFeatureManifestReference(InstallMonitor monitor) throws CoreException {
        if (this.localManifest != null) {
            return this.localManifest;
        }
        ContentReference[] featureArchiveReference = this.getFeatureEntryArchiveReferences(monitor);
        JarContentReference featureJarReference = null;
        try {
            featureJarReference = (JarContentReference)this.asLocalReference(featureArchiveReference[0], null);
            this.localFeatureFiles = featureJarReference.unpack(this.getWorkingDirectory(), null, monitor);
        }
        catch (IOException e) {
            throw this.errorRetrieving("feature.xml", featureJarReference, this.getURL(), e);
        }
        int i = 0;
        while (i < this.localFeatureFiles.length) {
            if (this.localFeatureFiles[i].getIdentifier().equals("feature.xml")) {
                this.localManifest = this.localFeatureFiles[i];
                return this.localManifest;
            }
            ++i;
        }
        Object[] values = new String[]{"feature.xml", this.getURL().toExternalForm()};
        throw Utilities.newCoreException(Policy.bind("FeaturePackagedContentProvider.NoManifestFile", values), new Exception());
    }

    public ContentReference[] getArchiveReferences(InstallMonitor monitor) throws CoreException {
        IPluginEntry[] entries = this.getFeature().getPluginEntries();
        INonPluginEntry[] nonEntries = this.getFeature().getNonPluginEntries();
        ArrayList<ContentReference> listAllContentRef = new ArrayList<ContentReference>();
        ContentReference[] allContentRef = new ContentReference[]{};
        listAllContentRef.addAll(Arrays.asList(this.getFeatureEntryArchiveReferences(monitor)));
        int i = 0;
        while (i < entries.length) {
            listAllContentRef.addAll(Arrays.asList(this.getPluginEntryArchiveReferences(entries[i], monitor)));
            ++i;
        }
        i = 0;
        while (i < nonEntries.length) {
            listAllContentRef.addAll(Arrays.asList(this.getNonPluginEntryArchiveReferences(nonEntries[i], monitor)));
            ++i;
        }
        if (listAllContentRef.size() > 0) {
            allContentRef = new ContentReference[listAllContentRef.size()];
            listAllContentRef.toArray(allContentRef);
        }
        return allContentRef;
    }

    public ContentReference[] getFeatureEntryArchiveReferences(InstallMonitor monitor) throws CoreException {
        ContentReference[] references = new ContentReference[1];
        ContentReference currentReference = null;
        String archiveID = null;
        try {
            archiveID = this.getFeature() != null ? this.getFeature().getVersionedIdentifier().toString() : "";
            currentReference = new JarContentReference(archiveID, this.getURL());
            currentReference = this.asLocalReference(currentReference, monitor);
            references[0] = currentReference;
        }
        catch (IOException e) {
            throw this.errorRetrieving(archiveID, currentReference, this.getFeature().getURL(), e);
        }
        return references;
    }

    public ContentReference[] getPluginEntryArchiveReferences(IPluginEntry pluginEntry, InstallMonitor monitor) throws CoreException {
        ContentReference[] references = new ContentReference[1];
        String archiveID = this.getPathID(pluginEntry);
        ISite site = this.getFeature() == null ? null : this.getFeature().getSite();
        ISiteContentProvider siteContentProvider = site == null ? null : site.getSiteContentProvider();
        URL url = siteContentProvider == null ? null : siteContentProvider.getArchiveReference(archiveID);
        try {
            references[0] = this.asLocalReference(new JarContentReference(archiveID, url), monitor);
        }
        catch (IOException e) {
            throw this.errorRetrieving(archiveID, references[0], this.getFeature().getURL(), e);
        }
        return references;
    }

    public ContentReference[] getNonPluginEntryArchiveReferences(INonPluginEntry nonPluginEntry, InstallMonitor monitor) throws CoreException {
        String archiveID = "features/" + (this.getFeature() != null ? this.getFeature().getVersionedIdentifier().toString() : "");
        archiveID = String.valueOf(archiveID) + "/" + nonPluginEntry.getIdentifier();
        ContentReference[] references = new ContentReference[1];
        ContentReference currentReference = null;
        try {
            ISite site = this.getFeature() == null ? null : this.getFeature().getSite();
            ISiteContentProvider siteContentProvider = site == null ? null : site.getSiteContentProvider();
            URL url = siteContentProvider == null ? null : siteContentProvider.getArchiveReference(archiveID);
            currentReference = new ContentReference(nonPluginEntry.getIdentifier(), url);
            references[0] = currentReference = this.asLocalReference(currentReference, monitor);
        }
        catch (IOException e) {
            throw this.errorRetrieving(archiveID, currentReference, this.getFeature().getURL(), e);
        }
        return references;
    }

    public ContentReference[] getFeatureEntryContentReferences(InstallMonitor monitor) throws CoreException {
        return this.localFeatureFiles;
    }

    public ContentReference[] getPluginEntryContentReferences(IPluginEntry pluginEntry, InstallMonitor monitor) throws CoreException {
        ContentReference[] references = this.getPluginEntryArchiveReferences(pluginEntry, monitor);
        ContentReference[] pluginReferences = new ContentReference[]{};
        try {
            if (references[0] instanceof JarContentReference) {
                JarContentReference localRef = (JarContentReference)this.asLocalReference(references[0], monitor);
                pluginReferences = localRef.peek(null, monitor);
            } else {
                List files = this.getFiles(references[0].asFile());
                pluginReferences = new ContentReference[files.size()];
                int i = 0;
                while (i < pluginReferences.length) {
                    File currentFile = (File)files.get(i);
                    pluginReferences[i] = new ContentReference(null, currentFile.toURL());
                    ++i;
                }
            }
            this.validatePermissions(pluginReferences);
        }
        catch (IOException e) {
            throw this.errorRetrieving(pluginEntry.getVersionedIdentifier().toString(), references[0], this.getFeature().getURL(), e);
        }
        return pluginReferences;
    }

    private List getFiles(File dir) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        if (!dir.isDirectory()) {
            throw new IOException(Policy.bind("FeaturePackagedContentProvider.InvalidDirectory", dir.getPath()));
        }
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    result.addAll(this.getFiles(files[i]));
                } else {
                    result.add(files[i]);
                }
                ++i;
            }
        }
        return result;
    }

    private CoreException errorRetrieving(String obj, ContentReference archive, URL url, Exception e) {
        Object[] values = new String[]{obj};
        return Utilities.newCoreException(Policy.bind("FeaturePackagedContentProvider.ErrorRetrieving", values), e);
    }
}

