/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.internal.core.ConnectionThreadManager;
import org.eclipse.update.internal.core.Response;
import org.eclipse.update.internal.core.UpdateCore;

public class OtherResponse
implements Response {
    private static final long POLLING_INTERVAL = 200L;
    protected URL url;
    protected InputStream in;
    protected URLConnection connection;
    protected long lastModified;

    public OtherResponse(URL url) throws IOException {
        this.url = url;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null && this.url != null) {
            this.connection = this.url.openConnection();
            this.in = this.connection.getInputStream();
            this.lastModified = this.connection.getLastModified();
        }
        return this.in;
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException, CoreException {
        if (this.in == null && this.url != null) {
            this.connection = this.url.openConnection();
            this.in = monitor != null ? this.openStreamWithCancel(this.connection, monitor) : this.connection.getInputStream();
            if (this.in != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.in;
    }

    public long getContentLength() {
        if (this.connection != null) {
            return this.connection.getContentLength();
        }
        return 0L;
    }

    public int getStatusCode() {
        return 200;
    }

    public String getStatusMessage() {
        return "";
    }

    public long getLastModified() {
        if (this.lastModified == 0L && this.connection != null) {
            this.lastModified = this.connection.getLastModified();
        }
        return this.lastModified;
    }

    private InputStream openStreamWithCancel(URLConnection urlConnection, IProgressMonitor monitor) throws IOException, CoreException {
        ConnectionThreadManager.StreamRunnable runnable = new ConnectionThreadManager.StreamRunnable(urlConnection);
        Thread t = UpdateCore.getPlugin().getConnectionManager().createThread(runnable);
        t.start();
        InputStream is = null;
        try {
            while (true) {
                if (monitor.isCanceled()) {
                    runnable.disconnect();
                    break;
                }
                if (runnable.getInputStream() != null) {
                    is = runnable.getInputStream();
                    break;
                }
                if (runnable.getException() != null) {
                    if (runnable.getException() instanceof IOException) {
                        throw (IOException)runnable.getException();
                    }
                    throw new CoreException((IStatus)new Status(4, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, runnable.getException().getMessage(), (Throwable)runnable.getException()));
                }
                t.join(200L);
            }
        }
        catch (InterruptedException interruptedException) {}
        return is;
    }
}

