/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.registry.ConfigurationElementAdapter;
import org.eclipse.pde.internal.runtime.registry.ExtensionAdapter;
import org.eclipse.pde.internal.runtime.registry.ExtensionPointAdapter;
import org.eclipse.pde.internal.runtime.registry.IPluginFolder;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserLabelProvider;
import org.osgi.framework.BundleException;

public class RegistryBrowserContentProvider
implements ITreeContentProvider {
    private Hashtable pluginMap = new Hashtable();
    private boolean showRunning;
    public boolean isInExtensionSet;
    private TreeViewer viewer;
    private int numPluginsTotal;

    public RegistryBrowserContentProvider(TreeViewer viewer, boolean showRunning) {
        this.viewer = viewer;
        this.showRunning = showRunning;
        this.numPluginsTotal = 0;
    }

    protected PluginObjectAdapter createAdapter(Object object, int id) {
        if (id == 1) {
            return new ExtensionAdapter(object);
        }
        if (id == 2) {
            return new ExtensionPointAdapter(object);
        }
        return new PluginObjectAdapter(object);
    }

    protected Object[] createPluginFolders(IPluginDescriptor pd) {
        Object[] array = new Object[]{new PluginFolder(pd, 3), new PluginFolder(pd, 4), new PluginFolder(pd, 2), new PluginFolder(pd, 1)};
        return array;
    }

    public void dispose() {
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object[] getChildren(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ExtensionAdapter) {
            return ((ExtensionAdapter)((Object)element)).getChildren();
        }
        this.isInExtensionSet = false;
        if (element instanceof ExtensionPointAdapter) {
            return ((ExtensionPointAdapter)((Object)element)).getChildren();
        }
        if (element instanceof ConfigurationElementAdapter) {
            return ((ConfigurationElementAdapter)((Object)element)).getChildren();
        }
        if (element instanceof PluginObjectAdapter) {
            element = ((PluginObjectAdapter)((Object)element)).getObject();
        }
        if (element.equals(Platform.getPluginRegistry())) {
            Object[] plugins = this.getPlugins(Platform.getPluginRegistry());
            if (plugins == null) {
                this.numPluginsTotal = 0;
                return new Object[0];
            }
            this.numPluginsTotal = plugins.length;
            if (this.showRunning) {
                ArrayList<Object> resultList = new ArrayList<Object>();
                int i = 0;
                while (i < plugins.length) {
                    Object object;
                    if (plugins[i] instanceof PluginObjectAdapter && (object = ((PluginObjectAdapter)((Object)plugins[i])).getObject()) instanceof IPluginDescriptor && ((IPluginDescriptor)object).isPluginActivated()) {
                        resultList.add(plugins[i]);
                    }
                    ++i;
                }
                return resultList.toArray(new Object[resultList.size()]);
            }
            return plugins;
        }
        if (element instanceof IPluginDescriptor) {
            IPluginDescriptor desc = (IPluginDescriptor)element;
            Object[] folders = (Object[])this.pluginMap.get(desc.getUniqueIdentifier());
            if (folders == null) {
                folders = this.createPluginFolders(desc);
                this.pluginMap.put(desc.getUniqueIdentifier(), folders);
            } else {
                ArrayList<Object> folderList = new ArrayList<Object>();
                int i = 0;
                while (i < folders.length) {
                    if (folders[i] != null && ((IPluginFolder)folders[i]).getChildren() != null) {
                        folderList.add(folders[i]);
                    }
                    ++i;
                }
                folders = folderList.toArray(new Object[folderList.size()]);
            }
            return folders;
        }
        if (element instanceof IPluginFolder) {
            IPluginFolder folder = (IPluginFolder)element;
            this.isInExtensionSet = folder.getFolderId() == 1;
            return ((IPluginFolder)element).getChildren();
        }
        if (element instanceof IConfigurationElement) {
            return ((IConfigurationElement)element).getChildren();
        }
        return null;
    }

    public Object[] getNonDuplicateLabelChildren(Object element) {
        ArrayList<Object> extList = new ArrayList<Object>();
        ArrayList<String> labelList = new ArrayList<String>();
        if (element instanceof IPluginFolder) {
            Object[] children = ((IPluginFolder)element).getChildren();
            if (children != null && this.isInExtensionSet) {
                int i = 0;
                while (i < children.length) {
                    IExtension ext = (IExtension)((ExtensionAdapter)((Object)children[i])).getObject();
                    String label = ((RegistryBrowserLabelProvider)this.viewer.getLabelProvider()).getText(ext);
                    if (label != null && label.length() != 0 && !labelList.contains(label)) {
                        labelList.add(label);
                        extList.add(children[i]);
                    }
                    ++i;
                }
                return extList.toArray(new Object[extList.size()]);
            }
            return children;
        }
        if (element instanceof ExtensionPointAdapter) {
            Object[] children = ((ExtensionPointAdapter)((Object)element)).getChildren();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    String label = ((RegistryBrowserLabelProvider)this.viewer.getLabelProvider()).getText(children[i]);
                    if (label != null && label.length() != 0 && !labelList.contains(label)) {
                        labelList.add(label);
                        extList.add(children[i]);
                    }
                    ++i;
                }
                return extList.toArray(new Object[extList.size()]);
            }
            return children;
        }
        return new Object[0];
    }

    public Object[] getPlugins(IPluginRegistry registry) {
        IPluginDescriptor[] descriptors = registry.getPluginDescriptors();
        Object[] result = new Object[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            result[i] = new PluginObjectAdapter(descriptors[i]);
            ++i;
        }
        return result;
    }

    private Object[] getFolderChildren(IPluginDescriptor pd, int id) {
        Object[] array = null;
        switch (id) {
            case 1: {
                array = pd.getExtensions();
                break;
            }
            case 2: {
                array = pd.getExtensionPoints();
                break;
            }
            case 3: {
                array = pd.getPluginPrerequisites();
                break;
            }
            case 4: {
                array = pd.getRuntimeLibraries();
                try {
                    if (array != null && array.length != 0) break;
                    Object classpath = Platform.getBundle((String)pd.getUniqueIdentifier()).getHeaders().get("Bundle-ClassPath");
                    return classpath == null ? null : ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpath.toString());
                }
                catch (BundleException bundleException) {}
            }
        }
        Object[] result = null;
        if (array != null && array.length > 0) {
            result = new Object[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = this.createAdapter(array[i], id);
                ++i;
            }
        }
        return result;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setShowRunning(boolean showRunning) {
        this.showRunning = showRunning;
    }

    public boolean isShowRunning() {
        return this.showRunning;
    }

    public String getTitleSummary() {
        if (this.viewer == null || this.viewer.getTree() == null) {
            return PDERuntimePlugin.getFormattedMessage("RegistryView.titleSummary", new String[]{"0", "0"});
        }
        return PDERuntimePlugin.getFormattedMessage("RegistryView.titleSummary", new String[]{new Integer(this.viewer.getTree().getItemCount()).toString(), new Integer(this.numPluginsTotal).toString()});
    }

    class PluginFolder
    implements IPluginFolder {
        private int id;
        IPluginDescriptor pd;
        private Object[] children;

        public PluginFolder(IPluginDescriptor pd, int id) {
            this.pd = pd;
            this.id = id;
        }

        public IPluginDescriptor getPluginDescriptor() {
            return this.pd;
        }

        public Object[] getChildren() {
            if (this.children == null) {
                this.children = RegistryBrowserContentProvider.this.getFolderChildren(this.pd, this.id);
            }
            return this.children;
        }

        public int getFolderId() {
            return this.id;
        }

        public Object getAdapter(Class key) {
            return null;
        }
    }
}

