/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.text.BlockBox;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowContainerLayout;
import org.eclipse.draw2d.text.LineBox;

public class BlockFlowLayout
extends FlowContainerLayout {
    private LineBox previousLine = null;
    BlockBox blockBox;

    public BlockFlowLayout(BlockFlow blockFlow) {
        super(blockFlow);
    }

    protected void cleanup() {
        this.previousLine = null;
        this.currentLine = null;
    }

    protected void createNewLine() {
        this.currentLine = new LineBox();
        this.setupLine(this.currentLine);
    }

    protected void endBlock() {
        this.context.addToCurrentLine(this.blockBox);
        this.context.endLine();
    }

    public void endLine() {
        if (this.currentLine == null) {
            return;
        }
        if (!this.currentLine.isOccupied()) {
            return;
        }
        this.layoutLine();
        LineBox box = this.currentLine;
        this.currentLine = this.previousLine;
        this.previousLine = box;
        this.setupLine(this.getCurrentLine());
    }

    public int getCurrentY() {
        return this.getCurrentLine().y;
    }

    protected final BlockFlow getBlockFlow() {
        return (BlockFlow)this.getFlowFigure();
    }

    protected void layoutLine() {
        this.currentLine.x = 0;
        switch (this.getBlockFlow().getHorizontalAligment()) {
            case 4: {
                this.currentLine.x = this.blockBox.getRecommendedWidth() - this.currentLine.getWidth();
                break;
            }
            case 2: {
                this.currentLine.x = (this.blockBox.getRecommendedWidth() - this.currentLine.getWidth()) / 2;
            }
        }
        this.currentLine.commit();
        this.blockBox.add(this.currentLine);
    }

    protected void flush() {
        if (this.currentLine != null) {
            this.layoutLine();
        }
        this.endBlock();
    }

    protected void preLayout() {
        this.blockBox = this.getBlockFlow().getBlockBox();
        this.setupBlock();
    }

    protected void setupBlock() {
        this.context.endLine();
        LineBox line = this.context.getCurrentLine();
        this.blockBox.clear();
        this.blockBox.setRecommendedWidth(line.getAvailableWidth());
        this.blockBox.y = this.context.getCurrentY();
        this.blockBox.x = 0;
    }

    protected void setupLine(LineBox line) {
        line.clear();
        line.setRecommendedWidth(this.blockBox.getRecommendedWidth());
        line.y = this.previousLine == null ? 0 : this.previousLine.y + this.previousLine.getHeight();
    }
}

