/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class IconAndMessageDialog
extends Dialog {
    protected String message;
    protected Label messageLabel;
    protected Label imageLabel;

    public IconAndMessageDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.imageLabel.setLayoutData((Object)new GridData(66));
        }
        if (this.message != null) {
            this.messageLabel = new Label(composite, this.getMessageLabelStyle());
            this.messageLabel.setText(this.message);
            GridData data = new GridData(770);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            this.messageLabel.setLayoutData((Object)data);
        }
        return composite;
    }

    protected int getMessageLabelStyle() {
        return 64;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected abstract Image getImage();

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7) * 3 / 2;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4) * 2;
        layout.makeColumnsEqualWidth = false;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.createDialogAndButtonArea(parent);
        return parent;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        this.dialogArea = this.createDialogArea(parent);
        this.buttonBar = this.createButtonBar(parent);
        Dialog.applyDialogFont((Control)parent);
    }

    public Image getErrorImage() {
        return this.getSWTImage(1);
    }

    public Image getWarningImage() {
        return this.getSWTImage(8);
    }

    public Image getInfoImage() {
        return this.getSWTImage(2);
    }

    public Image getQuestionImage() {
        return this.getSWTImage(4);
    }

    private Image getSWTImage(final int imageID) {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = this.getParentShell();
        }
        final Display display = shell == null ? Display.getCurrent() : shell.getDisplay();
        final Image[] image = new Image[1];
        display.syncExec(new Runnable(){

            public void run() {
                image[0] = display.getSystemImage(imageID);
            }
        });
        return image[0];
    }
}

