/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text.templates;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionTemplateMessages;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.osgi.framework.Bundle;

public class ContributionTemplateStore
extends TemplateStore {
    private static final String TEMPLATES_EXTENSION_POINT = "org.eclipse.ui.editors.templates";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CONTEXT_TYPE_ID = "contextTypeId";
    private static final String DESCRIPTION = "description";
    private static final String TEMPLATE = "template";
    private static final String PATTERN = "pattern";
    private static final String INCLUDE = "include";
    private static final String FILE = "file";
    private static final String TRANSLATIONS = "translations";

    public ContributionTemplateStore(IPreferenceStore store, String key) {
        super(store, key);
    }

    public ContributionTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, String key) {
        super(registry, store, key);
    }

    protected void loadContributedTemplates() throws IOException {
        IConfigurationElement[] extensions = ContributionTemplateStore.getTemplateExtensions();
        Collection contributed = this.readContributedTemplates(extensions);
        Iterator it = contributed.iterator();
        while (it.hasNext()) {
            TemplatePersistenceData data = (TemplatePersistenceData)it.next();
            this.internalAdd(data);
        }
    }

    private Collection readContributedTemplates(IConfigurationElement[] extensions) throws IOException {
        ArrayList templates = new ArrayList();
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getName().equals(TEMPLATE)) {
                this.createTemplate(templates, extensions[i]);
            } else if (extensions[i].getName().equals(INCLUDE)) {
                this.readIncludedTemplates(templates, extensions[i]);
            }
            ++i;
        }
        return templates;
    }

    private void readIncludedTemplates(Collection templates, IConfigurationElement element) throws IOException {
        Bundle plugin;
        URL url;
        String file = element.getAttributeAsIs(FILE);
        if (file != null && (url = Platform.find((Bundle)(plugin = Platform.getBundle((String)element.getDeclaringExtension().getNamespace())), (IPath)Path.fromOSString((String)file))) != null) {
            URL bundleURL;
            PropertyResourceBundle bundle = null;
            String translations = element.getAttributeAsIs(TRANSLATIONS);
            if (translations != null && (bundleURL = Platform.find((Bundle)plugin, (IPath)Path.fromOSString((String)translations))) != null) {
                bundle = new PropertyResourceBundle(bundleURL.openStream());
            }
            BufferedInputStream stream = new BufferedInputStream(url.openStream());
            TemplateReaderWriter reader = new TemplateReaderWriter();
            TemplatePersistenceData[] datas = reader.read((InputStream)stream, (ResourceBundle)bundle);
            int i = 0;
            while (i < datas.length) {
                TemplatePersistenceData data = datas[i];
                if (data.isCustom()) {
                    if (data.getId() == null) {
                        EditorsPlugin.logErrorMessage(String.valueOf(ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_prefix")) + data.getTemplate().getName() + " " + ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_postfix_no_id"));
                    } else {
                        EditorsPlugin.logErrorMessage(String.valueOf(ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_prefix")) + data.getTemplate().getName() + " " + ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_postfix_deleted"));
                    }
                } else if (!this.validateTemplate(data.getTemplate())) {
                    if (this.contextExists(data.getTemplate().getContextTypeId())) {
                        EditorsPlugin.logErrorMessage(String.valueOf(ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_prefix")) + data.getTemplate().getName() + " " + ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_postfix_validation_failed"));
                    }
                } else {
                    templates.add(data);
                }
                ++i;
            }
        }
    }

    private boolean validateTemplate(Template template) {
        String contextTypeId = template.getContextTypeId();
        if (!this.contextExists(contextTypeId)) {
            return false;
        }
        if (this.getRegistry() != null) {
            try {
                this.getRegistry().getContextType(contextTypeId).validate(template.getPattern());
            }
            catch (TemplateException templateException) {
                return false;
            }
        }
        return true;
    }

    private boolean contextExists(String contextTypeId) {
        return contextTypeId != null && (this.getRegistry() == null || this.getRegistry().getContextType(contextTypeId) != null);
    }

    private static IConfigurationElement[] getTemplateExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
    }

    private void createTemplate(Collection map, IConfigurationElement element) {
        String pattern;
        String name;
        String id;
        String contextTypeId = element.getAttributeAsIs(CONTEXT_TYPE_ID);
        if (this.contextExists(contextTypeId) && ContributionTemplateStore.isValidTemplateId(id = element.getAttributeAsIs(ID)) && (name = element.getAttribute(NAME)) != null && (pattern = element.getChildren(PATTERN)[0].getValue()) != null) {
            String desc = element.getAttribute(DESCRIPTION);
            if (desc == null) {
                desc = "";
            }
            Template template = new Template(name, desc, contextTypeId, pattern);
            TemplatePersistenceData data = new TemplatePersistenceData(template, true, id);
            if (this.validateTemplate(template)) {
                map.add(data);
            }
        }
    }

    private static boolean isValidTemplateId(String id) {
        return id != null && id.trim().length() != 0;
    }
}

