/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.wmf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.wmf.InputMeta;
import com.lowagie.text.pdf.wmf.MetaBrush;
import com.lowagie.text.pdf.wmf.MetaFont;
import com.lowagie.text.pdf.wmf.MetaObject;
import com.lowagie.text.pdf.wmf.MetaPen;
import com.lowagie.text.pdf.wmf.MetaState;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class MetaDo {
    public static final int META_SETBKCOLOR = 513;
    public static final int META_SETBKMODE = 258;
    public static final int META_SETMAPMODE = 259;
    public static final int META_SETROP2 = 260;
    public static final int META_SETRELABS = 261;
    public static final int META_SETPOLYFILLMODE = 262;
    public static final int META_SETSTRETCHBLTMODE = 263;
    public static final int META_SETTEXTCHAREXTRA = 264;
    public static final int META_SETTEXTCOLOR = 521;
    public static final int META_SETTEXTJUSTIFICATION = 522;
    public static final int META_SETWINDOWORG = 523;
    public static final int META_SETWINDOWEXT = 524;
    public static final int META_SETVIEWPORTORG = 525;
    public static final int META_SETVIEWPORTEXT = 526;
    public static final int META_OFFSETWINDOWORG = 527;
    public static final int META_SCALEWINDOWEXT = 1040;
    public static final int META_OFFSETVIEWPORTORG = 529;
    public static final int META_SCALEVIEWPORTEXT = 1042;
    public static final int META_LINETO = 531;
    public static final int META_MOVETO = 532;
    public static final int META_EXCLUDECLIPRECT = 1045;
    public static final int META_INTERSECTCLIPRECT = 1046;
    public static final int META_ARC = 2071;
    public static final int META_ELLIPSE = 1048;
    public static final int META_FLOODFILL = 1049;
    public static final int META_PIE = 2074;
    public static final int META_RECTANGLE = 1051;
    public static final int META_ROUNDRECT = 1564;
    public static final int META_PATBLT = 1565;
    public static final int META_SAVEDC = 30;
    public static final int META_SETPIXEL = 1055;
    public static final int META_OFFSETCLIPRGN = 544;
    public static final int META_TEXTOUT = 1313;
    public static final int META_BITBLT = 2338;
    public static final int META_STRETCHBLT = 2851;
    public static final int META_POLYGON = 804;
    public static final int META_POLYLINE = 805;
    public static final int META_ESCAPE = 1574;
    public static final int META_RESTOREDC = 295;
    public static final int META_FILLREGION = 552;
    public static final int META_FRAMEREGION = 1065;
    public static final int META_INVERTREGION = 298;
    public static final int META_PAINTREGION = 299;
    public static final int META_SELECTCLIPREGION = 300;
    public static final int META_SELECTOBJECT = 301;
    public static final int META_SETTEXTALIGN = 302;
    public static final int META_CHORD = 2096;
    public static final int META_SETMAPPERFLAGS = 561;
    public static final int META_EXTTEXTOUT = 2610;
    public static final int META_SETDIBTODEV = 3379;
    public static final int META_SELECTPALETTE = 564;
    public static final int META_REALIZEPALETTE = 53;
    public static final int META_ANIMATEPALETTE = 1078;
    public static final int META_SETPALENTRIES = 55;
    public static final int META_POLYPOLYGON = 1336;
    public static final int META_RESIZEPALETTE = 313;
    public static final int META_DIBBITBLT = 2368;
    public static final int META_DIBSTRETCHBLT = 2881;
    public static final int META_DIBCREATEPATTERNBRUSH = 322;
    public static final int META_STRETCHDIB = 3907;
    public static final int META_EXTFLOODFILL = 1352;
    public static final int META_DELETEOBJECT = 496;
    public static final int META_CREATEPALETTE = 247;
    public static final int META_CREATEPATTERNBRUSH = 505;
    public static final int META_CREATEPENINDIRECT = 762;
    public static final int META_CREATEFONTINDIRECT = 763;
    public static final int META_CREATEBRUSHINDIRECT = 764;
    public static final int META_CREATEREGION = 1791;
    public PdfContentByte cb;
    public InputMeta in;
    int left;
    int top;
    int right;
    int bottom;
    int inch;
    MetaState state = new MetaState();

    public MetaDo(InputStream inputStream, PdfContentByte pdfContentByte) {
        this.cb = pdfContentByte;
        this.in = new InputMeta(inputStream);
    }

    public void readAll() throws IOException, DocumentException {
        if (this.in.readInt() != -1698247209) {
            throw new DocumentException("Not a placeable windows metafile");
        }
        this.in.readWord();
        this.left = this.in.readShort();
        this.top = this.in.readShort();
        this.right = this.in.readShort();
        this.bottom = this.in.readShort();
        this.inch = this.in.readWord();
        this.state.setScalingX((float)(this.right - this.left) / (float)this.inch * 72.0f);
        this.state.setScalingY((float)(this.bottom - this.top) / (float)this.inch * 72.0f);
        this.in.readInt();
        this.in.readWord();
        this.in.skip(18);
        this.cb.setLineCap(1);
        this.cb.setLineJoin(1);
        while (true) {
            int n = this.in.getLength();
            int n2 = this.in.readInt();
            if (n2 < 3) break;
            int n3 = this.in.readWord();
            switch (n3) {
                case 0: {
                    break;
                }
                case 247: 
                case 322: 
                case 1791: {
                    this.state.addMetaObject(new MetaObject());
                    break;
                }
                case 762: {
                    MetaPen metaPen = new MetaPen();
                    metaPen.init(this.in);
                    this.state.addMetaObject(metaPen);
                    break;
                }
                case 764: {
                    MetaBrush metaBrush = new MetaBrush();
                    metaBrush.init(this.in);
                    this.state.addMetaObject(metaBrush);
                    break;
                }
                case 763: {
                    MetaFont metaFont = new MetaFont();
                    metaFont.init(this.in);
                    this.state.addMetaObject(metaFont);
                    break;
                }
                case 301: {
                    int n4 = this.in.readWord();
                    this.state.selectMetaObject(n4, this.cb);
                    break;
                }
                case 496: {
                    int n5 = this.in.readWord();
                    this.state.deleteMetaObject(n5);
                    break;
                }
                case 30: {
                    this.state.saveState(this.cb);
                    break;
                }
                case 295: {
                    int n6 = this.in.readShort();
                    this.state.restoreState(n6, this.cb);
                    break;
                }
                case 523: {
                    this.state.setOffsetWy(this.in.readShort());
                    this.state.setOffsetWx(this.in.readShort());
                    break;
                }
                case 524: {
                    this.state.setExtentWy(this.in.readShort());
                    this.state.setExtentWx(this.in.readShort());
                    break;
                }
                case 532: {
                    int n7 = this.in.readShort();
                    Point point = new Point(this.in.readShort(), n7);
                    this.state.setCurrentPoint(point);
                    break;
                }
                case 531: {
                    int n8 = this.in.readShort();
                    int n9 = this.in.readShort();
                    Point point = this.state.getCurrentPoint();
                    this.cb.moveTo(this.state.transformX(point.x), this.state.transformY(point.y));
                    this.cb.lineTo(this.state.transformX(n9), this.state.transformY(n8));
                    this.cb.stroke();
                    this.state.setCurrentPoint(new Point(n9, n8));
                    break;
                }
                case 805: {
                    this.state.setLineJoinPolygon(this.cb);
                    int n10 = this.in.readWord();
                    int n11 = this.in.readShort();
                    int n12 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n11), this.state.transformY(n12));
                    int n13 = 1;
                    while (n13 < n10) {
                        n11 = this.in.readShort();
                        n12 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n11), this.state.transformY(n12));
                        ++n13;
                    }
                    this.cb.stroke();
                    break;
                }
                case 804: {
                    if (this.isNullStrokeFill(false)) break;
                    int n14 = this.in.readWord();
                    int n15 = this.in.readShort();
                    int n16 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n15), this.state.transformY(n16));
                    int n17 = 1;
                    while (n17 < n14) {
                        int n18 = this.in.readShort();
                        int n19 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n18), this.state.transformY(n19));
                        ++n17;
                    }
                    this.cb.lineTo(this.state.transformX(n15), this.state.transformY(n16));
                    this.strokeAndFill();
                    break;
                }
                case 1336: {
                    int n20;
                    int n21;
                    if (this.isNullStrokeFill(false)) break;
                    int n22 = this.in.readWord();
                    int[] nArray = new int[n22];
                    int n23 = 0;
                    while (n23 < nArray.length) {
                        nArray[n23] = this.in.readWord();
                        ++n23;
                    }
                    int n24 = 0;
                    while (n24 < nArray.length) {
                        int n25 = nArray[n24];
                        int n26 = this.in.readShort();
                        n21 = this.in.readShort();
                        this.cb.moveTo(this.state.transformX(n26), this.state.transformY(n21));
                        int n27 = 1;
                        while (n27 < n25) {
                            int n28 = this.in.readShort();
                            n20 = this.in.readShort();
                            this.cb.lineTo(this.state.transformX(n28), this.state.transformY(n20));
                            ++n27;
                        }
                        this.cb.lineTo(this.state.transformX(n26), this.state.transformY(n21));
                        ++n24;
                    }
                    this.strokeAndFill();
                    break;
                }
                case 1048: {
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    int n29 = this.in.readShort();
                    int n30 = this.in.readShort();
                    int n31 = this.in.readShort();
                    int n32 = this.in.readShort();
                    this.cb.arc(this.state.transformX(n32), this.state.transformY(n29), this.state.transformX(n30), this.state.transformY(n31), 0.0f, 360.0f);
                    this.strokeAndFill();
                    break;
                }
                case 2071: {
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f2 = this.state.transformX(this.in.readShort());
                    float f3 = this.state.transformY(this.in.readShort());
                    float f4 = this.state.transformX(this.in.readShort());
                    float f5 = this.state.transformY(this.in.readShort());
                    float f6 = this.state.transformX(this.in.readShort());
                    float f7 = this.state.transformY(this.in.readShort());
                    float f8 = this.state.transformX(this.in.readShort());
                    float f9 = (f6 + f8) / 2.0f;
                    float f10 = (f7 + f5) / 2.0f;
                    float f11 = MetaDo.getArc(f9, f10, f4, f3);
                    float f12 = MetaDo.getArc(f9, f10, f2, f);
                    if ((f12 -= f11) <= 0.0f) {
                        f12 += 360.0f;
                    }
                    this.cb.arc(f8, f5, f6, f7, f11, f12);
                    this.cb.stroke();
                    break;
                }
                case 2074: {
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f13 = this.state.transformX(this.in.readShort());
                    float f14 = this.state.transformY(this.in.readShort());
                    float f15 = this.state.transformX(this.in.readShort());
                    float f16 = this.state.transformY(this.in.readShort());
                    float f17 = this.state.transformX(this.in.readShort());
                    float f18 = this.state.transformY(this.in.readShort());
                    float f19 = this.state.transformX(this.in.readShort());
                    float f20 = (f17 + f19) / 2.0f;
                    float f21 = (f18 + f16) / 2.0f;
                    float f22 = MetaDo.getArc(f20, f21, f15, f14);
                    float f23 = MetaDo.getArc(f20, f21, f13, f);
                    if ((f23 -= f22) <= 0.0f) {
                        f23 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f19, f16, f17, f18, f22, f23)).size() == 0) break;
                    float[] fArray = (float[])arrayList.get(0);
                    this.cb.moveTo(f20, f21);
                    this.cb.lineTo(fArray[0], fArray[1]);
                    int n33 = 0;
                    while (n33 < arrayList.size()) {
                        fArray = (float[])arrayList.get(n33);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                        ++n33;
                    }
                    this.cb.lineTo(f20, f21);
                    this.strokeAndFill();
                    break;
                }
                case 2096: {
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f24 = this.state.transformX(this.in.readShort());
                    float f25 = this.state.transformY(this.in.readShort());
                    float f26 = this.state.transformX(this.in.readShort());
                    float f27 = this.state.transformY(this.in.readShort());
                    float f28 = this.state.transformX(this.in.readShort());
                    float f29 = this.state.transformY(this.in.readShort());
                    float f30 = this.state.transformX(this.in.readShort());
                    float f31 = (f28 + f30) / 2.0f;
                    float f32 = (f29 + f27) / 2.0f;
                    float f33 = MetaDo.getArc(f31, f32, f26, f25);
                    float f34 = MetaDo.getArc(f31, f32, f24, f);
                    if ((f34 -= f33) <= 0.0f) {
                        f34 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f30, f27, f28, f29, f33, f34)).size() == 0) break;
                    float[] fArray = (float[])arrayList.get(0);
                    f31 = fArray[0];
                    f32 = fArray[1];
                    this.cb.moveTo(f31, f32);
                    int n33 = 0;
                    while (n33 < arrayList.size()) {
                        fArray = (float[])arrayList.get(n33);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                        ++n33;
                    }
                    this.cb.lineTo(f31, f32);
                    this.strokeAndFill();
                    break;
                }
                case 1051: {
                    if (this.isNullStrokeFill(true)) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f35 = this.state.transformX(this.in.readShort());
                    float f36 = this.state.transformY(this.in.readShort());
                    float f37 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f37, f, f35 - f37, f36 - f);
                    this.strokeAndFill();
                    break;
                }
                case 1046: {
                    float f = this.state.transformY(this.in.readShort());
                    float f38 = this.state.transformX(this.in.readShort());
                    float f39 = this.state.transformY(this.in.readShort());
                    float f40 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f40, f, f38 - f40, f39 - f);
                    this.cb.eoClip();
                    this.cb.newPath();
                    break;
                }
                case 2610: {
                    String string;
                    int n34 = this.in.readShort();
                    int n35 = this.in.readShort();
                    int n36 = this.in.readWord();
                    int n37 = this.in.readWord();
                    int n38 = 0;
                    int n39 = 0;
                    int n21 = 0;
                    int n40 = 0;
                    if ((n37 & 6) != 0) {
                        n38 = this.in.readShort();
                        n39 = this.in.readShort();
                        n21 = this.in.readShort();
                        n40 = this.in.readShort();
                    }
                    byte[] byArray = new byte[n36];
                    int n20 = 0;
                    while (n20 < n36) {
                        byte by = (byte)this.in.readByte();
                        if (by == 0) break;
                        byArray[n20] = by;
                        ++n20;
                    }
                    try {
                        string = new String(byArray, 0, n20, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n20);
                    }
                    this.outputText(n35, n34, n37, n38, n39, n21, n40, string);
                    break;
                }
                case 1313: {
                    String string;
                    int n41 = this.in.readWord();
                    byte[] byArray = new byte[n41];
                    int n42 = 0;
                    while (n42 < n41) {
                        byte by = (byte)this.in.readByte();
                        if (by == 0) break;
                        byArray[n42] = by;
                        ++n42;
                    }
                    try {
                        string = new String(byArray, 0, n42, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n42);
                    }
                    n41 = n41 + 1 & 0xFFFE;
                    this.in.skip(n41 - n42);
                    int n43 = this.in.readShort();
                    int n44 = this.in.readShort();
                    this.outputText(n44, n43, 0, 0, 0, 0, 0, string);
                    break;
                }
                case 513: {
                    this.state.setCurrentBackgroundColor(this.in.readColor());
                    break;
                }
                case 521: {
                    this.state.setCurrentTextColor(this.in.readColor());
                    break;
                }
                case 302: {
                    this.state.setTextAlign(this.in.readWord());
                    break;
                }
                case 258: {
                    this.state.setBackgroundMode(this.in.readWord());
                    break;
                }
                case 262: {
                    this.state.setPolyFillMode(this.in.readWord());
                    break;
                }
                case 1055: {
                    Color color = this.in.readColor();
                    int n45 = this.in.readShort();
                    int n46 = this.in.readShort();
                    this.cb.saveState();
                    this.cb.setColorFill(color);
                    this.cb.rectangle(this.state.transformX(n46), this.state.transformY(n45), 0.2f, 0.2f);
                    this.cb.fill();
                    this.cb.restoreState();
                }
            }
            this.in.skip(n2 * 2 - (this.in.getLength() - n));
        }
    }

    public void outputText(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) throws IOException {
        Color color;
        MetaFont metaFont = this.state.getCurrentFont();
        float f = this.state.transformX(n);
        float f2 = this.state.transformY(n2);
        float f3 = (float)Math.sin(metaFont.getAngle());
        float f4 = (float)Math.cos(metaFont.getAngle());
        float f5 = metaFont.getFontSize(this.state);
        BaseFont baseFont = metaFont.getFont();
        int n8 = this.state.getTextAlign();
        float f6 = baseFont.getWidthPoint(string, f5);
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = baseFont.getFontDescriptor(3, f5);
        float f10 = baseFont.getFontDescriptor(8, f5);
        this.cb.saveState();
        this.cb.concatCTM(f4, f3, -f3, f4, f, f2);
        if ((n8 & 6) == 6) {
            f7 = -f6 / 2.0f;
        } else if ((n8 & 2) == 2) {
            f7 = -f6;
        }
        f8 = (n8 & 0x18) == 24 ? 0.0f : ((n8 & 8) == 8 ? -f9 : -f10);
        if (this.state.getBackgroundMode() == 2) {
            color = this.state.getCurrentBackgroundColor();
            this.cb.setColorFill(color);
            this.cb.rectangle(f7, f8 + f9, f6, f10 - f9);
            this.cb.fill();
        }
        color = this.state.getCurrentTextColor();
        this.cb.setColorFill(color);
        this.cb.beginText();
        this.cb.setFontAndSize(baseFont, f5);
        this.cb.setTextMatrix(f7, f8);
        this.cb.showText(string);
        this.cb.endText();
        if (metaFont.isUnderline()) {
            this.cb.rectangle(f7, f8 - f5 / 4.0f, f6, f5 / 15.0f);
            this.cb.fill();
        }
        if (metaFont.isStrikeout()) {
            this.cb.rectangle(f7, f8 + f5 / 3.0f, f6, f5 / 15.0f);
            this.cb.fill();
        }
        this.cb.restoreState();
    }

    public boolean isNullStrokeFill(boolean bl) {
        boolean bl2;
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        boolean bl3 = metaPen.getStyle() == 5;
        int n = metaBrush.getStyle();
        boolean bl4 = n == 0 || n == 2 && this.state.getBackgroundMode() == 2;
        boolean bl5 = bl2 = bl3 && !bl4;
        if (!bl3) {
            if (bl) {
                this.state.setLineJoinRectangle(this.cb);
            } else {
                this.state.setLineJoinPolygon(this.cb);
            }
        }
        return bl2;
    }

    public void strokeAndFill() {
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        int n = metaPen.getStyle();
        int n2 = metaBrush.getStyle();
        if (n == 5) {
            this.cb.closePath();
            if (this.state.getPolyFillMode() == 1) {
                this.cb.eoFill();
            } else {
                this.cb.fill();
            }
        } else {
            boolean bl;
            boolean bl2 = bl = n2 == 0 || n2 == 2 && this.state.getBackgroundMode() == 2;
            if (bl) {
                if (this.state.getPolyFillMode() == 1) {
                    this.cb.closePathEoFillStroke();
                } else {
                    this.cb.closePathFillStroke();
                }
            } else {
                this.cb.closePathStroke();
            }
        }
    }

    static float getArc(float f, float f2, float f3, float f4) {
        double d = Math.atan2(f4 - f2, f3 - f);
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return (float)(d / Math.PI * 180.0);
    }
}

